/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.data;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import survivalistessentials.common.TagManager;
import survivalistessentials.data.integration.SurvivalistEssentialsIntegration;
import survivalistessentials.items.SurvivalistEssentialsItems;
import survivalistessentials.world.SurvivalistEssentialsWorld;

public class CommonItemTagsProvider
extends IntrinsicHolderTagsProvider<Item> {
    public CommonItemTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, Registries.ITEM, lookupProvider, item -> item.builtInRegistryHolder().key());
    }

    protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.builder(TagManager.Items.FLINT_KNAPPABLE, new ItemLike[]{Items.FLINT, SurvivalistEssentialsWorld.ROCK_STONE});
        this.tag(TagManager.Items.PICKAXE_TOOLS).addOptionalTag(TagManager.Items.MINING_TOOL_TOOLS.location()).addOptionalTag(SurvivalistEssentialsIntegration.mcLoc("pickaxes")).addOptional(SurvivalistEssentialsIntegration.tconLoc("pickaxe")).addOptional(SurvivalistEssentialsIntegration.tconLoc("pickadze")).addOptional(SurvivalistEssentialsIntegration.tconLoc("sledge_hammer")).addOptional(SurvivalistEssentialsIntegration.tconLoc("vein_hammer")).addOptional(SurvivalistEssentialsIntegration.tetraLoc("modular_sword")).addOptional(SurvivalistEssentialsIntegration.ieLoc("buzzsaw")).addOptional(SurvivalistEssentialsIntegration.ieLoc("drill")).addOptional(SurvivalistEssentialsIntegration.ieLoc("hammer"));
        this.tag(TagManager.Items.AXE_TOOLS).addOptionalTag(SurvivalistEssentialsIntegration.mcLoc("axes")).addOptional(SurvivalistEssentialsIntegration.tconLoc("mattock")).addOptional(SurvivalistEssentialsIntegration.tconLoc("hand_axe")).addOptional(SurvivalistEssentialsIntegration.tconLoc("broad_axe")).addOptional(SurvivalistEssentialsIntegration.ieLoc("buzzsaw"));
        this.builder(TagManager.Items.AXE_TOOLS, new ItemLike[]{SurvivalistEssentialsItems.CRUDE_HATCHET});
        this.tag(TagManager.Items.SAW_TOOLS).addOptional(SurvivalistEssentialsIntegration.tsLoc("saw"));
        this.builder(TagManager.Items.SAW_TOOLS, new ItemLike[]{SurvivalistEssentialsItems.CRUDE_SAW, SurvivalistEssentialsItems.BASIC_SAW, SurvivalistEssentialsItems.SHARP_SAW});
        this.tag(TagManager.Items.ADVANCED_SAW_TOOLS).addOptional(SurvivalistEssentialsIntegration.tsLoc("saw"));
        this.builder(TagManager.Items.ADVANCED_SAW_TOOLS, new ItemLike[]{SurvivalistEssentialsItems.BASIC_SAW, SurvivalistEssentialsItems.SHARP_SAW});
        this.tag(TagManager.Items.SHOVEL_TOOLS).addOptionalTag(SurvivalistEssentialsIntegration.mcLoc("shovels")).addOptional(SurvivalistEssentialsIntegration.tconLoc("mattock")).addOptional(SurvivalistEssentialsIntegration.tconLoc("pickadze")).addOptional(SurvivalistEssentialsIntegration.tconLoc("excavator")).addOptional(SurvivalistEssentialsIntegration.ieLoc("drill"));
        this.tag(TagManager.Items.HOE_TOOLS).addOptionalTag(SurvivalistEssentialsIntegration.mcLoc("hoes")).addOptional(SurvivalistEssentialsIntegration.tconLoc("mattock")).addOptional(SurvivalistEssentialsIntegration.tconLoc("kama"));
        this.tag(TagManager.Items.KNIFE_TOOLS).addOptional(SurvivalistEssentialsIntegration.tsLoc("knife"));
        this.builder(TagManager.Items.KNIFE_TOOLS, new ItemLike[]{SurvivalistEssentialsItems.CRUDE_KNIFE, SurvivalistEssentialsItems.BASIC_KNIFE, SurvivalistEssentialsItems.SHARP_KNIFE});
        this.tag(TagManager.Items.ADVANCED_KNIFE_TOOLS).addOptional(SurvivalistEssentialsIntegration.tsLoc("knife"));
        this.builder(TagManager.Items.ADVANCED_KNIFE_TOOLS, new ItemLike[]{SurvivalistEssentialsItems.BASIC_KNIFE, SurvivalistEssentialsItems.SHARP_KNIFE});
        this.tag(TagManager.Items.SHARP_TOOLS).addOptional(SurvivalistEssentialsIntegration.tconLoc("kama")).addOptional(SurvivalistEssentialsIntegration.tconLoc("dagger")).addOptional(SurvivalistEssentialsIntegration.tconLoc("cleaver")).addOptional(SurvivalistEssentialsIntegration.tconLoc("sword")).addOptional(SurvivalistEssentialsIntegration.ieLoc("revolver")).addOptional(SurvivalistEssentialsIntegration.tetraLoc("modular_sword")).addOptionalTag(SurvivalistEssentialsIntegration.mcLoc("swords")).addTag(TagManager.Items.KNIFE_TOOLS).addTag(TagManager.Items.AXE_TOOLS);
        this.tag(TagManager.Items.SHEAR_TOOLS).addOptionalTag(TagManager.Items.TOOLS_SHEAR.location());
        this.builder(TagManager.Items.ROCK, new ItemLike[]{SurvivalistEssentialsWorld.ROCK_STONE});
        this.builder(TagManager.Items.SAW_PARTS, new ItemLike[]{SurvivalistEssentialsItems.SAW_HANDLE, SurvivalistEssentialsItems.CRUDE_SAW_BLADE});
        this.builder(TagManager.Items.BANDAGES, new ItemLike[]{SurvivalistEssentialsItems.CRUDE_BANDAGE, SurvivalistEssentialsItems.BANDAGE});
        this.tag(TagManager.Items.COOKED_MEAT).add((Object)Items.COOKED_BEEF).add((Object)Items.COOKED_CHICKEN).add((Object)Items.COOKED_COD).add((Object)Items.COOKED_MUTTON).add((Object)Items.COOKED_PORKCHOP).add((Object)Items.COOKED_RABBIT).add((Object)Items.COOKED_SALMON).addOptional(SurvivalistEssentialsIntegration.aquaLoc("fish_fillet_cooked")).addOptional(SurvivalistEssentialsIntegration.aquaLoc("frog_legs_cooked")).addOptional(SurvivalistEssentialsIntegration.bapLoc("turkey_cooked")).addOptional(SurvivalistEssentialsIntegration.bapLoc("venisoncooked")).addOptional(SurvivalistEssentialsIntegration.bapLoc("pheasantcooked")).addOptional(SurvivalistEssentialsIntegration.bapLoc("crab_meat_cooked")).addOptional(SurvivalistEssentialsIntegration.bapLoc("turkey_leg_cooked")).addOptional(SurvivalistEssentialsIntegration.bapLoc("eel_meat_cooked")).addOptional(SurvivalistEssentialsIntegration.bapLoc("calamari_cooked")).addOptional(SurvivalistEssentialsIntegration.alexLoc("cooked_lobster_tail")).addOptional(SurvivalistEssentialsIntegration.alexLoc("cooked_moose_ribs")).addOptional(SurvivalistEssentialsIntegration.alexLoc("cooked_kangaroo_meat")).addOptional(SurvivalistEssentialsIntegration.alexLoc("cooked_catfish"));
        this.addLogVariants(TagManager.Items.CHERRY_LOGS, "cherry", SurvivalistEssentialsIntegration::ftLoc);
        this.addLogVariants(TagManager.Items.CITRUS_LOGS, "citrus", SurvivalistEssentialsIntegration::ftLoc);
        this.tag(TagManager.Items.BMO_ANCIENT_OAK_LOG).addOptional(SurvivalistEssentialsIntegration.BMO_ANCIENT_OAK_LOG);
        this.tag(TagManager.Items.BMO_STRIPPED_ANCIENT_OAK_LOG).addOptional(SurvivalistEssentialsIntegration.BMO_STRIPPED_ANCIENT_OAK_LOG);
        this.tag(TagManager.Items.BMO_ANCIENT_OAK_WOOD).addOptional(SurvivalistEssentialsIntegration.BMO_ANCIENT_OAK_WOOD);
        this.tag(TagManager.Items.BMO_STRIPPED_ANCIENT_OAK_WOOD).addOptional(SurvivalistEssentialsIntegration.BMO_STRIPPED_ANCIENT_OAK_WOOD);
        this.tag(TagManager.Items.BMO_BLIGHTED_BALSA_LOG).addOptional(SurvivalistEssentialsIntegration.BMO_BLIGHTED_BALSA_LOG);
        this.tag(TagManager.Items.BMO_STRIPPED_BLIGHTED_BALSA_LOG).addOptional(SurvivalistEssentialsIntegration.BMO_STRIPPED_BLIGHTED_BALSA_LOG);
        this.tag(TagManager.Items.BMO_BLIGHTED_BALSA_WOOD).addOptional(SurvivalistEssentialsIntegration.BMO_BLIGHTED_BALSA_WOOD);
        this.tag(TagManager.Items.BMO_STRIPPED_BLIGHTED_BALSA_WOOD).addOptional(SurvivalistEssentialsIntegration.BMO_STRIPPED_BLIGHTED_BALSA_WOOD);
        this.tag(TagManager.Items.BMO_SWAMP_CYPRESS_LOG).addOptional(SurvivalistEssentialsIntegration.BMO_SWAMP_CYPRESS_LOG);
        this.tag(TagManager.Items.BMO_STRIPPED_SWAMP_CYPRESS_LOG).addOptional(SurvivalistEssentialsIntegration.BMO_STRIPPED_SWAMP_CYPRESS_LOG);
        this.tag(TagManager.Items.BMO_SWAMP_CYPRESS_WOOD).addOptional(SurvivalistEssentialsIntegration.BMO_SWAMP_CYPRESS_WOOD);
        this.tag(TagManager.Items.BMO_STRIPPED_SWAMP_CYPRESS_WOOD).addOptional(SurvivalistEssentialsIntegration.BMO_STRIPPED_SWAMP_CYPRESS_WOOD);
        this.tag(TagManager.Items.BMO_WILLOW_LOG).addOptional(SurvivalistEssentialsIntegration.BMO_WILLOW_LOG);
        this.tag(TagManager.Items.BMO_STRIPPED_WILLOW_LOG).addOptional(SurvivalistEssentialsIntegration.BMO_STRIPPED_WILLOW_LOG);
        this.tag(TagManager.Items.BMO_WILLOW_WOOD).addOptional(SurvivalistEssentialsIntegration.BMO_WILLOW_WOOD);
        this.tag(TagManager.Items.BMO_STRIPPED_WILLOW_WOOD).addOptional(SurvivalistEssentialsIntegration.BMO_STRIPPED_WILLOW_WOOD);
        this.addLogVariants(TagManager.Items.BOP_DEAD_LOGS, "dead", SurvivalistEssentialsIntegration::bopLoc);
        this.addLogVariants(TagManager.Items.BOP_FIR_LOGS, "fir", SurvivalistEssentialsIntegration::bopLoc);
        this.addLogVariants(TagManager.Items.BOP_HELLBARK_LOGS, "hellbark", SurvivalistEssentialsIntegration::bopLoc);
        this.addLogVariants(TagManager.Items.BOP_JACARANDA_LOGS, "jacaranda", SurvivalistEssentialsIntegration::bopLoc);
        this.addLogVariants(TagManager.Items.BOP_MAGIC_LOGS, "magic", SurvivalistEssentialsIntegration::bopLoc);
        this.addLogVariants(TagManager.Items.BOP_MAHOGANY_LOGS, "mahogany", SurvivalistEssentialsIntegration::bopLoc);
        this.addLogVariants(TagManager.Items.BOP_PALM_LOGS, "palm", SurvivalistEssentialsIntegration::bopLoc);
        this.addLogVariants(TagManager.Items.BOP_REDWOOD_LOGS, "redwood", SurvivalistEssentialsIntegration::bopLoc);
        this.addLogVariants(TagManager.Items.BOP_UMBRAN_LOGS, "umbran", SurvivalistEssentialsIntegration::bopLoc);
        this.addLogVariants(TagManager.Items.BOP_WILLOW_LOGS, "willow", SurvivalistEssentialsIntegration::bopLoc);
        this.addLogVariants(TagManager.Items.BOTANIA_DREAMWOOD_LOGS, "dreamwood", SurvivalistEssentialsIntegration::botaniaLoc);
        this.addLogVariants(TagManager.Items.BOTANIA_LIVINGWOOD_LOGS, "livingwood", SurvivalistEssentialsIntegration::botaniaLoc);
        this.addLogVariants(TagManager.Items.QUARK_AZALEA_LOGS, "azalea", SurvivalistEssentialsIntegration::qLoc);
        this.addLogVariants(TagManager.Items.QUARK_BLOSSOM_LOGS, "blossom", SurvivalistEssentialsIntegration::qLoc);
        this.addLogVariants(TagManager.Items.AYCE_HAZEL_LOGS, "hazel", SurvivalistEssentialsIntegration::ayceLoc);
        this.addLogVariants(TagManager.Items.TCON_BLOODSHROOM_LOGS, "bloodshroom", SurvivalistEssentialsIntegration::tconLoc);
        this.addLogVariants(TagManager.Items.TCON_GREENHEART_LOGS, "greenheart", SurvivalistEssentialsIntegration::tconLoc);
        this.addLogVariants(TagManager.Items.TCON_SKYROOT_LOGS, "skyroot", SurvivalistEssentialsIntegration::tconLoc);
        this.addSimpleLogVariants(TagManager.Items.WS_PALM_TREE_LOGS, "palm_tree", SurvivalistEssentialsIntegration::wsLoc);
        this.addLogVariants(TagManager.Items.UNDERGARDEN_GRONGLE_LOGS, "grongle", SurvivalistEssentialsIntegration::undergardenLoc);
        this.addLogVariants(TagManager.Items.UNDERGARDEN_SMOGSTEM_LOGS, "smogstem", SurvivalistEssentialsIntegration::undergardenLoc);
        this.addLogVariants(TagManager.Items.UNDERGARDEN_WIGGLEWOOD_LOGS, "wigglewood", SurvivalistEssentialsIntegration::undergardenLoc);
        this.addLogVariants(TagManager.Items.BYG_WHITE_MANGROVE_LOGS, "white_mangrove", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_REDWOOD_LOGS, "redwood", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_BLUE_ENCHANTED_LOGS, "blue_enchanted", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_GREEN_ENCHANTED_LOGS, "green_enchanted", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_MAHOGANY_LOGS, "mahogany", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_BAOBAB_LOGS, "baobab", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_JACARANDA_LOGS, "jacaranda", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_CYPRESS_LOGS, "cypress", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_PALM_LOGS, "palm", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_EBONY_LOGS, "ebony", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_RAINBOW_EUCALYPTUS_LOGS, "rainbow_eucalyptus", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_ASPEN_LOGS, "aspen", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_FIR_LOGS, "fir", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_SKYRIS_LOGS, "skyris", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_CIKA_LOGS, "cika", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_HOLLY_LOGS, "holly", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_MAPLE_LOGS, "maple", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_PINE_LOGS, "pine", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_WILLOW_LOGS, "willow", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_WITCH_HAZEL_LOGS, "witch_hazel", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_ZELKOVA_LOGS, "zelkova", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_IRONWOOD_LOGS, "ironwood", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_SAKURA_LOGS, "sakura", SurvivalistEssentialsIntegration::bygLoc);
        this.addLogVariants(TagManager.Items.BYG_SPIRIT_LOGS, "spirit", SurvivalistEssentialsIntegration::bygLoc);
        this.tag(TagManager.Items.BYG_PALO_VERDE_LOGS).addOptionalTag(SurvivalistEssentialsIntegration.bygLoc("palo_verde_logs"));
        this.tag(TagManager.Items.BYG_FLORUS_STEMS).addOptionalTag(SurvivalistEssentialsIntegration.bygLoc("florus_logs"));
        this.tag(TagManager.Items.TF_GIANT_LOGS).addOptional(SurvivalistEssentialsIntegration.tfLoc("giant_log"));
        this.tag(TagManager.Items.TF_CANOPY_LOG).addOptional(SurvivalistEssentialsIntegration.TF_CANOPY_LOG);
        this.tag(TagManager.Items.TF_CANOPY_STRIPPED_LOG).addOptional(SurvivalistEssentialsIntegration.TF_CANOPY_STRIPPED_LOG);
        this.tag(TagManager.Items.TF_CANOPY_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_CANOPY_WOOD);
        this.tag(TagManager.Items.TF_CANOPY_STRIPPED_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_CANOPY_STRIPPED_WOOD);
        this.tag(TagManager.Items.TF_DARK_LOG).addOptional(SurvivalistEssentialsIntegration.TF_DARK_LOG);
        this.tag(TagManager.Items.TF_DARK_STRIPPED_LOG).addOptional(SurvivalistEssentialsIntegration.TF_DARK_STRIPPED_LOG);
        this.tag(TagManager.Items.TF_DARK_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_DARK_WOOD);
        this.tag(TagManager.Items.TF_DARK_STRIPPED_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_DARK_STRIPPED_WOOD);
        this.tag(TagManager.Items.TF_MANGROVE_LOG).addOptional(SurvivalistEssentialsIntegration.TF_MANGROVE_LOG);
        this.tag(TagManager.Items.TF_MANGROVE_STRIPPED_LOG).addOptional(SurvivalistEssentialsIntegration.TF_MANGROVE_STRIPPED_LOG);
        this.tag(TagManager.Items.TF_MANGROVE_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_MANGROVE_WOOD);
        this.tag(TagManager.Items.TF_MANGROVE_STRIPPED_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_MANGROVE_STRIPPED_WOOD);
        this.tag(TagManager.Items.TF_MINING_LOG).addOptional(SurvivalistEssentialsIntegration.TF_MINING_LOG);
        this.tag(TagManager.Items.TF_MINING_STRIPPED_LOG).addOptional(SurvivalistEssentialsIntegration.TF_MINING_STRIPPED_LOG);
        this.tag(TagManager.Items.TF_MINING_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_MINING_WOOD);
        this.tag(TagManager.Items.TF_MINING_STRIPPED_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_MINING_STRIPPED_WOOD);
        this.tag(TagManager.Items.TF_SORTING_LOG).addOptional(SurvivalistEssentialsIntegration.TF_SORTING_LOG);
        this.tag(TagManager.Items.TF_SORTING_STRIPPED_LOG).addOptional(SurvivalistEssentialsIntegration.TF_SORTING_STRIPPED_LOG);
        this.tag(TagManager.Items.TF_SORTING_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_SORTING_WOOD);
        this.tag(TagManager.Items.TF_SORTING_STRIPPED_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_SORTING_STRIPPED_WOOD);
        this.tag(TagManager.Items.TF_TIME_LOG).addOptional(SurvivalistEssentialsIntegration.TF_TIME_LOG);
        this.tag(TagManager.Items.TF_TIME_STRIPPED_LOG).addOptional(SurvivalistEssentialsIntegration.TF_TIME_STRIPPED_LOG);
        this.tag(TagManager.Items.TF_TIME_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_TIME_WOOD);
        this.tag(TagManager.Items.TF_TIME_STRIPPED_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_TIME_STRIPPED_WOOD);
        this.tag(TagManager.Items.TF_TRANSFORMATION_LOG).addOptional(SurvivalistEssentialsIntegration.TF_TRANSFORMATION_LOG);
        this.tag(TagManager.Items.TF_TRANSFORMATION_STRIPPED_LOG).addOptional(SurvivalistEssentialsIntegration.TF_TRANSFORMATION_STRIPPED_LOG);
        this.tag(TagManager.Items.TF_TRANSFORMATION_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_TRANSFORMATION_WOOD);
        this.tag(TagManager.Items.TF_TRANSFORMATION_STRIPPED_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_TRANSFORMATION_STRIPPED_WOOD);
        this.tag(TagManager.Items.TF_TWILIGHT_OAK_LOG).addOptional(SurvivalistEssentialsIntegration.TF_TWILIGHT_OAK_LOG);
        this.tag(TagManager.Items.TF_TWILIGHT_OAK_STRIPPED_LOG).addOptional(SurvivalistEssentialsIntegration.TF_TWILIGHT_OAK_STRIPPED_LOG);
        this.tag(TagManager.Items.TF_TWILIGHT_OAK_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_TWILIGHT_OAK_WOOD);
        this.tag(TagManager.Items.TF_TWILIGHT_OAK_STRIPPED_WOOD).addOptional(SurvivalistEssentialsIntegration.TF_TWILIGHT_OAK_STRIPPED_WOOD);
        this.addLogVariants(TagManager.Items.ECO_COCONUT_LOGS, "coconut", SurvivalistEssentialsIntegration::ecoLoc);
        this.addLogVariants(TagManager.Items.ECO_WALNUT_LOGS, "walnut", SurvivalistEssentialsIntegration::ecoLoc);
        this.addLogVariants(TagManager.Items.ECO_AZALEA_LOGS, "azalea", SurvivalistEssentialsIntegration::ecoLoc);
        this.addLogVariants(TagManager.Items.ECO_FLOWERING_AZALEA_LOGS, "flowering_azalea", SurvivalistEssentialsIntegration::ecoLoc);
        this.addSoulwoodVariants(TagManager.Items.MALUM_RUNEWOOD_LOGS, "runewood");
        this.addRunewoodVariants(TagManager.Items.MALUM_SOULWOOD_LOGS, "soulwood");
        this.tag(TagManager.Items.IFD_DREADWOOD_LOGS).addOptional(SurvivalistEssentialsIntegration.ifdLoc("dreadwood_log"));
        this.tag(TagManager.Items.AQUA_DRIFTWOOD).addOptional(SurvivalistEssentialsIntegration.aquaLoc("driftwood"));
        this.tag(TagManager.Items.IE_TREATED_WOOD).addOptional(SurvivalistEssentialsIntegration.ieLoc("treated_wood_horizontal")).addOptional(SurvivalistEssentialsIntegration.ieLoc("treated_wood_vertical")).addOptional(SurvivalistEssentialsIntegration.ieLoc("treated_wood_packaged"));
        this.tag(TagManager.Items.RU_ALPHA_LOGS).addOptional(SurvivalistEssentialsIntegration.regionsLoc("alpha_log"));
        this.addLogVariants(TagManager.Items.RU_BAOBAB_LOGS, "baobab", SurvivalistEssentialsIntegration::regionsLoc);
        this.addLogVariants(TagManager.Items.RU_BLACKWOOD_LOGS, "blackwood", SurvivalistEssentialsIntegration::regionsLoc);
        this.addShroomVariants(TagManager.Items.RU_BIOSHROOM_LOGS, "bioshroom", SurvivalistEssentialsIntegration::regionsLoc);
        this.addShroomVariants(TagManager.Items.RU_BLUE_BIOSHROOM_LOGS, "blue_bioshroom", SurvivalistEssentialsIntegration::regionsLoc);
        this.addSimpleLogVariants(TagManager.Items.RU_BRIMWOOD_LOGS, "brimwood", SurvivalistEssentialsIntegration::regionsLoc).addOptional(SurvivalistEssentialsIntegration.regionsLoc("brimwood_log_magma")).addOptional(SurvivalistEssentialsIntegration.regionsLoc("brimwood_wood"));
        this.addLogVariants(TagManager.Items.RU_COBALT_LOGS, "cobalt", SurvivalistEssentialsIntegration::regionsLoc);
        this.addLogVariants(TagManager.Items.RU_CYPRESS_LOGS, "cypress", SurvivalistEssentialsIntegration::regionsLoc);
        this.addLogVariants(TagManager.Items.RU_DEAD_LOGS, "dead", SurvivalistEssentialsIntegration::regionsLoc).addOptional(SurvivalistEssentialsIntegration.regionsLoc("ashen_log")).addOptional(SurvivalistEssentialsIntegration.regionsLoc("ashen_wood"));
        this.addLogVariants(TagManager.Items.RU_EUCALYPTUS_LOGS, "eucalyptus", SurvivalistEssentialsIntegration::regionsLoc);
        this.addShroomVariants(TagManager.Items.RU_GREEN_BIOSHROOM_LOGS, "green_bioshroom", SurvivalistEssentialsIntegration::regionsLoc);
        this.addLogVariants(TagManager.Items.RU_JOSHUA_LOGS, "joshua", SurvivalistEssentialsIntegration::regionsLoc);
        this.addLogVariants(TagManager.Items.RU_KAPOK_LOGS, "kapok", SurvivalistEssentialsIntegration::regionsLoc);
        this.addLogVariants(TagManager.Items.RU_LARCH_LOGS, "larch", SurvivalistEssentialsIntegration::regionsLoc);
        this.addLogVariants(TagManager.Items.RU_MAGNOLIA_LOGS, "magnolia", SurvivalistEssentialsIntegration::regionsLoc);
        this.addLogVariants(TagManager.Items.RU_MAPLE_LOGS, "maple", SurvivalistEssentialsIntegration::regionsLoc);
        this.addLogVariants(TagManager.Items.RU_MAUVE_LOGS, "mauve", SurvivalistEssentialsIntegration::regionsLoc);
        this.addLogVariants(TagManager.Items.RU_PALM_LOGS, "palm", SurvivalistEssentialsIntegration::regionsLoc);
        this.addLogVariants(TagManager.Items.RU_PINE_LOGS, "pine", SurvivalistEssentialsIntegration::regionsLoc);
        this.addShroomVariants(TagManager.Items.RU_PINK_BIOSHROOM_LOGS, "pink_bioshroom", SurvivalistEssentialsIntegration::regionsLoc);
        this.addLogVariants(TagManager.Items.RU_REDWOOD_LOGS, "redwood", SurvivalistEssentialsIntegration::regionsLoc);
        this.addLogVariants(TagManager.Items.RU_SOCOTRA_LOGS, "socotra", SurvivalistEssentialsIntegration::regionsLoc);
        this.addLogVariants(TagManager.Items.RU_WILLOW_LOGS, "willow", SurvivalistEssentialsIntegration::regionsLoc);
        this.addShroomVariants(TagManager.Items.RU_YELLOW_BIOSHROOM_LOGS, "yellow_bioshroom", SurvivalistEssentialsIntegration::regionsLoc);
    }

    private TagsProvider.TagAppender<Item> addSimpleLogVariants(TagKey<Item> tag, String type, Function<String, ResourceLocation> modLoc) {
        return this.tag(tag).addOptional(modLoc.apply(type + "_log")).addOptional(SurvivalistEssentialsIntegration.wsLoc("stripped_" + type + "_log"));
    }

    private void addShroomVariants(TagKey<Item> tag, String type, Function<String, ResourceLocation> modLoc) {
        this.tag(tag).addOptional(modLoc.apply(type + "_hyphae")).addOptional(modLoc.apply("stripped_" + type + "_hyphae")).addOptional(modLoc.apply(type + "_stem")).addOptional(SurvivalistEssentialsIntegration.wsLoc("stripped_" + type + "_stem"));
    }

    private TagsProvider.TagAppender<Item> addLogVariants(TagKey<Item> tag, String type, Function<String, ResourceLocation> modLoc) {
        return this.tag(tag).addOptional(modLoc.apply(type + "_log")).addOptional(modLoc.apply("stripped_" + type + "_log")).addOptional(modLoc.apply(type + "_wood")).addOptional(modLoc.apply("stripped_" + type + "_wood"));
    }

    private void addRunewoodVariants(TagKey<Item> tag, String type) {
        this.tag(tag).addOptional(SurvivalistEssentialsIntegration.malumLoc(type)).addOptional(SurvivalistEssentialsIntegration.malumLoc(type + "_log")).addOptional(SurvivalistEssentialsIntegration.malumLoc("stripped_" + type + "_log")).addOptional(SurvivalistEssentialsIntegration.malumLoc("exposed_" + type + "_log")).addOptional(SurvivalistEssentialsIntegration.malumLoc("revealed_" + type + "_log"));
    }

    private void addSoulwoodVariants(TagKey<Item> tag, String type) {
        this.tag(tag).addOptional(SurvivalistEssentialsIntegration.malumLoc(type)).addOptional(SurvivalistEssentialsIntegration.malumLoc(type + "_log")).addOptional(SurvivalistEssentialsIntegration.malumLoc("stripped_" + type)).addOptional(SurvivalistEssentialsIntegration.malumLoc("stripped_" + type + "_log")).addOptional(SurvivalistEssentialsIntegration.malumLoc("blighted_" + type)).addOptional(SurvivalistEssentialsIntegration.malumLoc("exposed_" + type + "_log")).addOptional(SurvivalistEssentialsIntegration.malumLoc("revealed_" + type + "_log"));
    }

    private void builder(TagKey<Item> tag, ItemLike ... items) {
        this.tag(tag).add((Object[])((Item[])Arrays.stream(items).map(ItemLike::asItem).toArray(Item[]::new)));
    }
}

