/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.jei;

import java.util.Collections;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import survivalistessentials.config.ConfigHandler;
import survivalistessentials.items.SurvivalistEssentialsItems;
import survivalistessentials.platform.Services;
import survivalistessentials.util.ResourceLocationHelper;
import survivalistessentials.world.SurvivalistEssentialsWorld;

@JeiPlugin
public class SurvivalistEssentialsJeiPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocationHelper.prefix("jei_plugin");
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        this.addIngredientInfo(registry, SurvivalistEssentialsWorld.ROCK_STONE);
        this.addIngredientInfo(registry, SurvivalistEssentialsItems.PLANT_FIBER);
        this.addIngredientInfo(registry, SurvivalistEssentialsItems.FLINT_SHARD);
        this.addIngredientInfo(registry, Items.STICK);
        if (Services.PLATFORM.isModLoaded("tinkersurvival")) {
            registry.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)SurvivalistEssentialsItems.BASIC_SAW_BLADE)));
            registry.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)SurvivalistEssentialsItems.SHARP_SAW_BLADE)));
            registry.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)SurvivalistEssentialsItems.BASIC_SAW)));
            registry.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)SurvivalistEssentialsItems.SHARP_SAW)));
            registry.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)SurvivalistEssentialsItems.BASIC_KNIFE)));
            registry.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)SurvivalistEssentialsItems.SHARP_KNIFE)));
        }
        if (ConfigHandler.Common.disableModpackBook()) {
            registry.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)SurvivalistEssentialsItems.MODPACK_BOOK)));
        }
    }

    private void addIngredientInfo(IRecipeRegistration registry, Item item) {
        String name = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        registry.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)("jei.survivalistessentials.description." + name))});
    }
}

