/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.util;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import survivalistessentials.common.TagManager;

public enum ToolType {
    PICKAXE(TagManager.Items.PICKAXE_TOOLS),
    AXE(TagManager.Items.AXE_TOOLS),
    SHOVEL(TagManager.Items.SHOVEL_TOOLS),
    HOE(TagManager.Items.HOE_TOOLS),
    SHARP(TagManager.Items.SHARP_TOOLS),
    NONE(null);

    @Nullable
    private final TagKey<Item> tag;

    private ToolType(TagKey<Item> tag) {
        this.tag = tag;
    }

    public boolean is(Item item) {
        if (this.tag == null) {
            return false;
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        AtomicBoolean hasKey = new AtomicBoolean(false);
        stack.getTags().takeWhile(n -> !hasKey.get()).filter(tagKey -> this.tag == tagKey).map(tagKey -> true).forEach(hasKey::set);
        return hasKey.get();
    }
}

