/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.world.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LooseRockBlock
extends Block {
    public static final VoxelShape rockHitbox = LooseRockBlock.box((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)2.0, (double)11.0);

    public LooseRockBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.CLAY).sound(SoundType.STONE).strength(0.0f).noCollission().noOcclusion());
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!state.canSurvive((LevelReader)worldIn, pos) && !worldIn.isClientSide) {
            worldIn.destroyBlock(pos, true);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState stateUnder = worldIn.getBlockState(pos.below());
        return stateUnder.isFaceSturdy((BlockGetter)worldIn, pos.below(), Direction.UP);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return rockHitbox;
    }
}

