/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import survivalistessentials.SurvivalistEssentials;
import survivalistessentials.common.TagManager;
import survivalistessentials.config.ConfigHandler;
import survivalistessentials.mixin.AbstractBlockAccessor;
import survivalistessentials.mixin.AbstractBlockStateAccessor;
import survivalistessentials.util.ItemUse;
import survivalistessentials.util.ResourceLocationHelper;
import survivalistessentials.util.ToolType;

public final class HarvestBlock {
    public static final Map<class_2248, ToolType> BLOCK_TOOL_TYPES = new HashMap<class_2248, ToolType>();
    public static final Map<class_1792, ToolType> ITEM_TOOL_TYPES = new HashMap<class_1792, ToolType>();

    public static void init() {
        class_7923.field_41175.forEach(block -> {
            AbstractBlockAccessor blockAccess = (AbstractBlockAccessor)block;
            class_4970.class_2251 settings = blockAccess.getProperties();
            settings.method_29292();
            for (class_2680 state : block.method_9595().method_11662()) {
                AbstractBlockStateAccessor abstractState = (AbstractBlockStateAccessor)state;
                abstractState.setRequiresCorrectToolForDrops(true);
            }
        });
    }

    public static void setup() {
        BLOCK_TOOL_TYPES.clear();
        HashMap<ToolType, List> unknownToolTypeBlocks = new HashMap<ToolType, List>();
        class_7923.field_41175.forEach(block -> {
            if (ConfigHandler.Common.blockWhitelistMods().contains(ItemUse.getModId(block))) {
                BLOCK_TOOL_TYPES.put((class_2248)block, ToolType.NONE);
                return;
            }
            ToolType primary = null;
            if (block.method_9564().method_26164(class_3481.field_33715)) {
                primary = ToolType.PICKAXE;
            } else if (block.method_9564().method_26164(class_3481.field_33713)) {
                primary = ToolType.AXE;
            } else if (block.method_9564().method_26164(class_3481.field_33716)) {
                primary = ToolType.SHOVEL;
            } else if (block.method_9564().method_26164(class_3481.field_33714)) {
                primary = ToolType.HOE;
            } else if (block.method_9564().method_26164(TagManager.Blocks.MINEABLE_WITH_SHARP)) {
                primary = ToolType.SHARP;
            }
            for (class_2680 state : block.method_9595().method_11662()) {
                AbstractBlockStateAccessor abstractState = (AbstractBlockStateAccessor)state;
                if (primary != null || !(abstractState.getDestroySpeed() <= 0.0f) && abstractState.getPushReaction() != class_3619.field_15971) continue;
                primary = ToolType.NONE;
            }
            if (primary != null && primary != ToolType.NONE) {
                BLOCK_TOOL_TYPES.put((class_2248)block, primary);
            }
            if (primary == null) {
                unknownToolTypeBlocks.computeIfAbsent(ToolType.NONE, k -> new ArrayList()).add(block);
            }
        });
        class_7923.field_41178.forEach(item -> {
            class_9424 tool = (class_9424)item.method_57347().method_58694(class_9334.field_50077);
            if (tool != null && !tool.comp_2498().isEmpty()) {
                class_6862 tagKey = null;
                for (class_9424.class_9425 rule : tool.comp_2498()) {
                    Optional optionalBlockTagKey;
                    if (!rule.comp_2503().isPresent() || !(optionalBlockTagKey = rule.comp_2501().method_45925()).isPresent()) continue;
                    tagKey = (class_6862)optionalBlockTagKey.get();
                }
                ToolType toolType = HarvestBlock.toolTypeForMineableTag(tagKey);
                if (toolType != ToolType.NONE) {
                    ITEM_TOOL_TYPES.put((class_1792)item, toolType);
                } else {
                    SurvivalistEssentials.LOGGER.debug("Unable to determine item tool type. {} {}", (Object)ResourceLocationHelper.getItemId(item), tagKey);
                }
            }
        });
        ITEM_TOOL_TYPES.forEach((item, toolType) -> SurvivalistEssentials.LOGGER.debug("Inferred tool type for item: {} is {}", (Object)ResourceLocationHelper.getItemId(item), (Object)toolType));
        if (!unknownToolTypeBlocks.isEmpty()) {
            SurvivalistEssentials.LOGGER.debug("Unable to infer primary tools for {} blocks with unknown ToolType. These blocks will not enforce correct tool.", (Object)unknownToolTypeBlocks.values().stream().mapToInt(Collection::size).sum());
            unknownToolTypeBlocks.forEach((toolType, blocks) -> blocks.forEach(block -> {
                SurvivalistEssentials.LOGGER.debug("{}, {}", (Object)toolType, block);
                BLOCK_TOOL_TYPES.put((class_2248)block, (ToolType)((Object)toolType));
            }));
        }
    }

    private static ToolType toolTypeForMineableTag(class_6862<class_2248> tag) {
        if (tag == class_3481.field_33715) {
            return ToolType.PICKAXE;
        }
        if (tag == class_3481.field_33713) {
            return ToolType.AXE;
        }
        if (tag == class_3481.field_33716) {
            return ToolType.SHOVEL;
        }
        if (tag == class_3481.field_33714) {
            return ToolType.HOE;
        }
        if (tag == TagManager.Blocks.MINEABLE_WITH_SHARP) {
            return ToolType.SHARP;
        }
        return ToolType.NONE;
    }
}

