/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import org.apache.commons.lang3.tuple.Pair;
import survivalistessentials.common.HarvestBlock;
import survivalistessentials.common.TagManager;
import survivalistessentials.config.ConfigHandler;
import survivalistessentials.mixin.AbstractBlockStateAccessor;
import survivalistessentials.sound.SurvivalistEssentialsSounds;
import survivalistessentials.util.Chat;
import survivalistessentials.util.ItemUse;
import survivalistessentials.util.ResourceLocationHelper;
import survivalistessentials.util.ToolType;
import technology.roughness.whitenoise.platform.Services;

public class HarvestEventHandler {
    private static final Map<class_1657, class_2338> harvestAttempts = new HashMap<class_1657, class_2338>();
    private static class_2248 spellHitBlock = null;
    private static int breakBlockStep = 0;

    public static boolean shouldCancelBreakBlock(class_1936 level, class_2338 pos, class_1657 player) {
        class_1799 handStack;
        boolean alwaysBreakable;
        class_2680 state = level.method_8320(pos);
        ToolType expectedToolType = HarvestBlock.BLOCK_TOOL_TYPES.getOrDefault(state.method_26204(), ToolType.NONE);
        boolean cancel = false;
        boolean bl = alwaysBreakable = state.method_26164(TagManager.Blocks.ALWAYS_BREAKABLE) || ItemUse.isAlwaysBreakable(state);
        if (Services.PLATFORM.isModLoaded("carryon")) {
            handStack = player.method_6047();
            class_1799 offhandStack = player.method_6079();
            if (handStack.method_7960() && offhandStack.method_7960() && survivalistessentials.platform.Services.PLATFORM_HELPER.isCarryonKeyPressed(player)) {
                alwaysBreakable = true;
            }
        }
        if (Services.PLATFORM.isModLoaded("create")) {
            handStack = player.method_6047();
            boolean bl2 = alwaysBreakable = ResourceLocationHelper.getModId((class_1799)handStack).equals("create") && ResourceLocationHelper.getModId((class_2248)state.method_26204()).equals("create");
        }
        if (!alwaysBreakable && !player.method_68878() && expectedToolType != ToolType.NONE) {
            handStack = HarvestEventHandler.getHandStack(player, state);
            boolean correctTool = ItemUse.isCorrectTool(state, player, handStack);
            boolean isAllowedTool = ItemUse.isAllowedTool(handStack);
            String toolClass = ItemUse.getToolClass(handStack);
            if (toolClass.equals("unknown") || isAllowedTool && !correctTool) {
                cancel = true;
                if (harvestAttempts.containsKey(player) || harvestAttempts.get(player) == null || !harvestAttempts.get(player).equals((Object)pos)) {
                    harvestAttempts.put(player, pos);
                    Chat.sendMessage(player, "message.survivalistessentials.wrong_tool", expectedToolType.toString().toLowerCase(), false);
                } else {
                    Chat.sendMessage(player, "message.survivalistessentials.warning");
                    Chat.sendMessage(player, "message.survivalistessentials.wrong_tool2", expectedToolType.toString().toLowerCase(), true);
                    player.method_64419(player.method_48923().method_48830(), 0.1f);
                }
                if (!toolClass.equals("unknown") && !player.method_73183().method_8608() && ConfigHandler.Client.enableFailSound()) {
                    level.method_8396(null, player.method_23312(), SurvivalistEssentialsSounds.TOOL_FAIL, class_3419.field_15248, 0.6f, 1.0f);
                }
            } else if (spellHitBlock != null) {
                if (breakBlockStep == 1) {
                    breakBlockStep = -1;
                    spellHitBlock = null;
                }
                ++breakBlockStep;
            }
        }
        return cancel;
    }

    public static void setSpellHitBlock(class_2248 block) {
        spellHitBlock = block;
    }

    public static boolean canHarvest(class_1657 player, class_2680 state, boolean originalCanHarvest) {
        if (!player.method_68878()) {
            boolean canHarvest;
            class_1799 handStack = HarvestEventHandler.getHandStack(player, state);
            boolean correctTool = ItemUse.isCorrectTool(state, player, handStack);
            ToolType expectedToolType = HarvestBlock.BLOCK_TOOL_TYPES.getOrDefault(state.method_26204(), ToolType.NONE);
            boolean bl = canHarvest = originalCanHarvest || ItemUse.alwaysDrops(state) || expectedToolType == ToolType.NONE;
            if (!canHarvest) {
                boolean isOre;
                boolean bl2 = isOre = state.method_26164(TagManager.Blocks.ORES) || state.method_26164(TagManager.Blocks.OBSIDIANS);
                canHarvest = isOre && expectedToolType == ToolType.PICKAXE ? correctTool && handStack.method_7951(state) : correctTool || handStack.method_7951(state);
            }
            return canHarvest;
        }
        return true;
    }

    public static Pair<Boolean, Float> getMiningSlowdown(class_1657 player, class_2680 state) {
        float destroySpeed;
        float slowdown = destroySpeed = ((AbstractBlockStateAccessor)state).getDestroySpeed();
        ToolType expectedToolType = HarvestBlock.BLOCK_TOOL_TYPES.getOrDefault(state.method_26204(), ToolType.NONE);
        if (!player.method_68878() && expectedToolType != ToolType.NONE) {
            class_1799 handStack = HarvestEventHandler.getHandStack(player, state);
            boolean correctTool = ItemUse.isCorrectTool(state, player, handStack);
            boolean alwaysBreakable = state.method_26164(TagManager.Blocks.ALWAYS_BREAKABLE);
            boolean isAllowedTool = ItemUse.isAllowedTool(handStack);
            if (!alwaysBreakable) {
                if (!isAllowedTool) {
                    slowdown = ConfigHandler.Common.slowDownSpeed() / 2.0f;
                } else if (!correctTool) {
                    slowdown = ConfigHandler.Common.slowDownSpeed();
                }
            } else if (!correctTool) {
                slowdown = ConfigHandler.Common.slowDownSpeed();
            } else if (!isAllowedTool) {
                slowdown = ConfigHandler.Common.slowDownSpeed() / 2.0f;
            }
        }
        if (slowdown != destroySpeed) {
            return Pair.of((Object)true, (Object)Float.valueOf(slowdown));
        }
        return Pair.of((Object)false, (Object)Float.valueOf(destroySpeed));
    }

    private static class_1799 getHandStack(class_1657 player, class_2680 blockState) {
        String toolClass;
        class_1799 stack = player.method_6047();
        if (spellHitBlock != null && spellHitBlock.equals(blockState.method_26204()) && !Objects.equals(toolClass = ItemUse.getToolClass(stack), "spell") && !Objects.equals(toolClass, "cad")) {
            stack = player.method_6079();
        }
        return stack;
    }
}

