/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.data;

import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_7225;
import survivalistessentials.common.Translations;

public class SurvivalistEssentialsLanguageProvider
extends FabricLanguageProvider {
    protected SurvivalistEssentialsLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryFuture) {
        super(dataOutput, "en_us", registryFuture);
    }

    public void generateTranslations(class_7225.class_7874 provider, FabricLanguageProvider.TranslationBuilder builder) {
        builder.add("survivalistessentials.items", "Survivalist Essentials Items");
        this.addTranslationItem(builder, "plant_fiber", "Plant Fibers");
        this.addTranslationItem(builder, "plant_string", "Plant String");
        this.addTranslationItem(builder, "flint_shard", "Flint Shard");
        this.addTranslationItem(builder, "crude_knife", "Crude Knife");
        this.addTranslationItem(builder, "basic_knife", "Basic Knife");
        this.addTranslationItem(builder, "sharp_knife", "Sharp Knife");
        this.addTranslationItem(builder, "crude_hatchet", "Crude Hatchet");
        this.addTranslationItem(builder, "crude_saw", "Crude Saw");
        this.addTranslationItem(builder, "basic_saw", "Basic Saw");
        this.addTranslationItem(builder, "sharp_saw", "Sharp Saw");
        this.addTranslationItem(builder, "crude_saw_blade", "Crude Saw Blade");
        this.addTranslationItem(builder, "basic_saw_blade", "Basic Saw Blade");
        this.addTranslationItem(builder, "sharp_saw_blade", "Sharp Saw Blade");
        this.addTranslationItem(builder, "saw_handle", "Saw Handle");
        this.addTranslationItem(builder, "knife", "Knife");
        this.addTranslationItem(builder, "knife.description", "For cutting stuff.");
        this.addTranslationItem(builder, "mortar_and_pestle", "Mortar and Pestle");
        this.addTranslationItem(builder, "saw", "Saw");
        this.addTranslationItem(builder, "saw_blade", "Saw Blade");
        this.addTranslationItem(builder, "saw.description", "For cutting wood!");
        this.addTranslationItem(builder, "saw_blade_cast", "Saw Blade Cast");
        this.addTranslationItem(builder, "saw_blade_sand_cast", "Saw Blade Sand Cast");
        this.addTranslationItem(builder, "saw_blade_red_sand_cast", "Saw Blade Red Sand Cast");
        this.addTranslationItem(builder, "reinforced_wool_helmet", "Reinforced Wool Helmet");
        this.addTranslationItem(builder, "reinforced_wool_chestplate", "Reinforced Wool Chestplate");
        this.addTranslationItem(builder, "reinforced_wool_leggings", "Reinforced Wool Leggings");
        this.addTranslationItem(builder, "reinforced_wool_boots", "Reinforced Wool Boots");
        this.addTranslationItem(builder, "reinforced_jelled_slime_helmet", "Reinforced Slime Helmet");
        this.addTranslationItem(builder, "reinforced_jelled_slime_chestplate", "Reinforced Slime Chestplate");
        this.addTranslationItem(builder, "reinforced_jelled_slime_leggings", "Reinforced Slime Leggings");
        this.addTranslationItem(builder, "reinforced_jelled_slime_boots", "Reinforced Slime Boots");
        this.addTranslationItem(builder, "bandage", "Bandage");
        this.addTranslationItem(builder, "cloth", "Cloth");
        this.addTranslationItem(builder, "crude_bandage", "Crude Bandage");
        this.addTranslationItem(builder, "ointment", "Ointment");
        this.addTranslationItem(builder, "plant_paste", "Plant Paste");
        this.addTranslationItem(builder, "wooden_cup", "Mysterious Wooden Cup");
        this.addTranslationItem(builder, "book", "Survivalist Essentials");
        this.addTranslationItem(builder, "modpack_book", "Survivalist Essentials+");
        this.addTranslationBlock(builder, "rock_stone_block", "Rock");
        this.addTranslationBlock(builder, "stone_loose_rock", "Loose Rock (Stone)");
        this.addTranslationBlock(builder, "andesite_loose_rock", "Loose Rock (Andesite)");
        this.addTranslationBlock(builder, "diorite_loose_rock", "Loose Rock (Diorite)");
        this.addTranslationBlock(builder, "granite_loose_rock", "Loose Rock (Granite)");
        this.addTranslationBlock(builder, "sandstone_loose_rock", "Loose Rock (Sandstone)");
        this.addTranslationBlock(builder, "red_sandstone_loose_rock", "Loose Rock (Red Sandstone)");
        this.addJeiDescription(builder, "rock_stone", "Rocks are found lying on the ground. These can be used with the knife in a crafting table to get flint shards.");
        this.addJeiDescription(builder, "plant_fiber", "Plant fibers are dropped when breaking grass or leaves with a knife. They are used to make plant string for tools and plant paste for bandage ointment.");
        this.addJeiDescription(builder, "stick", "Sticks are dropped from leaves. Using any knife doubles the chance of getting a stick.");
        this.addJeiDescription(builder, "flint_shard", "Flint shards can be obtained from striking a rock on any rocky surface. Interact with any stone-like block with a rock, and it might split into two flint shards.");
        this.addTranslationTooltip(builder, "uselessTool1", "This tool cannot mine anything!");
        this.addTranslationTooltip(builder, "uselessTool2", "Can only be used for crafting.");
        this.addTranslationTooltip(builder, "uselessHoe1", "This hoe cannot hoe anything!");
        this.addTranslationTooltip(builder, "uselessWeapon1", "This weapon hits like a wet noodle!");
        this.addTranslationTooltip(builder, "uselessBow1", "This bows bowstring snapped!");
        this.addTranslationTooltip(builder, "uselessArmor1", "Axiom sizing: XXXL. Probably won't fit.");
        this.addTranslationTooltip(builder, "cxp", "Crafty");
        this.addTranslationMessage(builder, "tcon_compat", "It is recommended to install Tinkers' Survival with Survivalist Essentials for better compatibility with Tinkers' Construct. It offers Tinkers' versions of the Saw and Knife!");
        this.addTranslationMessage(builder, "notice", "Notice");
        this.addTranslationMessage(builder, "warning", "Warning");
        this.addTranslationMessage(builder, "wrong_tool", "A %s is required.");
        this.addTranslationMessage(builder, "wrong_tool2", "Ummm ... %s?");
        this.addTranslationMessage(builder, "tool_broke", "Your %s broke.");
        this.addTranslationMessage(builder, "spawn_set", "Not sleepy, but spawn set!");
        this.addTranslationEffect(builder, "stop_bleeding", "Stop Bleeding");
        this.addTranslationEffect(builder, "zombie_essence", "Zombie Essence");
        this.addTranslationPattern(builder, "saw_blade", "Saw Blade");
        this.addConfigurationTitle(builder, "Survivalist Essentials");
        this.addConfigurationName(builder, "enablefailsound", "Enable Fail Sound");
        this.addConfigurationDescription(builder, "enablefailsound", "enablefailsound");
        this.addConfigurationName(builder, "informtconcompat", "Inform Tinkers' Construct Compatibility");
        this.addConfigurationDescription(builder, "informtconcompat", "informtconcompat");
        this.addConfigurationName(builder, "flintchance", "Flint Knapping Chance");
        this.addConfigurationDescription(builder, "flintchance", "flintchance");
        this.addConfigurationName(builder, "healrate", "Bandage Heal Rate");
        this.addConfigurationDescription(builder, "healrate", "healrate");
        this.addConfigurationName(builder, "slowdownspeed", "Incorrect Tool Slowdown Speed");
        this.addConfigurationDescription(builder, "slowdownspeed", "slowdownspeed");
        this.addConfigurationName(builder, "invertlisttowhitelist", "Invert Tool List to Whitelist");
        this.addConfigurationDescription(builder, "invertlisttowhitelist", "invertlisttowhitelist");
        this.addConfigurationName(builder, "mods", "Tool Mods List");
        this.addConfigurationDescription(builder, "mods", "modslist");
        this.addConfigurationName(builder, "items", "Tool Items List");
        this.addConfigurationDescription(builder, "items", "itemslist");
        this.addConfigurationName(builder, "logmodpackdata", "Log Modpack Data");
        this.addConfigurationDescription(builder, "logmodpackdata", "logmodpackdata");
        this.addConfigurationName(builder, "blockmods", "Block Mods List");
        this.addConfigurationDescription(builder, "blockmods", "blockmodslist");
        this.addConfigurationName(builder, "enablehungerpenalty", "Enable Hunger Penalty");
        this.addConfigurationDescription(builder, "enablehungerpenalty", "enablehungerpenalty");
        this.addConfigurationName(builder, "hunger", "Hunger After Death");
        this.addConfigurationDescription(builder, "hunger", "hunger");
        this.addConfigurationName(builder, "saturation", "Saturation After Death");
        this.addConfigurationDescription(builder, "saturation", "saturation");
        this.addConfigurationName(builder, "enablehealthpenalty", "Enable Health Penalty");
        this.addConfigurationDescription(builder, "enablehealthpenalty", "enablehealthpenalty");
        this.addConfigurationName(builder, "health", "Health After Death");
        this.addConfigurationDescription(builder, "health", "health");
        this.addConfigurationName(builder, "startinghealthpenalty", "Starting Health Penalty");
        this.addConfigurationDescription(builder, "startinghealthpenalty", "startinghealthpenalty");
        this.addConfigurationName(builder, "genericdamage", "Generic Tool Damage");
        this.addConfigurationDescription(builder, "genericdamage", "genericdamage");
        this.addConfigurationName(builder, "armormods", "Armor Mods List");
        this.addConfigurationDescription(builder, "armormods", "armormodslist");
        this.addConfigurationName(builder, "armor", "Armor Items List");
        this.addConfigurationDescription(builder, "armor", "armorlist");
        this.addConfigurationName(builder, "tag", "Tool and Armor Tags List");
        this.addConfigurationDescription(builder, "tag", "taglist");
        this.addConfigurationName(builder, "disablemodpackbook", "Disable Modpack Book");
        this.addConfigurationDescription(builder, "disablemodpackbook", "disablemodpackbook");
        this.addTranslationAdvancement(builder, "root.title", "Survivalist Essentials");
        this.addTranslationAdvancement(builder, "root.desc", "You're bound to ...");
        this.addTranslationAdvancement(builder, "sticks_and_stones.title", "Throw your Sticks and Stones");
        this.addTranslationAdvancement(builder, "sticks_and_stones.desc", "Pick up a rock from the ground and leaves might give some sticks");
        this.addTranslationAdvancement(builder, "flint_shard.title", "Rock + rock");
        this.addTranslationAdvancement(builder, "flint_shard.desc", "Maybe hitting your round rock on a cube rock will work");
        this.addTranslationAdvancement(builder, "crude_knife.title", "Crude, but still a knife");
        this.addTranslationAdvancement(builder, "crude_knife.desc", "Not a really good weapon, but pretty good as a lawnmower");
        this.addTranslationAdvancement(builder, "plant_string.title", "Crude String");
        this.addTranslationAdvancement(builder, "plant_string.desc", "Obtain a Plant String");
        this.addTranslationAdvancement(builder, "crude_hatchet.title", "Your first wood?");
        this.addTranslationAdvancement(builder, "crude_hatchet.desc", "Obtain a Crude Hatchet");
        this.addTranslationAdvancement(builder, "crude_saw.title", "Your first planks");
        this.addTranslationAdvancement(builder, "crude_saw.desc", "Obtain a Crude Saw");
        this.addTranslationAdvancement(builder, "getting_wood.title", "Getting Wood");
        this.addTranslationAdvancement(builder, "getting_wood.desc", "I got some wood.");
        this.addGuidebookTranslation(builder, "subtitle", "A Path to Survival");
        this.addGuidebookTranslation(builder, "intro", "Welcome to Survivalist Essentials!$(br)$(br)There are few very important things to remember when playing:$(br)$(li)A correct tool is required for harvesting.$(li)The only way to craft Wooden Planks and Sticks is with a saw.");
        this.addGuidebookTranslation(builder, "getting_started.name", "Getting Started");
        this.addGuidebookTranslation(builder, "getting_started.desc", "Gathering basic materials for crafting crude tools is essential for getting started. The following pages will cover what you MUST gather to survive.");
        this.addGuidebookTranslation(builder, "getting_started.materials.name", "Materials Gathering");
        this.addGuidebookTranslation(builder, "getting_started.materials.gather_stones.title", "Gathering Stones");
        this.addGuidebookTranslation(builder, "getting_started.materials.gather_stones.desc", "You may notice right away some small piles of rocks lying randomly on the ground throughout the world.$(br)$(br)Break and gather them quickly, they are a valuable AND necessary resource and needed for crafting tools.");
        this.addGuidebookTranslation(builder, "getting_started.materials.gather_sticks.title", "Get Sticks!!!");
        this.addGuidebookTranslation(builder, "getting_started.materials.gather_sticks.desc", "Sticks are essenial for creating your first Crude Tools. These are the most basic handles.$(br)$(br)Punching leaves and will drop sticks. The drop rate is not great but it will allow you to get sticks. Once you craft a knife, you can use it to increase the drop rate.");
        this.addGuidebookTranslation(builder, "getting_started.materials.flint_shards.title", "Flint Shards");
        this.addGuidebookTranslation(builder, "getting_started.materials.flint_shards.desc", "Crude tools need Flint Shards!$(br)$(br)Simply knapp (right-click) Rocks you've gathered on a hard surface (any regular Stone/Cobblestone/Granite/etc. hard blocks) and with a bit of luck, you can split them in half to obtain shards.$(br)$(br)Once you have the $(l:survivalistessentials:tools/crude_tools)Crude Knife$(), you can make more shards in your crafting grid.");
        this.addGuidebookTranslation(builder, "getting_started.materials.plant_fiber.title", "Plant Fiber");
        this.addGuidebookTranslation(builder, "getting_started.materials.plant_fiber.desc", "Next you'll need to get some Plant Fiber.$(br)$(br)Plant Fiber is a new drop when breaking grass or most plants with the Crude Knife. Grass is probably the easiest way to get Plant Fiber.$(br)$(br)You'll need Plant Fiber to craft Plant String used in crafting the Crude Hatchet, Crude Saw and Bandages.");
        this.addGuidebookTranslation(builder, "getting_started.materials.plant_string.title", "Plant String");
        this.addGuidebookTranslation(builder, "getting_started.materials.plant_string.desc", "Plant String is essential for crafting the Crude Hatchet and Crude Saw. Gather enough Plant Fiber!");
        this.addGuidebookTranslation(builder, "tools.name", "Tools");
        this.addGuidebookTranslation(builder, "tools.desc", "Tools are essential for gathering materials and getting your first wood planks!$(br)$(br)Punching trees is no longer an option, so you'll need these most basic tools to be able to craft better tools, or more advanced items using the crafting table.");
        this.addGuidebookTranslation(builder, "tools.crude_tools.name", "Crude Tools");
        this.addGuidebookTranslation(builder, "tools.crude_tools.knife.desc", "Crude Knife is essential for gathering Plant Fiber. This MUST be the first tool crafted to progress.");
        this.addGuidebookTranslation(builder, "tools.crude_tools.knife_recipes.name", "Crude Knife Recipes");
        this.addGuidebookTranslation(builder, "tools.crude_tools.knife_recipes.desc", "In addition to more shards, you can also craft in any crafting grid:$(br)$(li)String: knife and wool$(br)$(li)Sticks: knife and saplings");
        this.addGuidebookTranslation(builder, "tools.crude_tools.hatchet.desc", "Crude Hatchet is essential for gathering wood. You can now chop down trees!");
        this.addGuidebookTranslation(builder, "tools.crude_tools.crude_saw_blade.desc", "Crude Saw Blade is the first part for the Crude Saw. Blades are replaceable on the Saw. The crude blades have only half the output of sharper blade materials.");
        this.addGuidebookTranslation(builder, "tools.crude_tools.saw_handle.desc", "The Saw Handle is a reusable part for crafting the Crude Saw. Once the blade breaks, just reuse the left over handle to create a new Saw.");
        this.addGuidebookTranslation(builder, "tools.crude_tools.crude_saw.desc", "Crude Saw will allow you to craft planks! Upgrade the blade to increase plank output and durability.");
        this.addGuidebookTranslation(builder, "tools.crude_tools.planks.name", "Planks");
        this.addGuidebookTranslation(builder, "tools.crude_tools.planks.desc", "Here is an example recipe with the Crude Saw that will allow you to craft planks!");
        this.addGuidebookTranslation(builder, "tools.crude_tools.sticks.name", "Sticks");
        this.addGuidebookTranslation(builder, "tools.crude_tools.sticks.desc", "Here is an example recipe with the Crude Saw that will allow you to craft sticks!");
        this.addGuidebookTranslation(builder, "tools.improved_tools.name", "Improved Tools");
        this.addGuidebookTranslation(builder, "tools.improved_tools.subtitle", "Get sharper tools!");
        this.addGuidebookTranslation(builder, "tools.improved_tools.intro", "While crude tools will get you started, you'll want to create more durable tools.");
        this.addGuidebookTranslation(builder, "health.name", "Health");
        this.addGuidebookTranslation(builder, "health.desc", "It's a little more difficult getting started. To help with the process, some basic bandages are available to help in the early game.");
        this.addGuidebookTranslation(builder, "health.ingredients.name", "Ingredients");
        this.addGuidebookTranslation(builder, "health.ingredients.subtitle", "It's the little things...");
        this.addGuidebookTranslation(builder, "health.ingredients.desc", "There are several basic materials required for making bandages.");
        this.addGuidebookTranslation(builder, "health.ingredients.cloth.desc", "Cloth is an ingredient used for making Bandages.");
        this.addGuidebookTranslation(builder, "health.ingredients.mortar_and_pestle.desc", "Essential tool for crafting plant paste.");
        this.addGuidebookTranslation(builder, "health.ingredients.plant_paste.desc", "Essential ingredient for Ointment.");
        this.addGuidebookTranslation(builder, "health.ingredients.ointment.desc", "Ointment is an ingredient used for making Bandages.");
        this.addGuidebookTranslation(builder, "health.bandages.name", "Bandages");
        this.addGuidebookTranslation(builder, "health.bandages.subtitle", "Stop the bleeding...");
        this.addGuidebookTranslation(builder, "health.bandages.desc", "Crude bandages are simple to make. Bandages are a little more work, but do a much better job of stopping the bleeding.");
        this.addGuidebookTranslation(builder, "health.bandages.crude_bandage.desc", "Cheap bandage, great for early game.");
        this.addGuidebookTranslation(builder, "health.bandages.bandage.desc", "Better bandage, great for mid game.");
    }

    private void addTranslationItem(FabricLanguageProvider.TranslationBuilder builder, String id, String name) {
        builder.add("item.survivalistessentials." + id, name);
    }

    private void addTranslationBlock(FabricLanguageProvider.TranslationBuilder builder, String id, String name) {
        builder.add("block.survivalistessentials." + id, name);
    }

    private void addJeiDescription(FabricLanguageProvider.TranslationBuilder builder, String id, String description) {
        builder.add("jei.survivalistessentials.description." + id, description);
    }

    private void addTranslationTooltip(FabricLanguageProvider.TranslationBuilder builder, String id, String tooltip) {
        builder.add("tooltip.survivalistessentials." + id, tooltip);
    }

    private void addTranslationMessage(FabricLanguageProvider.TranslationBuilder builder, String id, String message) {
        builder.add("message.survivalistessentials." + id, message);
    }

    private void addTranslationEffect(FabricLanguageProvider.TranslationBuilder builder, String id, String effect) {
        builder.add("effect.survivalistessentials." + id, effect);
    }

    private void addTranslationPattern(FabricLanguageProvider.TranslationBuilder builder, String id, String pattern) {
        builder.add("pattern.survivalistessentials." + id, pattern);
    }

    private void addTranslationAdvancement(FabricLanguageProvider.TranslationBuilder builder, String id, String text) {
        builder.add("advancements.survivalistessentials." + id, text);
    }

    private void addGuidebookTranslation(FabricLanguageProvider.TranslationBuilder builder, String id, String text) {
        builder.add("info.survivalistessentials.book." + id, text);
    }

    private void addConfigurationTitle(FabricLanguageProvider.TranslationBuilder builder, String title) {
        builder.add("survivalistessentials.configuration.title", title);
    }

    private void addConfigurationName(FabricLanguageProvider.TranslationBuilder builder, String id, String name) {
        builder.add("survivalistessentials.configuration." + id + ".name", name);
    }

    private void addConfigurationDescription(FabricLanguageProvider.TranslationBuilder builder, String id) {
        builder.add("survivalistessentials.configuration." + id + ".description", Translations.get(id));
    }

    private void addConfigurationDescription(FabricLanguageProvider.TranslationBuilder builder, String id, String key) {
        builder.add("survivalistessentials.configuration." + id + ".description", Translations.get(key));
    }
}

