/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.sound;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import survivalistessentials.util.ResourceLocationHelper;

public class SurvivalistEssentialsSounds {
    private static final Map<ResourceLocation, SoundEvent> ALL = new LinkedHashMap<ResourceLocation, SoundEvent>();
    public static SoundEvent ARMOR_FAIL;
    public static SoundEvent BOW_FAIL;
    public static SoundEvent FLINT_KNAPPING;
    public static SoundEvent HOE_FAIL;
    public static SoundEvent SWORD_FAIL;
    public static SoundEvent TOOL_FAIL;

    public static void init(BiConsumer<SoundEvent, ResourceLocation> consumer) {
        ARMOR_FAIL = SurvivalistEssentialsSounds.makeSoundEvent("armor_fail");
        BOW_FAIL = SurvivalistEssentialsSounds.makeSoundEvent("bow_fail");
        FLINT_KNAPPING = SurvivalistEssentialsSounds.makeSoundEvent("knapping");
        HOE_FAIL = SurvivalistEssentialsSounds.makeSoundEvent("hoe_fail");
        SWORD_FAIL = SurvivalistEssentialsSounds.makeSoundEvent("sword_fail");
        TOOL_FAIL = SurvivalistEssentialsSounds.makeSoundEvent("tool_fail");
        for (Map.Entry<ResourceLocation, SoundEvent> entry : ALL.entrySet()) {
            consumer.accept(entry.getValue(), entry.getKey());
        }
    }

    private static SoundEvent makeSoundEvent(String name) {
        ResourceLocation loc = ResourceLocationHelper.prefix(name);
        SoundEvent soundEvent = SoundEvent.createVariableRangeEvent((ResourceLocation)loc);
        ALL.put(loc, soundEvent);
        return soundEvent;
    }
}

