/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_44;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import survivalistessentials.SurvivalistEssentials;
import survivalistessentials.common.HarvestBlock;
import survivalistessentials.common.TagManager;
import survivalistessentials.common.loot.SurvivalistEssentialsLootConditionTypes;
import survivalistessentials.data.integration.SurvivalistEssentialsIntegration;
import survivalistessentials.data.recipe.ConfigResourceCondition;
import survivalistessentials.event.EquipmentChangeHandler;
import survivalistessentials.items.SurvivalistEssentialsItems;
import survivalistessentials.sound.SurvivalistEssentialsSounds;
import survivalistessentials.util.LootConditionHelper;
import survivalistessentials.world.SurvivalistEssentialsWorld;
import survivalistessentials.world.effect.SurvivalistEssentialsEffects;
import survivalistessentials.world.feature.SurvivalistEssentialsFeatures;

public class SurvivalistEssentialsFabric
implements ModInitializer {
    public void onInitialize() {
        List<String> fiberPlantBlocks = List.of("fern", "grass", "leaves");
        this.registryInit();
        SurvivalistEssentials.init();
        SurvivalistEssentialsFeatures.setup();
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> HarvestBlock.setup());
        ServerEntityEvents.EQUIPMENT_CHANGE.register((entity, slot, from, to) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                EquipmentChangeHandler.handleChange(player, slot, to);
            }
        });
        LootTableEvents.MODIFY.register((resourceKey, builder, lootTableSource, provider) -> {
            String pathString = resourceKey.method_29177().method_12832();
            if (fiberPlantBlocks.stream().anyMatch(pathString::contains)) {
                class_7225.class_7226 itemRegistryLookup = provider.method_46762(class_7924.field_41197);
                builder.method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)SurvivalistEssentialsItems.PLANT_FIBER)).conditionally(List.of(LootConditionHelper.createKnifeChanceCondition(0.16f, TagManager.Blocks.FIBER_PLANTS, (class_7225.class_7226<class_1792>)itemRegistryLookup))));
                if (pathString.contains("leaves")) {
                    class_7225.class_7226 holderLookup = provider.method_46762(class_7924.field_41265);
                    class_7225.class_7226 entityRegistryLookup = provider.method_46762(class_7924.field_41266);
                    builder.method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8600)).conditionally(List.of(LootConditionHelper.createKnifeChanceCondition(0.16f, (class_6862<class_2248>)class_3481.field_15503, (class_7225.class_7226<class_1792>)itemRegistryLookup))));
                    builder.method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8600)).conditionally(List.of(LootConditionHelper.createExtraStickDropConditions(0.16f, (class_6862<class_2248>)class_3481.field_15503, (class_7225.class_7226<class_1887>)holderLookup, (class_7225.class_7226<class_1792>)itemRegistryLookup, entityRegistryLookup))));
                }
            }
        });
    }

    private void registryInit() {
        SurvivalistEssentialsFeatures.init(SurvivalistEssentialsFabric.bind(class_7923.field_41144));
        SurvivalistEssentialsEffects.init(SurvivalistEssentialsFabric.bind(class_7923.field_41174));
        SurvivalistEssentialsIntegration.init(SurvivalistEssentialsFabric.bind(class_7923.field_41178));
        SurvivalistEssentialsItems.init(SurvivalistEssentialsFabric.bind(class_7923.field_41178));
        SurvivalistEssentialsWorld.initBlocks(SurvivalistEssentialsFabric.bind(class_7923.field_41175));
        SurvivalistEssentialsWorld.initItems(SurvivalistEssentialsFabric.bind(class_7923.field_41178));
        SurvivalistEssentialsLootConditionTypes.init(SurvivalistEssentialsFabric.bind(class_7923.field_41135));
        SurvivalistEssentialsSounds.init(SurvivalistEssentialsFabric.bind(class_7923.field_41172));
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInOverworld(), (class_2893.class_2895)class_2893.class_2895.field_13179, SurvivalistEssentialsFeatures.PLACED_LOOSE_ROCKS_KEY);
        ConfigResourceCondition.register();
    }

    private static <T> BiConsumer<T, class_2960> bind(class_2378<? super T> registry) {
        return (t, id) -> class_2378.method_10230((class_2378)registry, (class_2960)id, (Object)t);
    }
}

