/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import survivalistessentials.common.HarvestBlock;
import survivalistessentials.common.TagManager;
import survivalistessentials.config.ConfigHandler;
import survivalistessentials.mixin.AbstractBlockStateAccessor;
import survivalistessentials.util.ToolType;
import technology.roughness.whitenoise.platform.Services;

public class ItemUse {
    private static final Map<String, String> toolsMap = new HashMap<String, String>();
    public static final List<String> TOOL_TYPES = new ArrayList<String>(Arrays.asList("pickaxe", "pickadze", "bow", "crossbow", "axe", "hatchet", "hoe", "mattock", "kama", "shears", "shovel", "sword", "weapon", "hammer", "wirecutter", "wrench", "drill", "building", "revolver", "saw", "crook", "spell", "knife", "cad", "spear", "darkstar", "chisel"));

    public static void init() {
        toolsMap.clear();
        for (String string : ConfigHandler.Common.getItems()) {
            String[] nameParts = string.split("-");
            String toolType = nameParts[0];
            if (!TOOL_TYPES.contains(toolType)) continue;
            toolsMap.put(nameParts[1], nameParts[0]);
        }
    }

    public static boolean isAllowedTool(class_1799 stack) {
        class_2960 loc = class_7923.field_41178.method_10221((Object)stack.method_7909());
        String itemName = loc.method_12832();
        String modid = loc.method_12836();
        boolean hasTag = ItemUse.hasTag(stack);
        if (ConfigHandler.Common.invertListToWhitelist()) {
            return hasTag || ConfigHandler.Common.getMods().contains(modid) || toolsMap.get(itemName) != null;
        }
        return !hasTag && !ConfigHandler.Common.getMods().contains(modid) && toolsMap.get(itemName) == null;
    }

    public static String getModId(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block).method_12836();
    }

    public static boolean alwaysDrops(class_2680 state) {
        if (((AbstractBlockStateAccessor)state).getDestroySpeed() == 0.0f) {
            return true;
        }
        return state.method_26164(TagManager.Blocks.ALWAYS_DROPS);
    }

    public static String getToolClass(class_1799 stack) {
        String itemName = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832();
        String type = toolsMap.get(itemName);
        if (ToolType.PICKAXE.is(stack.method_7909())) {
            type = "pickaxe";
        } else if (ToolType.AXE.is(stack.method_7909())) {
            type = "axe";
        } else if (ToolType.SHOVEL.is(stack.method_7909())) {
            type = "shovel";
        } else if (ToolType.HOE.is(stack.method_7909())) {
            type = "hoe";
        } else if (ToolType.SHARP.is(stack.method_7909())) {
            type = "sharp";
        }
        if (type == null) {
            String[] nameParts = itemName.split("[^a-z]+");
            for (String toolType : TOOL_TYPES) {
                if (!itemName.contains(toolType) || !Arrays.asList(nameParts).contains(toolType)) continue;
                type = toolType;
            }
        }
        return Objects.requireNonNullElse(type, "unknown");
    }

    public static boolean isCorrectToolType(String type, class_1799 handStack) {
        boolean isCorrectToolType = false;
        String toolClass = ItemUse.getToolClass(handStack);
        switch (type) {
            case "pickaxe": {
                isCorrectToolType = toolClass.equals(type) || toolClass.equals("drill") || toolClass.equals("pickadze") || toolClass.equals("building") || toolClass.equals("hammer") || toolClass.equals("spell") || toolClass.equals("cad") || toolClass.equals("chisel") || ToolType.PICKAXE.is(handStack.method_7909());
                break;
            }
            case "axe": {
                isCorrectToolType = toolClass.equals(type) || toolClass.equals("mattock") || toolClass.equals("building") || toolClass.equals("spell") || toolClass.equals("cad") || toolClass.equals("hatchet") || ToolType.AXE.is(handStack.method_7909());
                break;
            }
            case "shovel": {
                isCorrectToolType = toolClass.equals(type) || toolClass.equals("mattock") || toolClass.equals("drill") || toolClass.equals("pickadze") || toolClass.equals("building") || toolClass.equals("spell") || toolClass.equals("cad") || ToolType.SHOVEL.is(handStack.method_7909());
                break;
            }
            case "hoe": {
                isCorrectToolType = toolClass.equals(type) || toolClass.equals("mattock") || toolClass.equals("building") || toolClass.equals("crook") || toolClass.equals("spell") || toolClass.equals("cad") || ToolType.HOE.is(handStack.method_7909());
                break;
            }
            case "sharp": {
                isCorrectToolType = toolClass.equals(type) || toolClass.equals("knife") || toolClass.equals("mattock") || toolClass.equals("building") || toolClass.equals("spell") || toolClass.equals("axe") || toolClass.equals("modular_sword") || ToolType.SHARP.is(handStack.method_7909());
            }
        }
        return isCorrectToolType;
    }

    public static boolean isAlwaysBreakable(class_2680 state) {
        if (((AbstractBlockStateAccessor)state).getDestroySpeed() == 0.0f) {
            if (!Services.PLATFORM.isModLoaded("dynamictrees")) {
                return true;
            }
            return !state.method_26164(TagManager.Blocks.BRANCHES);
        }
        return false;
    }

    public static boolean isCorrectTool(class_2680 state, class_1657 player, class_1799 handStack) {
        if (ItemUse.isAlwaysBreakable(state)) {
            return true;
        }
        if (state.method_26164(class_3481.field_33715) && ItemUse.isCorrectToolType("pickaxe", handStack)) {
            return true;
        }
        if (state.method_26164(class_3481.field_33713) && ItemUse.isCorrectToolType("axe", handStack)) {
            return true;
        }
        if (state.method_26164(class_3481.field_33716) && ItemUse.isCorrectToolType("shovel", handStack)) {
            return true;
        }
        if (state.method_26164(class_3481.field_33714) && ItemUse.isCorrectToolType("hoe", handStack)) {
            return true;
        }
        if (state.method_26164(TagManager.Blocks.MINEABLE_WITH_SHARP) && ItemUse.isCorrectToolType("sharp", handStack)) {
            return true;
        }
        ToolType expectedToolType = HarvestBlock.BLOCK_TOOL_TYPES.getOrDefault(state.method_26204(), ToolType.NONE);
        if (expectedToolType == ToolType.NONE) {
            return true;
        }
        if (ItemUse.isCorrectToolType(expectedToolType.toString().toLowerCase(), handStack)) {
            return true;
        }
        ToolType inferredToolType = HarvestBlock.ITEM_TOOL_TYPES.getOrDefault(handStack.method_7909(), ToolType.NONE);
        if (inferredToolType == expectedToolType) {
            return true;
        }
        return expectedToolType.is(handStack.method_7909());
    }

    public static boolean isArmor(class_1799 stack) {
        return stack.method_7909().method_57347().method_58694(class_9334.field_54196) != null;
    }

    public static boolean isAllowedArmor(class_1799 stack) {
        class_2960 loc = class_7923.field_41178.method_10221((Object)stack.method_7909());
        String itemName = loc.method_12832();
        String modid = loc.method_12836();
        boolean hasTag = ItemUse.hasTag(stack);
        if (ConfigHandler.Common.invertListToWhitelist()) {
            return hasTag || ConfigHandler.Common.armorMods().contains(modid) || ConfigHandler.Common.armorItems().contains(itemName);
        }
        return !hasTag && !ConfigHandler.Common.armorMods().contains(modid) && !ConfigHandler.Common.armorItems().contains(itemName);
    }

    public static boolean hasTag(class_1799 stack) {
        return ConfigHandler.Common.tagList().stream().anyMatch(arg_0 -> ((class_1799)stack).method_31573(arg_0));
    }
}

