/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import survivalistessentials.common.CreativeTabs;
import survivalistessentials.common.HarvestBlock;
import survivalistessentials.common.SurvivalistEssentialsModule;
import survivalistessentials.common.loot.LootItemBlockIsTagCondition;
import survivalistessentials.common.loot.SurvivalistEssentialsLootConditionTypes;
import survivalistessentials.config.ConfigHandler;
import survivalistessentials.data.integration.SurvivalistEssentialsIntegration;
import survivalistessentials.event.AttackEventHandler;
import survivalistessentials.event.ClientEventHandler;
import survivalistessentials.event.HarvestEventHandler;
import survivalistessentials.event.HoeEventHandler;
import survivalistessentials.event.LivingEquipmentChangeEventHandler;
import survivalistessentials.event.PlayerEventHandler;
import survivalistessentials.event.TooltipEventHandler;
import survivalistessentials.items.SurvivalistEssentialsItems;
import survivalistessentials.loot.SurvivalistEssentialsLootTables;
import survivalistessentials.sound.Sounds;
import survivalistessentials.world.SurvivalistEssentialsWorld;
import survivalistessentials.world.effect.SurvivalistEssentialsEffects;
import survivalistessentials.world.feature.SurvivalistEssentialsFeatures;
import technology.roughness.whitenoise.config.WhiteNoiseConfig;
import technology.roughness.whitenoise.config.WhiteNoiseConfigLoader;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;
import technology.roughness.whitenoise.platform.Services;

@Mod(value="survivalistessentials")
public class SurvivalistEssentials {
    public static final String MODID = "survivalistessentials";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"survivalistessentials");

    public SurvivalistEssentials(IEventBus bus, Dist dist, ModContainer container) {
        this.registryInit(bus);
        this.registerListeners(bus);
        SurvivalistEssentialsModule.initRegistries(bus);
        WhiteNoiseConfig commonConfig = WhiteNoiseConfigLoader.add((WhiteNoiseConfig.Type)WhiteNoiseConfig.Type.COMMON, (WhiteNoiseConfigSpec)ConfigHandler.COMMON_SPEC, (String)MODID);
        commonConfig.addLoadListener((config, flags) -> ConfigHandler.init());
        if (Services.PLATFORM.isPhysicalClient()) {
            WhiteNoiseConfigLoader.add((WhiteNoiseConfig.Type)WhiteNoiseConfig.Type.CLIENT, (WhiteNoiseConfigSpec)ConfigHandler.CLIENT_SPEC, (String)MODID);
        }
    }

    public void registerListeners(IEventBus bus) {
        bus.register(RegistryListener.class);
        SurvivalistEssentialsLootTables.init();
        SurvivalistEssentialsFeatures.setup();
    }

    @SubscribeEvent
    public static void serverStart(ServerStartedEvent event) {
        if (ConfigHandler.Common.logModpackData()) {
            BuiltInRegistries.BLOCK.forEach(block -> {
                if (block.defaultBlockState().is(Tags.Blocks.NEEDS_WOOD_TOOL)) {
                    LOGGER.warn("needs_wood_tool - level 0: {}", block);
                }
                if (block.defaultBlockState().is(Tags.Blocks.NEEDS_GOLD_TOOL)) {
                    LOGGER.warn("needs_gold_tool - level 0.1: {}", block);
                }
                if (block.defaultBlockState().is(BlockTags.NEEDS_STONE_TOOL)) {
                    LOGGER.warn("needs_stone_tool - level 1: {}", block);
                }
                if (block.defaultBlockState().is(BlockTags.NEEDS_IRON_TOOL)) {
                    LOGGER.warn("needs_iron_tool - level 2: {}", block);
                }
                if (block.defaultBlockState().is(BlockTags.NEEDS_DIAMOND_TOOL)) {
                    LOGGER.warn("needs_diamond_tool - level 3: {}", block);
                }
                if (block.defaultBlockState().is(Tags.Blocks.NEEDS_NETHERITE_TOOL)) {
                    LOGGER.warn("needs_netherite_tool - level 4: {}", block);
                }
            });
        }
    }

    private void registryInit(IEventBus bus) {
        SurvivalistEssentials.bind(bus, Registries.FEATURE, SurvivalistEssentialsFeatures::init);
        SurvivalistEssentials.bind(bus, Registries.MOB_EFFECT, SurvivalistEssentialsEffects::init);
        SurvivalistEssentials.bind(bus, Registries.ITEM, SurvivalistEssentialsIntegration::init);
        SurvivalistEssentials.bind(bus, Registries.ITEM, SurvivalistEssentialsItems::init);
        SurvivalistEssentials.bind(bus, Registries.ITEM, SurvivalistEssentialsWorld::initItems);
        SurvivalistEssentials.bind(bus, Registries.BLOCK, SurvivalistEssentialsWorld::initBlocks);
        SurvivalistEssentials.bind(bus, Registries.LOOT_CONDITION_TYPE, SurvivalistEssentialsLootConditionTypes::init);
        SurvivalistEssentials.bind(bus, Registries.SOUND_EVENT, Sounds::init);
    }

    private static <T> void bind(IEventBus bus, ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        bus.addListener(event -> {
            if (registry.equals(event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    public static ResourceLocation loc(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static ResourceLocation prefix(String path) {
        return SurvivalistEssentials.loc(MODID, path);
    }

    public static final class RegistryListener {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerEvent(RegisterEvent event) {
            event.register(Registries.LOOT_CONDITION_TYPE, SurvivalistEssentials.prefix("is_tag"), () -> LootItemBlockIsTagCondition.LOOT_ITEM_BLOCK_IS_TAG);
            if (event.getRegistryKey().equals(Registries.CREATIVE_MODE_TAB)) {
                CreativeTabs.init();
            }
        }

        @SubscribeEvent
        public static void setup(FMLCommonSetupEvent event) {
            HarvestBlock.init();
            NeoForge.EVENT_BUS.register(AttackEventHandler.class);
            NeoForge.EVENT_BUS.register(HarvestEventHandler.class);
            NeoForge.EVENT_BUS.register(HoeEventHandler.class);
            NeoForge.EVENT_BUS.register(LivingEquipmentChangeEventHandler.class);
            NeoForge.EVENT_BUS.register(PlayerEventHandler.class);
            if (FMLEnvironment.dist == Dist.CLIENT) {
                NeoForge.EVENT_BUS.register(TooltipEventHandler.class);
                NeoForge.EVENT_BUS.register(ClientEventHandler.class);
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerCreativeTab(BuildCreativeModeTabContentsEvent event) {
            Item item;
            if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
                for (Map.Entry<ResourceLocation, Item> entry : SurvivalistEssentialsItems.getToolsAndUtilities().entrySet()) {
                    item = entry.getValue();
                    event.accept(new ItemStack((ItemLike)item));
                }
            }
            if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
                for (Map.Entry<ResourceLocation, Item> entry : SurvivalistEssentialsItems.getAllIngredients().entrySet()) {
                    item = entry.getValue();
                    event.accept(new ItemStack((ItemLike)item));
                }
                for (Map.Entry<ResourceLocation, Item> entry : SurvivalistEssentialsWorld.getAll().entrySet()) {
                    item = entry.getValue();
                    event.accept(new ItemStack((ItemLike)item));
                }
            }
        }
    }
}

