/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import survivalistessentials.SurvivalistEssentials;
import survivalistessentials.common.TagManager;
import survivalistessentials.config.ConfigHandler;
import survivalistessentials.mixin.AbstractBlockAccessor;
import survivalistessentials.mixin.AbstractBlockStateAccessor;
import survivalistessentials.util.ItemUse;
import survivalistessentials.util.ToolType;

public final class HarvestBlock {
    public static final Map<Block, ToolType> BLOCK_TOOL_TYPES = new HashMap<Block, ToolType>();
    public static final Map<Item, ToolType> ITEM_TOOL_TYPES = new HashMap<Item, ToolType>();

    public static void init() {
        BuiltInRegistries.BLOCK.forEach(block -> {
            AbstractBlockAccessor blockAccess = (AbstractBlockAccessor)block;
            BlockBehaviour.Properties settings = blockAccess.getProperties();
            settings.requiresCorrectToolForDrops();
            for (BlockState state : block.getStateDefinition().getPossibleStates()) {
                AbstractBlockStateAccessor abstractState = (AbstractBlockStateAccessor)state;
                abstractState.setRequiresCorrectToolForDrops(true);
            }
        });
    }

    public static void setup() {
        BLOCK_TOOL_TYPES.clear();
        HashMap<ToolType, List> unknownToolTypeBlocks = new HashMap<ToolType, List>();
        BuiltInRegistries.BLOCK.forEach(block -> {
            if (ConfigHandler.Common.blockWhitelistMods().contains(ItemUse.getModId(block))) {
                BLOCK_TOOL_TYPES.put((Block)block, ToolType.NONE);
                return;
            }
            ToolType primary = null;
            if (block.defaultBlockState().is(BlockTags.MINEABLE_WITH_PICKAXE)) {
                primary = ToolType.PICKAXE;
            } else if (block.defaultBlockState().is(BlockTags.MINEABLE_WITH_AXE)) {
                primary = ToolType.AXE;
            } else if (block.defaultBlockState().is(BlockTags.MINEABLE_WITH_SHOVEL)) {
                primary = ToolType.SHOVEL;
            } else if (block.defaultBlockState().is(BlockTags.MINEABLE_WITH_HOE)) {
                primary = ToolType.HOE;
            } else if (block.defaultBlockState().is(TagManager.Blocks.MINEABLE_WITH_SHARP)) {
                primary = ToolType.SHARP;
            }
            for (BlockState state : block.getStateDefinition().getPossibleStates()) {
                AbstractBlockStateAccessor abstractState = (AbstractBlockStateAccessor)state;
                if (primary != null || !(abstractState.getDestroySpeed() <= 0.0f) && abstractState.getPushReaction() != PushReaction.DESTROY) continue;
                primary = ToolType.NONE;
            }
            if (primary != null && primary != ToolType.NONE) {
                BLOCK_TOOL_TYPES.put((Block)block, primary);
            }
            if (primary == null) {
                unknownToolTypeBlocks.computeIfAbsent(ToolType.NONE, k -> new ArrayList()).add(block);
            }
        });
        BuiltInRegistries.ITEM.forEach(item -> {
            if (item instanceof DiggerItem) {
                ToolType toolType;
                DiggerItem digger = (DiggerItem)item;
                Tool tool = (Tool)digger.components().get(DataComponents.TOOL);
                TagKey tagKey = null;
                if (tool != null) {
                    for (Tool.Rule rule : tool.rules()) {
                        Optional optionalBlockTagKey;
                        if (!rule.correctForDrops().isPresent() || !(optionalBlockTagKey = rule.blocks().unwrapKey()).isPresent()) continue;
                        tagKey = (TagKey)optionalBlockTagKey.get();
                    }
                }
                if ((toolType = HarvestBlock.toolTypeForMineableTag(tagKey)) != ToolType.NONE) {
                    ITEM_TOOL_TYPES.put((Item)item, toolType);
                } else {
                    SurvivalistEssentials.LOGGER.debug("Unable to determine digger tool type. %s", (Object)digger);
                }
            } else if (item instanceof SwordItem || item instanceof ShearsItem) {
                ITEM_TOOL_TYPES.put((Item)item, ToolType.SHARP);
            }
        });
        if (!unknownToolTypeBlocks.isEmpty()) {
            SurvivalistEssentials.LOGGER.debug("Unable to infer primary tools for {} blocks with unknown ToolType. These blocks will not enforce correct tool.", (Object)unknownToolTypeBlocks.values().stream().mapToInt(Collection::size).sum());
            unknownToolTypeBlocks.forEach((toolType, blocks) -> blocks.forEach(block -> {
                SurvivalistEssentials.LOGGER.debug("{}, {}", (Object)toolType, block);
                BLOCK_TOOL_TYPES.put((Block)block, (ToolType)((Object)toolType));
            }));
        }
    }

    private static ToolType toolTypeForMineableTag(TagKey<Block> tag) {
        if (tag == BlockTags.MINEABLE_WITH_PICKAXE) {
            return ToolType.PICKAXE;
        }
        if (tag == BlockTags.MINEABLE_WITH_AXE) {
            return ToolType.AXE;
        }
        if (tag == BlockTags.MINEABLE_WITH_SHOVEL) {
            return ToolType.SHOVEL;
        }
        if (tag == BlockTags.MINEABLE_WITH_HOE) {
            return ToolType.HOE;
        }
        if (tag == TagManager.Blocks.MINEABLE_WITH_SHARP) {
            return ToolType.SHARP;
        }
        return ToolType.NONE;
    }
}

