/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.tuple.Pair;
import survivalistessentials.common.Translations;
import survivalistessentials.util.ItemUse;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;

public final class ConfigHandler {
    public static final WhiteNoiseConfigSpec CLIENT_SPEC;
    public static final WhiteNoiseConfigSpec COMMON_SPEC;
    private static final Client CLIENT;
    private static final Common COMMON;

    public static void init() {
        Common.tagList().clear();
        ((List)Common.TAGS.get()).forEach(s -> Common.tagList().add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)s))));
        ItemUse.init();
    }

    private static String getTranslation(String key) {
        return Translations.get(key);
    }

    static {
        Pair specPairClient = new WhiteNoiseConfigSpec.Builder().configure(Client::new);
        Pair specPairCommon = new WhiteNoiseConfigSpec.Builder().configure(Common::new);
        CLIENT_SPEC = (WhiteNoiseConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
        COMMON_SPEC = (WhiteNoiseConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
    }

    public static final class Common {
        private final WhiteNoiseConfigSpec.DoubleValue FLINT_CHANCE;
        private final WhiteNoiseConfigSpec.DoubleValue HEAL_RATE;
        private final WhiteNoiseConfigSpec.DoubleValue SLOW_DOWN_SPEED;
        private final WhiteNoiseConfigSpec.BooleanValue ENABLE_HUNGER_PENALTY;
        private final WhiteNoiseConfigSpec.IntValue HUNGER;
        private final WhiteNoiseConfigSpec.IntValue SATURATION;
        private final WhiteNoiseConfigSpec.BooleanValue ENABLE_HEALTH_PENALTY;
        private final WhiteNoiseConfigSpec.DoubleValue HEALTH;
        private final WhiteNoiseConfigSpec.DoubleValue STARTING_HEALTH_PENALTY;
        private final WhiteNoiseConfigSpec.IntValue GENERIC_DAMAGE;
        private final WhiteNoiseConfigSpec.BooleanValue INVERT_LIST_TO_WHITELIST;
        private static final List<String> MODS_LIST = List.of("mods");
        public static final String[] modsStrings = new String[0];
        private static final Predicate<Object> modidValidator = s -> s instanceof String && ((String)s).matches("^[a-z][a-z0-9_]{1,63}$");
        private static WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> MODS;
        private static final List<String> ITEMS_LIST;
        public static final String[] itemsStrings;
        private static final Predicate<Object> itemidValidator;
        private static WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> ITEMS;
        private static WhiteNoiseConfigSpec.BooleanValue LOG_MODPACK_DATA;
        private static final List<String> BLOCK_MODS_LIST;
        public static final String[] blockModsStrings;
        private static WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> BLOCK_MODS;
        private static final List<String> ARMOR_MODS_LIST;
        public static final String[] armorModsStrings;
        private static WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> ARMOR_MODS;
        private static final List<String> ARMOR_LIST;
        public static final String[] armorStrings;
        private static final Predicate<Object> resourceLocationValidator;
        private static WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> ARMORS;
        private static final List<String> TAG_LIST;
        public static final String[] tagStrings;
        private static final List<TagKey<Item>> tagList;
        private static WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> TAGS;

        Common(WhiteNoiseConfigSpec.Builder builder) {
            this.FLINT_CHANCE = builder.comment(ConfigHandler.getTranslation("flintchance")).defineInRange("FLINT_CHANCE", 0.6, 0.1, 1.0);
            this.HEAL_RATE = builder.comment(ConfigHandler.getTranslation("healrate")).defineInRange("HEAL_RATE", 0.14, 0.1, 1.0);
            this.SLOW_DOWN_SPEED = builder.comment(ConfigHandler.getTranslation("slowdownspeed")).defineInRange("SLOW_DOWN_SPEED", 0.4, 0.1, 1.0);
            this.INVERT_LIST_TO_WHITELIST = builder.comment(ConfigHandler.getTranslation("invertlisttowhitelist")).define("INVERT_LIST_TO_WHITELIST", false);
            MODS = builder.comment(ConfigHandler.getTranslation("modslist")).defineListAllowEmpty(MODS_LIST, Common.getFields(modsStrings), modidValidator);
            ITEMS = builder.comment(ConfigHandler.getTranslation("itemslist")).defineListAllowEmpty(ITEMS_LIST, Common.getFields(itemsStrings), itemidValidator);
            LOG_MODPACK_DATA = builder.comment(ConfigHandler.getTranslation("logmodpackdata")).define("LOG_MODPACK_DATA", false);
            BLOCK_MODS = builder.comment(ConfigHandler.getTranslation("blockmodslist")).defineListAllowEmpty(BLOCK_MODS_LIST, Common.getFields(blockModsStrings), modidValidator);
            this.ENABLE_HUNGER_PENALTY = builder.comment(ConfigHandler.getTranslation("enablehungerpenalty")).define("ENABLE_HUNGER_PENALTY", false);
            this.HUNGER = builder.comment(ConfigHandler.getTranslation("hunger")).defineInRange("HUNGER", 8, 0, 20);
            this.SATURATION = builder.comment(ConfigHandler.getTranslation("saturation")).defineInRange("SATURATION", 0, 0, 20);
            this.ENABLE_HEALTH_PENALTY = builder.comment(ConfigHandler.getTranslation("enablehealthpenalty")).define("ENABLE_HEALTH_PENALTY", false);
            this.HEALTH = builder.comment(ConfigHandler.getTranslation("health")).defineInRange("HEALTH", 6.0, 0.5, 100.0);
            this.STARTING_HEALTH_PENALTY = builder.comment(ConfigHandler.getTranslation("startinghealthpenalty")).defineInRange("STARTING_HEALTH_PENALTY", 0.0, 0.0, 19.0);
            this.GENERIC_DAMAGE = builder.comment(ConfigHandler.getTranslation("genericdamage")).defineInRange("GENERIC_DAMAGE", 0, 0, 4);
            ARMOR_MODS = builder.comment(ConfigHandler.getTranslation("armormodslist")).defineListAllowEmpty(ARMOR_MODS_LIST, Common.getFields(armorModsStrings), modidValidator);
            ARMORS = builder.comment(ConfigHandler.getTranslation("armorlist")).defineListAllowEmpty(ARMOR_LIST, Common.getFields(armorStrings), resourceLocationValidator);
            TAGS = builder.comment(ConfigHandler.getTranslation("taglist")).defineListAllowEmpty(TAG_LIST, Common.getFields(tagStrings), resourceLocationValidator);
        }

        public static double flintChance() {
            return (Double)ConfigHandler.COMMON.FLINT_CHANCE.get();
        }

        public static double healRate() {
            return (Double)ConfigHandler.COMMON.HEAL_RATE.get();
        }

        public static boolean invertListToWhitelist() {
            return (Boolean)ConfigHandler.COMMON.INVERT_LIST_TO_WHITELIST.get();
        }

        public static float slowDownSpeed() {
            double slowDownSpeed = (Double)ConfigHandler.COMMON.SLOW_DOWN_SPEED.get();
            return (float)slowDownSpeed;
        }

        private static Supplier<List<? extends String>> getFields(String[] strings) {
            return () -> Arrays.asList(strings);
        }

        public static List<? extends String> getMods() {
            return (List)MODS.get();
        }

        public static List<? extends String> getItems() {
            return (List)ITEMS.get();
        }

        public static boolean logModpackData() {
            return (Boolean)LOG_MODPACK_DATA.get();
        }

        public static List<? extends String> blockWhitelistMods() {
            return (List)BLOCK_MODS.get();
        }

        public static boolean enableHungerPenalty() {
            return (Boolean)ConfigHandler.COMMON.ENABLE_HUNGER_PENALTY.get();
        }

        public static int hunger() {
            return (Integer)ConfigHandler.COMMON.HUNGER.get();
        }

        public static int saturation() {
            return (Integer)ConfigHandler.COMMON.SATURATION.get();
        }

        public static boolean enableHealthPenalty() {
            return (Boolean)ConfigHandler.COMMON.ENABLE_HEALTH_PENALTY.get();
        }

        public static float health() {
            double health = (Double)ConfigHandler.COMMON.HEALTH.get();
            return (float)health;
        }

        public static float startingHealthPenalty() {
            double health = (Double)ConfigHandler.COMMON.STARTING_HEALTH_PENALTY.get();
            return (float)(health *= -1.0);
        }

        public static float genericDamage() {
            int damage = (Integer)ConfigHandler.COMMON.GENERIC_DAMAGE.get();
            return damage;
        }

        public static List<? extends String> armorMods() {
            return (List)ARMOR_MODS.get();
        }

        public static List<? extends String> armorItems() {
            return (List)ARMORS.get();
        }

        public static List<TagKey<Item>> tagList() {
            return tagList;
        }

        static {
            ITEMS_LIST = List.of("items");
            itemsStrings = new String[]{"pickaxe-minecraft:diamond_pickaxe"};
            itemidValidator = s -> s instanceof String && ((String)s).matches("[a-z]+[-]{1}[a-z][a-z0-9_]{1,63}+[:]{1}[a-z_]+");
            BLOCK_MODS_LIST = List.of("blockmods");
            blockModsStrings = new String[]{"comforts"};
            ARMOR_MODS_LIST = List.of("armormods");
            armorModsStrings = new String[0];
            ARMOR_LIST = List.of("armor");
            armorStrings = new String[0];
            resourceLocationValidator = s -> s instanceof String && ((String)s).matches("[a-z]+[:]{1}[a-z_]+");
            TAG_LIST = List.of("tag");
            tagStrings = new String[]{"c:blacklist_tools"};
            tagList = new ArrayList<TagKey<Item>>();
        }
    }

    public static final class Client {
        private final WhiteNoiseConfigSpec.BooleanValue ENABLE_FAIL_SOUND;
        private final WhiteNoiseConfigSpec.BooleanValue INFORM_TCON_COMPAT;

        Client(WhiteNoiseConfigSpec.Builder builder) {
            this.ENABLE_FAIL_SOUND = builder.comment(ConfigHandler.getTranslation("enablefailsound")).define("ENABLE_FAIL_SOUND", false);
            this.INFORM_TCON_COMPAT = builder.comment(ConfigHandler.getTranslation("informtconcompat")).define("INFORM_TCON_COMPAT", true);
        }

        public static boolean enableFailSound() {
            return (Boolean)ConfigHandler.CLIENT.ENABLE_FAIL_SOUND.get();
        }

        public static boolean informTConCompat() {
            return (Boolean)ConfigHandler.CLIENT.INFORM_TCON_COMPAT.get();
        }

        public static void disableTConCompatMessage() {
            ConfigHandler.CLIENT.INFORM_TCON_COMPAT.set((Object)false);
            ConfigHandler.CLIENT.INFORM_TCON_COMPAT.save();
        }
    }
}

