/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.data.client;

import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;
import survivalistessentials.common.Translations;

public class SurvivalistEssentialsLanguageProvider
extends LanguageProvider {
    public SurvivalistEssentialsLanguageProvider(PackOutput output) {
        super(output, "survivalistessentials", "en_us");
    }

    protected void addTranslations() {
        this.add("survivalistessentials.items", "Survivalist Essentials Items");
        this.addTranslationItem("plant_fiber", "Plant Fibers");
        this.addTranslationItem("plant_string", "Plant String");
        this.addTranslationItem("flint_shard", "Flint Shard");
        this.addTranslationItem("crude_knife", "Crude Knife");
        this.addTranslationItem("basic_knife", "Basic Knife");
        this.addTranslationItem("sharp_knife", "Sharp Knife");
        this.addTranslationItem("crude_hatchet", "Crude Hatchet");
        this.addTranslationItem("crude_saw", "Crude Saw");
        this.addTranslationItem("basic_saw", "Basic Saw");
        this.addTranslationItem("sharp_saw", "Sharp Saw");
        this.addTranslationItem("crude_saw_blade", "Crude Saw Blade");
        this.addTranslationItem("basic_saw_blade", "Basic Saw Blade");
        this.addTranslationItem("sharp_saw_blade", "Sharp Saw Blade");
        this.addTranslationItem("saw_handle", "Saw Handle");
        this.addTranslationItem("knife", "Knife");
        this.addTranslationItem("knife.description", "For cutting stuff.");
        this.addTranslationItem("mortar_and_pestle", "Mortar and Pestle");
        this.addTranslationItem("saw", "Saw");
        this.addTranslationItem("saw_blade", "Saw Blade");
        this.addTranslationItem("saw.description", "For cutting wood!");
        this.addTranslationItem("saw_blade_cast", "Saw Blade Cast");
        this.addTranslationItem("saw_blade_sand_cast", "Saw Blade Sand Cast");
        this.addTranslationItem("saw_blade_red_sand_cast", "Saw Blade Red Sand Cast");
        this.addTranslationItem("reinforced_wool_helmet", "Reinforced Wool Helmet");
        this.addTranslationItem("reinforced_wool_chestplate", "Reinforced Wool Chestplate");
        this.addTranslationItem("reinforced_wool_leggings", "Reinforced Wool Leggings");
        this.addTranslationItem("reinforced_wool_boots", "Reinforced Wool Boots");
        this.addTranslationItem("reinforced_jelled_slime_helmet", "Reinforced Slime Helmet");
        this.addTranslationItem("reinforced_jelled_slime_chestplate", "Reinforced Slime Chestplate");
        this.addTranslationItem("reinforced_jelled_slime_leggings", "Reinforced Slime Leggings");
        this.addTranslationItem("reinforced_jelled_slime_boots", "Reinforced Slime Boots");
        this.addTranslationItem("bandage", "Bandage");
        this.addTranslationItem("cloth", "Cloth");
        this.addTranslationItem("crude_bandage", "Crude Bandage");
        this.addTranslationItem("ointment", "Ointment");
        this.addTranslationItem("plant_paste", "Plant Paste");
        this.addTranslationItem("wooden_cup", "Mysterious Wooden Cup");
        this.addTranslationItem("book", "Survivalist Essentials");
        this.addTranslationItem("modpack_book", "Survivalist Essentials+");
        this.addTranslationBlock("rock_stone_block", "Rock");
        this.addTranslationBlock("stone_loose_rock", "Loose Rock (Stone)");
        this.addTranslationBlock("andesite_loose_rock", "Loose Rock (Andesite)");
        this.addTranslationBlock("diorite_loose_rock", "Loose Rock (Diorite)");
        this.addTranslationBlock("granite_loose_rock", "Loose Rock (Granite)");
        this.addTranslationBlock("sandstone_loose_rock", "Loose Rock (Sandstone)");
        this.addTranslationBlock("red_sandstone_loose_rock", "Loose Rock (Red Sandstone)");
        this.addJeiDescription("rock_stone", "Rocks are found lying on the ground. These can be used with the knife in a crafting table to get flint shards.");
        this.addJeiDescription("plant_fiber", "Plant fibers are dropped when breaking grass or leaves with a knife. They are used to make plant string for tools and plant paste for bandage ointment.");
        this.addJeiDescription("stick", "Sticks are dropped from leaves. Using any knife doubles the chance of getting a stick.");
        this.addJeiDescription("flint_shard", "Flint shards can be obtained from striking a rock on any rocky surface. Interact with any stone-like block with a rock, and it might split into two flint shards.");
        this.addTranslationTooltip("uselessTool1", "This tool cannot mine anything!");
        this.addTranslationTooltip("uselessTool2", "Can only be used for crafting.");
        this.addTranslationTooltip("uselessHoe1", "This hoe cannot hoe anything!");
        this.addTranslationTooltip("uselessWeapon1", "This weapon hits like a wet noodle!");
        this.addTranslationTooltip("uselessBow1", "This bows bowstring snapped!");
        this.addTranslationTooltip("uselessArmor1", "Axiom sizing: XXXL. Probably won't fit.");
        this.addTranslationTooltip("cxp", "Crafty");
        this.addTranslationMessage("tcon_compat", "It is recommended to install Tinkers' Survival with Survivalist Essentials for better compatibility with Tinkers' Construct. It offers Tinkers' versions of the Saw and Knife!");
        this.addTranslationMessage("notice", "Notice");
        this.addTranslationMessage("warning", "Warning");
        this.addTranslationMessage("wrong_tool", "A %s is required.");
        this.addTranslationMessage("wrong_tool2", "Ummm ... %s?");
        this.addTranslationMessage("tool_broke", "Your %s broke.");
        this.addTranslationMessage("spawn_set", "Not sleepy, but spawn set!");
        this.addTranslationEffect("stop_bleeding", "Stop Bleeding");
        this.addTranslationEffect("zombie_essence", "Zombie Essence");
        this.addTranslationPattern("saw_blade", "Saw Blade");
        this.addConfigurationTitle("Survivalist Essentials");
        this.addConfigurationName("enablefailsound", "Enable Fail Sound");
        this.addConfigurationDescription("enablefailsound", "enablefailsound");
        this.addConfigurationName("informtconcompat", "Inform Tinkers' Construct Compatibility");
        this.addConfigurationDescription("informtconcompat", "informtconcompat");
        this.addConfigurationName("flintchance", "Flint Knapping Chance");
        this.addConfigurationDescription("flintchance", "flintchance");
        this.addConfigurationName("healrate", "Bandage Heal Rate");
        this.addConfigurationDescription("healrate", "healrate");
        this.addConfigurationName("slowdownspeed", "Incorrect Tool Slowdown Speed");
        this.addConfigurationDescription("slowdownspeed", "slowdownspeed");
        this.addConfigurationName("invertlisttowhitelist", "Invert Tool List to Whitelist");
        this.addConfigurationDescription("invertlisttowhitelist", "invertlisttowhitelist");
        this.addConfigurationName("mods", "Tool Mods List");
        this.addConfigurationDescription("mods", "modslist");
        this.addConfigurationName("items", "Tool Items List");
        this.addConfigurationDescription("items", "itemslist");
        this.addConfigurationName("logmodpackdata", "Log Modpack Data");
        this.addConfigurationDescription("logmodpackdata", "logmodpackdata");
        this.addConfigurationName("blockmods", "Block Mods List");
        this.addConfigurationDescription("blockmods", "blockmodslist");
        this.addConfigurationName("enablehungerpenalty", "Enable Hunger Penalty");
        this.addConfigurationDescription("enablehungerpenalty", "enablehungerpenalty");
        this.addConfigurationName("hunger", "Hunger After Death");
        this.addConfigurationDescription("hunger", "hunger");
        this.addConfigurationName("saturation", "Saturation After Death");
        this.addConfigurationDescription("saturation", "saturation");
        this.addConfigurationName("enablehealthpenalty", "Enable Health Penalty");
        this.addConfigurationDescription("enablehealthpenalty", "enablehealthpenalty");
        this.addConfigurationName("health", "Health After Death");
        this.addConfigurationDescription("health", "health");
        this.addConfigurationName("startinghealthpenalty", "Starting Health Penalty");
        this.addConfigurationDescription("startinghealthpenalty", "startinghealthpenalty");
        this.addConfigurationName("genericdamage", "Generic Tool Damage");
        this.addConfigurationDescription("genericdamage", "genericdamage");
        this.addConfigurationName("armormods", "Armor Mods List");
        this.addConfigurationDescription("armormods", "armormodslist");
        this.addConfigurationName("armor", "Armor Items List");
        this.addConfigurationDescription("armor", "armorlist");
        this.addConfigurationName("tag", "Tool and Armor Tags List");
        this.addConfigurationDescription("tag", "taglist");
        this.addTranslationAdvancement("root.title", "Survivalist Essentials");
        this.addTranslationAdvancement("root.desc", "You're bound to ...");
        this.addTranslationAdvancement("sticks_and_stones.title", "Throw your Sticks and Stones");
        this.addTranslationAdvancement("sticks_and_stones.desc", "Pick up a rock from the ground and leaves might give some sticks");
        this.addTranslationAdvancement("flint_shard.title", "Rock + rock");
        this.addTranslationAdvancement("flint_shard.desc", "Maybe hitting your round rock on a cube rock will work");
        this.addTranslationAdvancement("crude_knife.title", "Crude, but still a knife");
        this.addTranslationAdvancement("crude_knife.desc", "Not a really good weapon, but pretty good as a lawnmower");
        this.addTranslationAdvancement("plant_string.title", "Crude String");
        this.addTranslationAdvancement("plant_string.desc", "Obtain a Plant String");
        this.addTranslationAdvancement("crude_hatchet.title", "Your first wood?");
        this.addTranslationAdvancement("crude_hatchet.desc", "Obtain a Crude Hatchet");
        this.addTranslationAdvancement("crude_saw.title", "Your first planks");
        this.addTranslationAdvancement("crude_saw.desc", "Obtain a Crude Saw");
        this.addTranslationAdvancement("getting_wood.title", "Getting Wood");
        this.addTranslationAdvancement("getting_wood.desc", "I got some wood.");
        this.addGuidebookTranslation("subtitle", "A Path to Survival");
        this.addGuidebookTranslation("intro", "Welcome to Survivalist Essentials!$(br)$(br)There are few very important things to remember when playing:$(br)$(li)A correct tool is required for harvesting.$(li)The only way to craft Wooden Planks and Sticks is with a saw.");
        this.addGuidebookTranslation("getting_started.name", "Getting Started");
        this.addGuidebookTranslation("getting_started.desc", "Gathering basic materials for crafting crude tools is essential for getting started. The following pages will cover what you MUST gather to survive.");
        this.addGuidebookTranslation("getting_started.materials.name", "Materials Gathering");
        this.addGuidebookTranslation("getting_started.materials.gather_stones.title", "Gathering Stones");
        this.addGuidebookTranslation("getting_started.materials.gather_stones.desc", "You may notice right away some small piles of rocks lying randomly on the ground throughout the world.$(br)$(br)Break and gather them quickly, they are a valuable AND necessary resource and needed for crafting tools.");
        this.addGuidebookTranslation("getting_started.materials.gather_sticks.title", "Get Sticks!!!");
        this.addGuidebookTranslation("getting_started.materials.gather_sticks.desc", "Sticks are essenial for creating your first Crude Tools. These are the most basic handles.$(br)$(br)Punching leaves and will drop sticks. The drop rate is not great but it will allow you to get sticks. Once you craft a knife, you can use it to increase the drop rate.");
        this.addGuidebookTranslation("getting_started.materials.flint_shards.title", "Flint Shards");
        this.addGuidebookTranslation("getting_started.materials.flint_shards.desc", "Crude tools need Flint Shards!$(br)$(br)Simply knapp (right-click) Rocks you've gathered on a hard surface (any regular Stone/Cobblestone/Granite/etc. hard blocks) and with a bit of luck, you can split them in half to obtain shards.$(br)$(br)Once you have the $(l:survivalistessentials:tools/crude_tools)Crude Knife$(), you can make more shards in your crafting grid.");
        this.addGuidebookTranslation("getting_started.materials.plant_fiber.title", "Plant Fiber");
        this.addGuidebookTranslation("getting_started.materials.plant_fiber.desc", "Next you'll need to get some Plant Fiber.$(br)$(br)Plant Fiber is a new drop when breaking grass or most plants with the Crude Knife. Grass is probably the easiest way to get Plant Fiber.$(br)$(br)You'll need Plant Fiber to craft Plant String used in crafting the Crude Hatchet, Crude Saw and Bandages.");
        this.addGuidebookTranslation("getting_started.materials.plant_string.title", "Plant String");
        this.addGuidebookTranslation("getting_started.materials.plant_string.desc", "Plant String is essential for crafting the Crude Hatchet and Crude Saw. Gather enough Plant Fiber!");
        this.addGuidebookTranslation("tools.name", "Tools");
        this.addGuidebookTranslation("tools.desc", "Tools are essential for gathering materials and getting your first wood planks!$(br)$(br)Punching trees is no longer an option, so you'll need these most basic tools to be able to craft better tools, or more advanced items using the crafting table.");
        this.addGuidebookTranslation("tools.crude_tools.name", "Crude Tools");
        this.addGuidebookTranslation("tools.crude_tools.knife.desc", "Crude Knife is essential for gathering Plant Fiber. This MUST be the first tool crafted to progress.");
        this.addGuidebookTranslation("tools.crude_tools.knife_recipes.name", "Crude Knife Recipes");
        this.addGuidebookTranslation("tools.crude_tools.knife_recipes.desc", "In addition to more shards, you can also craft in any crafting grid:$(br)$(li)String: knife and wool$(br)$(li)Sticks: knife and saplings");
        this.addGuidebookTranslation("tools.crude_tools.hatchet.desc", "Crude Hatchet is essential for gathering wood. You can now chop down trees!");
        this.addGuidebookTranslation("tools.crude_tools.crude_saw_blade.desc", "Crude Saw Blade is the first part for the Crude Saw. Blades are replaceable on the Saw. The crude blades have only half the output of sharper blade materials.");
        this.addGuidebookTranslation("tools.crude_tools.saw_handle.desc", "The Saw Handle is a reusable part for crafting the Crude Saw. Once the blade breaks, just reuse the left over handle to create a new Saw.");
        this.addGuidebookTranslation("tools.crude_tools.crude_saw.desc", "Crude Saw will allow you to craft planks! Upgrade the blade to increase plank output and durability.");
        this.addGuidebookTranslation("tools.crude_tools.planks.name", "Planks");
        this.addGuidebookTranslation("tools.crude_tools.planks.desc", "Here is an example recipe with the Crude Saw that will allow you to craft planks!");
        this.addGuidebookTranslation("tools.crude_tools.sticks.name", "Sticks");
        this.addGuidebookTranslation("tools.crude_tools.sticks.desc", "Here is an example recipe with the Crude Saw that will allow you to craft sticks!");
        this.addGuidebookTranslation("tools.improved_tools.name", "Improved Tools");
        this.addGuidebookTranslation("tools.improved_tools.subtitle", "Get sharper tools!");
        this.addGuidebookTranslation("tools.improved_tools.intro", "While crude tools will get you started, you'll want to create more durable tools.");
        this.addGuidebookTranslation("health.name", "Health");
        this.addGuidebookTranslation("health.desc", "It's a little more difficult getting started. To help with the process, some basic bandages are available to help in the early game.");
        this.addGuidebookTranslation("health.ingredients.name", "Ingredients");
        this.addGuidebookTranslation("health.ingredients.subtitle", "It's the little things...");
        this.addGuidebookTranslation("health.ingredients.desc", "There are several basic materials required for making bandages.");
        this.addGuidebookTranslation("health.ingredients.cloth.desc", "Cloth is an ingredient used for making Bandages.");
        this.addGuidebookTranslation("health.ingredients.mortar_and_pestle.desc", "Essential tool for crafting plant paste.");
        this.addGuidebookTranslation("health.ingredients.plant_paste.desc", "Essential ingredient for Ointment.");
        this.addGuidebookTranslation("health.ingredients.ointment.desc", "Ointment is an ingredient used for making Bandages.");
        this.addGuidebookTranslation("health.bandages.name", "Bandages");
        this.addGuidebookTranslation("health.bandages.subtitle", "Stop the bleeding...");
        this.addGuidebookTranslation("health.bandages.desc", "Crude bandages are simple to make. Bandages are a little more work, but do a much better job of stopping the bleeding.");
        this.addGuidebookTranslation("health.bandages.crude_bandage.desc", "Cheap bandage, great for early game.");
        this.addGuidebookTranslation("health.bandages.bandage.desc", "Better bandage, great for mid game.");
    }

    private void addTranslationItem(String id, String name) {
        this.add("item.survivalistessentials." + id, name);
    }

    private void addTranslationBlock(String id, String name) {
        this.add("block.survivalistessentials." + id, name);
    }

    private void addJeiDescription(String id, String description) {
        this.add("jei.survivalistessentials.description." + id, description);
    }

    private void addTranslationTooltip(String id, String tooltip) {
        this.add("tooltip.survivalistessentials." + id, tooltip);
    }

    private void addTranslationMessage(String id, String message) {
        this.add("message.survivalistessentials." + id, message);
    }

    private void addTranslationEffect(String id, String effect) {
        this.add("effect.survivalistessentials." + id, effect);
    }

    private void addTranslationPattern(String id, String pattern) {
        this.add("pattern.survivalistessentials." + id, pattern);
    }

    private void addTranslationAdvancement(String id, String text) {
        this.add("advancements.survivalistessentials." + id, text);
    }

    private void addGuidebookTranslation(String id, String text) {
        this.add("info.survivalistessentials.book." + id, text);
    }

    private void addConfigurationTitle(String title) {
        this.add("survivalistessentials.configuration.title", title);
    }

    private void addConfigurationName(String id, String name) {
        this.add("survivalistessentials.configuration." + id + ".name", name);
    }

    private void addConfigurationDescription(String id) {
        this.add("survivalistessentials.configuration." + id + ".description", Translations.get(id));
    }

    private void addConfigurationDescription(String id, String key) {
        this.add("survivalistessentials.configuration." + id + ".description", Translations.get(key));
    }
}

