/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.data.loot;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import org.jetbrains.annotations.NotNull;
import survivalistessentials.common.TagManager;
import survivalistessentials.common.loot.LootItemBlockIsTagCondition;
import survivalistessentials.items.SurvivalistEssentialsItems;
import survivalistessentials.loot.SurvivalistEssentialsLootTables;

public class GlobalLootModifier
extends GlobalLootModifierProvider {
    public GlobalLootModifier(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider, "survivalistessentials");
    }

    @NotNull
    public String getName() {
        return "SurvivalistEssentials - Global Loot Modifier";
    }

    protected void start() {
        this.addPlantFiberDrops(TagManager.Blocks.FIBER_PLANTS, "fiber_plants");
        this.addStickDrops((TagKey<Block>)BlockTags.LEAVES, "leaves");
        this.addToolLoot(BuiltInLootTables.VILLAGE_TOOLSMITH.location(), "village_toolsmith_crude_knife", SurvivalistEssentialsItems.CRUDE_KNIFE);
        this.addToolLoot(BuiltInLootTables.VILLAGE_TOOLSMITH.location(), "village_toolsmith_crude_hatchet", SurvivalistEssentialsItems.CRUDE_HATCHET);
        this.addToolLoot(BuiltInLootTables.VILLAGE_TOOLSMITH.location(), "village_toolsmith_crude_saw", SurvivalistEssentialsItems.CRUDE_SAW);
        this.addRareLoot(BuiltInLootTables.VILLAGE_TOOLSMITH.location(), "village_fisher_wooden_cup", SurvivalistEssentialsItems.WOODEN_CUP);
        this.addRareLoot(BuiltInLootTables.BURIED_TREASURE.location(), "buried_treasure_wooden_cup", SurvivalistEssentialsItems.WOODEN_CUP);
        this.addRareLoot(BuiltInLootTables.SHIPWRECK_TREASURE.location(), "shipwreck_treasure_wooden_cup", SurvivalistEssentialsItems.WOODEN_CUP);
        this.addRareLoot(BuiltInLootTables.FISHING_TREASURE.location(), "fishing_treasure_wooden_cup", SurvivalistEssentialsItems.WOODEN_CUP);
    }

    public void addPlantFiberDrops(TagKey<Block> tag, String name) {
        this.add("plant_fiber_from_" + name, (IGlobalLootModifier)new SurvivalistEssentialsLootTables.LootTableModifier(GlobalLootModifier.createKnifeChanceCondition(0.16f, tag), new ItemStack((ItemLike)SurvivalistEssentialsItems.PLANT_FIBER)), new ICondition[0]);
    }

    public void addStickDrops(TagKey<Block> tag, String name) {
        this.add("stick_drops_from_" + name, (IGlobalLootModifier)new SurvivalistEssentialsLootTables.LootTableModifier(GlobalLootModifier.createKnifeChanceCondition(0.16f, tag), new ItemStack((ItemLike)Items.STICK)), new ICondition[0]);
        this.add("extra_stick_drops_from_" + name, (IGlobalLootModifier)new SurvivalistEssentialsLootTables.LootTableModifier(this.createExtraStickDropConditions(0.16f, tag), new ItemStack((ItemLike)Items.STICK)), new ICondition[0]);
    }

    public void addToolLoot(ResourceLocation loc, String name, Item item) {
        this.add("tool_loot_" + name, (IGlobalLootModifier)new SurvivalistEssentialsLootTables.LootTableModifier(GlobalLootModifier.createResourceChanceCondition(0.05f, loc), new ItemStack((ItemLike)item)), new ICondition[0]);
    }

    public void addRareLoot(ResourceLocation loc, String name, Item item) {
        this.add("rare_loot_" + name, (IGlobalLootModifier)new SurvivalistEssentialsLootTables.LootTableModifier(GlobalLootModifier.createResourceChanceCondition(0.01f, loc), new ItemStack((ItemLike)item)), new ICondition[0]);
    }

    public static LootItemCondition[] createKnifeChanceCondition(float chance, TagKey<Block> tag) {
        return new LootItemCondition[]{LootItemRandomChanceCondition.randomChance((float)chance).build(), MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(TagManager.Items.KNIFE_TOOLS)).build(), LootItemBlockIsTagCondition.isTag(tag)};
    }

    private LootItemCondition.Builder hasSilkTouch() {
        HolderLookup.RegistryLookup enchantmentRegistryLookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)enchantmentRegistryLookup.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1))))));
    }

    public LootItemCondition[] createExtraStickDropConditions(float chance, TagKey<Block> tag) {
        return new LootItemCondition[]{LootItemRandomChanceCondition.randomChance((float)chance).build(), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityType.PLAYER)).build(), LootItemBlockIsTagCondition.isTag(tag), this.hasSilkTouch().invert().build(), MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(TagManager.Items.SHEAR_TOOLS)).invert().build()};
    }

    public static LootItemCondition[] createResourceChanceCondition(float chance, ResourceLocation loc) {
        return new LootItemCondition[]{LootItemRandomChanceCondition.randomChance((float)chance).build(), LootTableIdCondition.builder((ResourceLocation)loc).build()};
    }
}

