/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.data.recipes;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import org.jetbrains.annotations.NotNull;
import survivalistessentials.SurvivalistEssentials;
import survivalistessentials.common.TagManager;
import survivalistessentials.data.integration.SurvivalistEssentialsIntegration;
import survivalistessentials.items.SurvivalistEssentialsItems;
import survivalistessentials.world.SurvivalistEssentialsWorld;

public class ModRecipesProvider
extends RecipeProvider {
    public ModRecipesProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, provider);
    }

    public void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        Item rockStone = SurvivalistEssentialsWorld.ROCK_STONE;
        Item flintShard = SurvivalistEssentialsItems.FLINT_SHARD;
        Item plantFiber = SurvivalistEssentialsItems.PLANT_FIBER;
        Item plantString = SurvivalistEssentialsItems.PLANT_STRING;
        Item mortar = SurvivalistEssentialsItems.MORTAR_AND_PESTLE;
        Item plantPaste = SurvivalistEssentialsItems.PLANT_PASTE;
        Item ointment = SurvivalistEssentialsItems.OINTMENT;
        Item cloth = SurvivalistEssentialsItems.CLOTH;
        Item crudeKnife = SurvivalistEssentialsItems.CRUDE_KNIFE;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.COBBLESTONE).define(Character.valueOf('R'), (ItemLike)rockStone).pattern("RR").pattern("RR").unlockedBy("has_loose_rock", ModRecipesProvider.has((ItemLike)rockStone)).save(recipeOutput, SurvivalistEssentials.prefix("cobblestone_from_rocks"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)rockStone, (int)4).requires((ItemLike)Blocks.COBBLESTONE).unlockedBy("has_cobblestone", ModRecipesProvider.has((ItemLike)Blocks.COBBLESTONE)).save(recipeOutput, SurvivalistEssentials.prefix("rocks_from_cobblestone"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.FLINT).define(Character.valueOf('S'), (ItemLike)flintShard).pattern("SS").pattern("SS").unlockedBy("has_flint_shard", ModRecipesProvider.has((ItemLike)flintShard)).save(recipeOutput, SurvivalistEssentials.prefix("flint_from_shards"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)plantString).define(Character.valueOf('F'), (ItemLike)plantFiber).pattern("FF").pattern("F ").unlockedBy("has_plant_fiber", ModRecipesProvider.has((ItemLike)plantFiber)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)plantPaste).define(Character.valueOf('F'), (ItemLike)plantFiber).define(Character.valueOf('U'), (ItemLike)mortar).pattern("F").pattern("U").unlockedBy("has_plant_fiber", ModRecipesProvider.has((ItemLike)plantFiber)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)ointment).define(Character.valueOf('P'), (ItemLike)plantPaste).pattern("PP").pattern("PP").unlockedBy("has_plant_paste", ModRecipesProvider.has((ItemLike)plantPaste)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)cloth).define(Character.valueOf('S'), Tags.Items.STRINGS).pattern("SSS").unlockedBy("has_string", ModRecipesProvider.has((TagKey)Tags.Items.STRINGS)).save(recipeOutput);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{plantString}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STRING, (float)0.1f, (int)50).unlockedBy("has_plant_string", ModRecipesProvider.has((ItemLike)plantString)).save(recipeOutput, SurvivalistEssentials.prefix("string_from_plant_string"));
        RecipeOutput wrapped = recipeOutput.withConditions(new ICondition[]{new NotCondition((ICondition)new ModLoadedCondition("tinkersurvival"))});
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.CRUDE_SAW_BLADE).define(Character.valueOf('D'), (ItemLike)flintShard).define(Character.valueOf('S'), (ItemLike)plantString).define(Character.valueOf('I'), (ItemLike)Items.STICK).pattern("ID").pattern("SD").unlockedBy("has_plant_string", ModRecipesProvider.has((ItemLike)plantString)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.BASIC_SAW_BLADE).define(Character.valueOf('D'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('S'), Tags.Items.STRINGS).define(Character.valueOf('I'), (ItemLike)Items.STICK).pattern("ID").pattern("SD").unlockedBy("has_iron_ingot", ModRecipesProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.SHARP_SAW_BLADE).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).define(Character.valueOf('S'), Tags.Items.STRINGS).define(Character.valueOf('I'), (ItemLike)Items.STICK).pattern("ID").pattern("SD").unlockedBy("has_diamond", ModRecipesProvider.has((ItemLike)Items.DIAMOND)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)crudeKnife).define(Character.valueOf('S'), (ItemLike)flintShard).define(Character.valueOf('T'), (ItemLike)Items.STICK).pattern("S").pattern("T").unlockedBy("has_flint_shard", ModRecipesProvider.has((ItemLike)flintShard)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.BASIC_KNIFE).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('X'), Tags.Items.STRINGS).pattern("IX").pattern(" S").unlockedBy("has_iron_ingot", ModRecipesProvider.has((ItemLike)Items.IRON_INGOT)).save(wrapped);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.SHARP_KNIFE).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('X'), Tags.Items.STRINGS).pattern("DX").pattern(" S").unlockedBy("has_diamond", ModRecipesProvider.has((ItemLike)Items.DIAMOND)).save(wrapped);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.CRUDE_HATCHET).define(Character.valueOf('R'), (ItemLike)rockStone).define(Character.valueOf('S'), (ItemLike)plantString).define(Character.valueOf('I'), (ItemLike)Items.STICK).pattern("SR").pattern("I ").unlockedBy("has_loose_rock", ModRecipesProvider.has((ItemLike)rockStone)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.SAW_HANDLE).define(Character.valueOf('S'), (ItemLike)plantString).define(Character.valueOf('I'), (ItemLike)Items.STICK).pattern("IS").pattern(" I").unlockedBy("has_plant_string", ModRecipesProvider.has((ItemLike)plantString)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.CRUDE_SAW).define(Character.valueOf('H'), (ItemLike)SurvivalistEssentialsItems.SAW_HANDLE).define(Character.valueOf('B'), (ItemLike)SurvivalistEssentialsItems.CRUDE_SAW_BLADE).define(Character.valueOf('S'), (ItemLike)plantString).pattern("BS").pattern(" H").unlockedBy("has_crude_saw_handle", ModRecipesProvider.has((ItemLike)SurvivalistEssentialsItems.SAW_HANDLE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.BASIC_SAW).define(Character.valueOf('H'), (ItemLike)SurvivalistEssentialsItems.SAW_HANDLE).define(Character.valueOf('B'), (ItemLike)SurvivalistEssentialsItems.BASIC_SAW_BLADE).define(Character.valueOf('S'), Tags.Items.STRINGS).pattern("BS").pattern(" H").unlockedBy("has_iron_ingot", ModRecipesProvider.has((ItemLike)Items.IRON_INGOT)).save(wrapped);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)SurvivalistEssentialsItems.SHARP_SAW).define(Character.valueOf('H'), (ItemLike)SurvivalistEssentialsItems.SAW_HANDLE).define(Character.valueOf('B'), (ItemLike)SurvivalistEssentialsItems.SHARP_SAW_BLADE).define(Character.valueOf('S'), Tags.Items.STRINGS).pattern("BS").pattern(" H").unlockedBy("has_diamond", ModRecipesProvider.has((ItemLike)Items.DIAMOND)).save(wrapped);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)mortar).define(Character.valueOf('I'), (ItemLike)Items.STICK).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('R'), (ItemLike)rockStone).pattern("  I").pattern("PRP").pattern(" P ").unlockedBy("has_plant_fiber", ModRecipesProvider.has((ItemLike)plantFiber)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK).requires(ItemTags.SAPLINGS).requires(TagManager.Items.KNIFE_TOOLS).group("sticks").unlockedBy("has_sapling", ModRecipesProvider.has((TagKey)ItemTags.SAPLINGS)).save(recipeOutput, SurvivalistEssentials.prefix("stick_from_sapling"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STRING, (int)2).requires(ItemTags.WOOL).requires((ItemLike)crudeKnife).group("string").unlockedBy("has_wool", ModRecipesProvider.has((TagKey)ItemTags.WOOL)).save(recipeOutput, SurvivalistEssentials.prefix("string_from_wool"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STRING, (int)4).requires(ItemTags.WOOL).requires(TagManager.Items.ADVANCED_KNIFE_TOOLS).group("string").unlockedBy("has_wool", ModRecipesProvider.has((TagKey)ItemTags.WOOL)).save(recipeOutput, SurvivalistEssentials.prefix("string_from_wool_advanced"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)flintShard, (int)2).requires(TagManager.Items.FLINT_KNAPPABLE).requires(TagManager.Items.KNIFE_TOOLS).group("flint_shards").unlockedBy("has_crude_knife", ModRecipesProvider.has((ItemLike)crudeKnife)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)SurvivalistEssentialsItems.CRUDE_BANDAGE).define(Character.valueOf('P'), (ItemLike)plantString).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('F'), (ItemLike)plantFiber).pattern("SF").pattern("PF").unlockedBy("has_plant_string", ModRecipesProvider.has((ItemLike)plantString)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)SurvivalistEssentialsItems.BANDAGE).define(Character.valueOf('P'), (ItemLike)plantString).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('C'), (ItemLike)cloth).define(Character.valueOf('O'), (ItemLike)ointment).pattern("SC").pattern("PO").unlockedBy("has_ointment", ModRecipesProvider.has((ItemLike)ointment)).save(recipeOutput);
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of(TagManager.Items.COOKED_MEAT), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.LEATHER, (float)0.35f, (int)100).unlockedBy("has_cooked_meat", ModRecipesProvider.has(TagManager.Items.COOKED_MEAT)).save(recipeOutput, SurvivalistEssentials.prefix("leather_from_cooked_meat_smoking"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)SurvivalistEssentialsItems.BOOK).requires((ItemLike)Items.DIRT).requires((ItemLike)Items.DIRT).group("books").unlockedBy("has_loose_rock", ModRecipesProvider.has((ItemLike)rockStone)).save(recipeOutput, SurvivalistEssentials.prefix("book_from_dirt"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.DIRT, (int)2).requires((ItemLike)SurvivalistEssentialsItems.BOOK).group("books").unlockedBy("has_intro_book", ModRecipesProvider.has((ItemLike)SurvivalistEssentialsItems.BOOK)).save(recipeOutput, SurvivalistEssentials.prefix("dirt_from_book"));
        ModRecipesProvider.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.OAK_PLANKS, (TagKey<Item>)ItemTags.OAK_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.ACACIA_PLANKS, (TagKey<Item>)ItemTags.ACACIA_LOGS, "has_log");
        ModRecipesProvider.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.BIRCH_PLANKS, (TagKey<Item>)ItemTags.BIRCH_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.DARK_OAK_PLANKS, (TagKey<Item>)ItemTags.DARK_OAK_LOGS, "has_log");
        ModRecipesProvider.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.JUNGLE_PLANKS, (TagKey<Item>)ItemTags.JUNGLE_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.SPRUCE_PLANKS, (TagKey<Item>)ItemTags.SPRUCE_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.WARPED_PLANKS, (TagKey<Item>)ItemTags.WARPED_STEMS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.CRIMSON_PLANKS, (TagKey<Item>)ItemTags.CRIMSON_STEMS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.MANGROVE_PLANKS, (TagKey<Item>)ItemTags.MANGROVE_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(recipeOutput, (ItemLike)Blocks.CHERRY_PLANKS, (TagKey<Item>)ItemTags.CHERRY_LOGS, "has_logs");
        ModRecipesProvider.bambooRecipeBuilder(recipeOutput, (ItemLike)Blocks.BAMBOO_PLANKS, (TagKey<Item>)ItemTags.BAMBOO_BLOCKS, "has_bamboo_block");
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("fruitfulfun")});
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.CHERRY_PLANKS, TagManager.Items.CHERRY_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.CITRUS_PLANKS, TagManager.Items.CITRUS_LOGS, "has_logs");
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("biomemakeover")});
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_ANCIENT_OAK_PLANKS, TagManager.Items.BMO_ANCIENT_OAK_LOG, "has_logs", "wood/ancient_oak/", "ancient_oak_planks", "biomemakeover");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_ANCIENT_OAK_PLANKS, TagManager.Items.BMO_STRIPPED_ANCIENT_OAK_LOG, "has_logs", "wood/ancient_oak/", "ancient_oak_planks_stripped", "biomemakeover");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_ANCIENT_OAK_PLANKS, TagManager.Items.BMO_ANCIENT_OAK_WOOD, "has_logs", "wood/ancient_oak/", "ancient_oak_planks_wood", "biomemakeover");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_ANCIENT_OAK_PLANKS, TagManager.Items.BMO_STRIPPED_ANCIENT_OAK_WOOD, "has_logs", "wood/ancient_oak/", "ancient_oak_planks_wood_stripped", "biomemakeover");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_BLIGHTED_BALSA_PLANKS, TagManager.Items.BMO_BLIGHTED_BALSA_LOG, "has_logs", "wood/blighted_balsa/", "blighted_balsa_planks", "biomemakeover");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_BLIGHTED_BALSA_PLANKS, TagManager.Items.BMO_STRIPPED_BLIGHTED_BALSA_LOG, "has_logs", "wood/blighted_balsa/", "blighted_balsa_planks_stripped", "biomemakeover");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_BLIGHTED_BALSA_PLANKS, TagManager.Items.BMO_BLIGHTED_BALSA_WOOD, "has_logs", "wood/blighted_balsa/", "blighted_balsa_planks_wood", "biomemakeover");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_BLIGHTED_BALSA_PLANKS, TagManager.Items.BMO_STRIPPED_BLIGHTED_BALSA_WOOD, "has_logs", "wood/blighted_balsa/", "blighted_balsa_planks_wood_stipped", "biomemakeover");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_SWAMP_CYPRESS_PLANKS, TagManager.Items.BMO_SWAMP_CYPRESS_LOG, "has_logs", "wood/swamp_cypress/", "swamp_cypress_planks", "biomemakeover");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_SWAMP_CYPRESS_PLANKS, TagManager.Items.BMO_STRIPPED_SWAMP_CYPRESS_LOG, "has_logs", "wood/swamp_cypress/", "swamp_cypress_planks_stripped", "biomemakeover");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_SWAMP_CYPRESS_PLANKS, TagManager.Items.BMO_SWAMP_CYPRESS_WOOD, "has_logs", "wood/swamp_cypress/", "swamp_cypress_planks_wood", "biomemakeover");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_SWAMP_CYPRESS_PLANKS, TagManager.Items.BMO_STRIPPED_SWAMP_CYPRESS_WOOD, "has_logs", "wood/swamp_cypress/", "swamp_cypress_planks_wood_stripped", "biomemakeover");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_WILLOW_PLANKS, TagManager.Items.BMO_WILLOW_LOG, "has_logs", "wood/willow/", "willow_planks", "biomemakeover");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_WILLOW_PLANKS, TagManager.Items.BMO_STRIPPED_WILLOW_LOG, "has_logs", "wood/willow/", "willow_planks_stripped", "biomemakeover");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_WILLOW_PLANKS, TagManager.Items.BMO_WILLOW_WOOD, "has_logs", "wood/willow/", "willow_planks_wood", "biomemakeover");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BMO_WILLOW_PLANKS, TagManager.Items.BMO_STRIPPED_WILLOW_WOOD, "has_logs", "wood/willow/", "willow_planks_wood_stripped", "biomemakeover");
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")});
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_DEAD_PLANKS, TagManager.Items.BOP_DEAD_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_FIR_PLANKS, TagManager.Items.BOP_FIR_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_HELLBARK_PLANKS, TagManager.Items.BOP_HELLBARK_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_JACARANDA_PLANKS, TagManager.Items.BOP_JACARANDA_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_MAGIC_PLANKS, TagManager.Items.BOP_MAGIC_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_MAHOGANY_PLANKS, TagManager.Items.BOP_MAHOGANY_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_PALM_PLANKS, TagManager.Items.BOP_PALM_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_REDWOOD_PLANKS, TagManager.Items.BOP_REDWOOD_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_UMBRAN_PLANKS, TagManager.Items.BOP_UMBRAN_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOP_WILLOW_PLANKS, TagManager.Items.BOP_WILLOW_LOGS, "has_logs");
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("quark")});
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.QUARK_AZALEA_PLANKS, TagManager.Items.QUARK_AZALEA_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.QUARK_BLOSSOM_PLANKS, TagManager.Items.QUARK_BLOSSOM_LOGS, "has_logs");
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("allyoucaneat")});
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.AYCE_HAZEL_PLANKS, TagManager.Items.AYCE_HAZEL_LOGS, "has_logs");
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("tconstruct")});
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TCON_BLOODSHROOM_PLANKS, TagManager.Items.TCON_BLOODSHROOM_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TCON_GREENHEART_PLANKS, TagManager.Items.TCON_GREENHEART_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TCON_SKYROOT_PLANKS, TagManager.Items.TCON_SKYROOT_LOGS, "has_logs");
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("watersource")});
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.WS_PALM_TREE_PLANKS, TagManager.Items.WS_PALM_TREE_LOGS, "has_logs");
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("botania")});
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOTANIA_DREAMWOOD_PLANKS, TagManager.Items.BOTANIA_DREAMWOOD_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BOTANIA_LIVINGWOOD_PLANKS, TagManager.Items.BOTANIA_LIVINGWOOD_LOGS, "has_logs");
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("ars_nouveau")});
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.AN_ARCHWOOD_PLANKS, (TagKey<Item>)ItemTags.create((ResourceLocation)SurvivalistEssentials.loc("c", "logs/archwood")), "has_logs");
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("undergarden")});
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.UNDERGARDEN_GRONGLE_PLANKS, TagManager.Items.UNDERGARDEN_GRONGLE_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.UNDERGARDEN_SMOGSTEM_PLANKS, TagManager.Items.UNDERGARDEN_SMOGSTEM_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.UNDERGARDEN_WIGGLEWOOD_PLANKS, TagManager.Items.UNDERGARDEN_WIGGLEWOOD_LOGS, "has_logs");
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("biomeswevegone")});
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_WHITE_MANGROVE_PLANKS, TagManager.Items.BYG_WHITE_MANGROVE_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_REDWOOD_PLANKS, TagManager.Items.BYG_REDWOOD_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_BLUE_ENCHANTED_PLANKS, TagManager.Items.BYG_BLUE_ENCHANTED_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_GREEN_ENCHANTED_PLANKS, TagManager.Items.BYG_GREEN_ENCHANTED_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_MAHOGANY_PLANKS, TagManager.Items.BYG_MAHOGANY_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_BAOBAB_PLANKS, TagManager.Items.BYG_BAOBAB_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_JACARANDA_PLANKS, TagManager.Items.BYG_JACARANDA_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_CYPRESS_PLANKS, TagManager.Items.BYG_CYPRESS_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_PALM_PLANKS, TagManager.Items.BYG_PALM_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_EBONY_PLANKS, TagManager.Items.BYG_EBONY_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_RAINBOW_EUCALYPTUS_PLANKS, TagManager.Items.BYG_RAINBOW_EUCALYPTUS_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_ASPEN_PLANKS, TagManager.Items.BYG_ASPEN_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_FIR_PLANKS, TagManager.Items.BYG_FIR_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_SKYRIS_PLANKS, TagManager.Items.BYG_SKYRIS_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_CIKA_PLANKS, TagManager.Items.BYG_CIKA_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_HOLLY_PLANKS, TagManager.Items.BYG_HOLLY_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_MAPLE_PLANKS, TagManager.Items.BYG_MAPLE_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_PINE_PLANKS, TagManager.Items.BYG_PINE_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_WILLOW_PLANKS, TagManager.Items.BYG_WILLOW_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_WITCH_HAZEL_PLANKS, TagManager.Items.BYG_WITCH_HAZEL_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_ZELKOVA_PLANKS, TagManager.Items.BYG_ZELKOVA_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_IRONWOOD_PLANKS, TagManager.Items.BYG_IRONWOOD_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_SAKURA_PLANKS, TagManager.Items.BYG_SAKURA_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_PALO_VERDE_PLANKS, TagManager.Items.BYG_PALO_VERDE_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_SPIRIT_PLANKS, TagManager.Items.BYG_SPIRIT_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.BYG_FLORUS_STEM, TagManager.Items.BYG_FLORUS_STEMS, "has_logs");
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("twilightforest")});
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_CANOPY_PLANKS, TagManager.Items.TF_CANOPY_LOG, "has_logs", "wood/", "canopy_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_CANOPY_PLANKS, TagManager.Items.TF_CANOPY_STRIPPED_LOG, "has_logs", "wood/", "canopy_from_stripped_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_CANOPY_PLANKS, TagManager.Items.TF_CANOPY_WOOD, "has_logs", "wood/", "canopy_from_wood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_CANOPY_PLANKS, TagManager.Items.TF_CANOPY_STRIPPED_WOOD, "has_logs", "wood/", "canopy_from_stripped_wood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_DARK_PLANKS, TagManager.Items.TF_DARK_LOG, "has_logs", "wood/", "darkwood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_DARK_PLANKS, TagManager.Items.TF_DARK_STRIPPED_LOG, "has_logs", "wood/", "darkwood_from_stripped_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_DARK_PLANKS, TagManager.Items.TF_DARK_WOOD, "has_logs", "wood/", "darkwood_from_wood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_DARK_PLANKS, TagManager.Items.TF_DARK_STRIPPED_WOOD, "has_logs", "wood/", "darkwood_from_stripped_wood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MANGROVE_PLANKS, TagManager.Items.TF_MANGROVE_LOG, "has_logs", "wood/", "mangrove_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MANGROVE_PLANKS, TagManager.Items.TF_MANGROVE_STRIPPED_LOG, "has_logs", "wood/", "mangrove_from_stripped_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MANGROVE_PLANKS, TagManager.Items.TF_MANGROVE_WOOD, "has_logs", "wood/", "mangrove_from_wood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MANGROVE_PLANKS, TagManager.Items.TF_MANGROVE_STRIPPED_WOOD, "has_logs", "wood/", "mangrove_from_stripped_wood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MINING_PLANKS, TagManager.Items.TF_MINING_LOG, "has_logs", "wood/", "mining_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MINING_PLANKS, TagManager.Items.TF_MINING_STRIPPED_LOG, "has_logs", "wood/", "mining_from_stripped_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MINING_PLANKS, TagManager.Items.TF_MINING_WOOD, "has_logs", "wood/", "mining_from_wood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_MINING_PLANKS, TagManager.Items.TF_MINING_STRIPPED_WOOD, "has_logs", "wood/", "mining_from_stripped_wood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_SORTING_PLANKS, TagManager.Items.TF_SORTING_LOG, "has_logs", "wood/", "sorting_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_SORTING_PLANKS, TagManager.Items.TF_SORTING_STRIPPED_LOG, "has_logs", "wood/", "sorting_from_stripped_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_SORTING_PLANKS, TagManager.Items.TF_SORTING_WOOD, "has_logs", "wood/", "sorting_from_wood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_SORTING_PLANKS, TagManager.Items.TF_SORTING_STRIPPED_WOOD, "has_logs", "wood/", "sorting_from_stripped_wood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TIME_PLANKS, TagManager.Items.TF_TIME_LOG, "has_logs", "wood/", "time_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TIME_PLANKS, TagManager.Items.TF_TIME_STRIPPED_LOG, "has_logs", "wood/", "time_from_stripped_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TIME_PLANKS, TagManager.Items.TF_TIME_WOOD, "has_logs", "wood/", "time_from_wood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TIME_PLANKS, TagManager.Items.TF_TIME_STRIPPED_WOOD, "has_logs", "wood/", "time_from_stripped_wood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TRANSFORMATION_PLANKS, TagManager.Items.TF_TRANSFORMATION_LOG, "has_logs", "wood/", "transformation_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TRANSFORMATION_PLANKS, TagManager.Items.TF_TRANSFORMATION_STRIPPED_LOG, "has_logs", "wood/", "transformation_from_stripped_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TRANSFORMATION_PLANKS, TagManager.Items.TF_TRANSFORMATION_WOOD, "has_logs", "wood/", "transformation_from_wood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TRANSFORMATION_PLANKS, TagManager.Items.TF_TRANSFORMATION_STRIPPED_WOOD, "has_logs", "wood/", "transformation_from_stripped_wood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TWILIGHT_OAK_PLANKS, TagManager.Items.TF_TWILIGHT_OAK_LOG, "has_logs", "wood/", "twilight_oak_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TWILIGHT_OAK_PLANKS, TagManager.Items.TF_TWILIGHT_OAK_STRIPPED_LOG, "has_logs", "wood/", "twilight_oak_from_stripped_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TWILIGHT_OAK_PLANKS, TagManager.Items.TF_TWILIGHT_OAK_WOOD, "has_logs", "wood/", "twilight_oak_from_wood_planks", "twilightforest");
        ModRecipesProvider.itemPlankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.TF_TWILIGHT_OAK_PLANKS, TagManager.Items.TF_TWILIGHT_OAK_STRIPPED_WOOD, "has_logs", "wood/", "twilight_oak_from_stripped_wood_planks", "twilightforest");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.OAK_PLANKS, (int)64).requires(TagManager.Items.TF_GIANT_LOGS).requires(TagManager.Items.ADVANCED_SAW_TOOLS).group("planks").unlockedBy("has_advanced_saw", ModRecipesProvider.has(TagManager.Items.ADVANCED_SAW_TOOLS)).save(wrapped, SurvivalistEssentials.loc("twilightforest", "giant_log_to_oak_planks"));
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("aquaculture")});
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.OAK_PLANKS, (int)2).requires((ItemLike)SurvivalistEssentialsIntegration.AQUA_DRIFTWOOD).requires((ItemLike)SurvivalistEssentialsItems.CRUDE_SAW).group("planks").unlockedBy("has_driftwood", ModRecipesProvider.has(TagManager.Items.AQUA_DRIFTWOOD)).save(wrapped, SurvivalistEssentials.loc("aquaculture", "planks_from_driftwood"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.OAK_PLANKS, (int)4).requires((ItemLike)SurvivalistEssentialsIntegration.AQUA_DRIFTWOOD).requires(TagManager.Items.ADVANCED_SAW_TOOLS).group("planks").unlockedBy("has_driftwood", ModRecipesProvider.has(TagManager.Items.AQUA_DRIFTWOOD)).save(wrapped, SurvivalistEssentials.prefix("planks_from_driftwood"));
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("immersiveengineering")});
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)SurvivalistEssentialsIntegration.IE_STICK_TREATED, (int)2).requires(TagManager.Items.IE_TREATED_WOOD).requires((ItemLike)SurvivalistEssentialsItems.CRUDE_SAW).group("treated_sticks").unlockedBy("has_treated_planks", ModRecipesProvider.has(TagManager.Items.IE_TREATED_WOOD)).save(wrapped, SurvivalistEssentials.prefix("stick_treated"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)SurvivalistEssentialsIntegration.IE_STICK_TREATED, (int)4).requires(TagManager.Items.IE_TREATED_WOOD).requires(TagManager.Items.IE_TREATED_WOOD).requires(TagManager.Items.ADVANCED_SAW_TOOLS).group("treated_sticks").unlockedBy("has_treated_planks", ModRecipesProvider.has(TagManager.Items.IE_TREATED_WOOD)).save(wrapped, SurvivalistEssentials.loc("immersiveengineering", "crafting/stick_treated"));
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("ecologics")});
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.ECO_COCONUT_PLANKS, TagManager.Items.ECO_COCONUT_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.ECO_WALNUT_PLANKS, TagManager.Items.ECO_WALNUT_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.ECO_AZALEA_PLANKS, TagManager.Items.ECO_AZALEA_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.ECO_FLOWERING_AZALEA_PLANKS, TagManager.Items.ECO_FLOWERING_AZALEA_LOGS, "has_logs");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK, (int)2).requires(ItemTags.PLANKS).requires(TagManager.Items.SAW_TOOLS).group("sticks").unlockedBy("has_planks", ModRecipesProvider.has((TagKey)ItemTags.PLANKS)).save(recipeOutput);
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("malum")});
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.MALUM_RUNEWOOD_PLANKS, TagManager.Items.MALUM_RUNEWOOD_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.MALUM_SOULWOOD_PLANKS, TagManager.Items.MALUM_SOULWOOD_LOGS, "has_logs");
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("iceandfire")});
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.IFD_DREADWOOD_PLANKS, TagManager.Items.IFD_DREADWOOD_LOGS, "has_logs");
        wrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("regions_unexplored")});
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_ALPHA_PLANKS, TagManager.Items.RU_ALPHA_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_ACACIA_BRANCH, "regions_unexplored", "", "stick_from_acacia_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BAOBAB_PLANKS, TagManager.Items.RU_BAOBAB_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BAOBAB_BRANCH, "regions_unexplored", "", "stick_from_baobab_branch");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BIRCH_BRANCH, "regions_unexplored", "", "stick_from_birch_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BLACKWOOD_PLANKS, TagManager.Items.RU_BLACKWOOD_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BLACKWOOD_BRANCH, "regions_unexplored", "", "stick_from_blackwood_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BLUE_BIOSHROOM_PLANKS, TagManager.Items.RU_BLUE_BIOSHROOM_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BIOSHROOM_PLANKS, TagManager.Items.RU_BIOSHROOM_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BRIMWOOD_PLANKS, TagManager.Items.RU_BRIMWOOD_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_BRIMWOOD_BRANCH, "regions_unexplored", "", "stick_from_brimwood_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_COBALT_PLANKS, TagManager.Items.RU_COBALT_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_COBALT_BRANCH, "regions_unexplored", "", "stick_from_cobalt_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_CYPRESS_PLANKS, TagManager.Items.RU_CYPRESS_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_CYPRESS_BRANCH, "regions_unexplored", "", "stick_from_cypress_branch");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_DARK_OAK_BRANCH, "regions_unexplored", "", "stick_from_dark_oak_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_DEAD_PLANKS, TagManager.Items.RU_DEAD_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_DEAD_BRANCH, "regions_unexplored", "", "stick_from_dead_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_EUCALYPTUS_PLANKS, TagManager.Items.RU_EUCALYPTUS_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_EUCALYPTUS_BRANCH, "regions_unexplored", "", "stick_from_eucalyptus_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_GREEN_BIOSHROOM_PLANKS, TagManager.Items.RU_GREEN_BIOSHROOM_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_JOSHUA_PLANKS, TagManager.Items.RU_JOSHUA_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_JOSHUA_BRANCH, "regions_unexplored", "", "stick_from_joshua_branch");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_JUNGLE_BRANCH, "regions_unexplored", "", "stick_from_jungle_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_KAPOK_PLANKS, TagManager.Items.RU_KAPOK_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_KAPOK_BRANCH, "regions_unexplored", "", "stick_from_kapok_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_LARCH_PLANKS, TagManager.Items.RU_LARCH_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_LARCH_BRANCH, "regions_unexplored", "", "stick_from_larch_branch");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_MANGROVE_BRANCH, "regions_unexplored", "", "stick_from_mangrove_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_MAGNOLIA_PLANKS, TagManager.Items.RU_MAGNOLIA_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_MAGNOLIA_BRANCH, "regions_unexplored", "", "stick_from_magnolia_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_MAPLE_PLANKS, TagManager.Items.RU_MAPLE_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_MAPLE_BRANCH, "regions_unexplored", "", "stick_from_maple_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_MAUVE_PLANKS, TagManager.Items.RU_MAUVE_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_MAUVE_BRANCH, "regions_unexplored", "", "stick_from_mauve_branch");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_OAK_BRANCH, "regions_unexplored", "", "stick_from_oak_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_PALM_PLANKS, TagManager.Items.RU_PALM_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_PALM_BRANCH, "regions_unexplored", "", "stick_from_palm_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_PINE_PLANKS, TagManager.Items.RU_PINE_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_PINE_BRANCH, "regions_unexplored", "", "stick_from_pine_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_PINK_BIOSHROOM_PLANKS, TagManager.Items.RU_PINK_BIOSHROOM_LOGS, "has_logs");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_REDWOOD_PLANKS, TagManager.Items.RU_REDWOOD_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_REDWOOD_BRANCH, "regions_unexplored", "", "stick_from_redwood_branch");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_SILVER_BIRCH_BRANCH, "regions_unexplored", "", "stick_from_silver_birch_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_SOCOTRA_PLANKS, TagManager.Items.RU_SOCOTRA_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_SOCOTRA_BRANCH, "regions_unexplored", "", "stick_from_socotra_branch");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_SPRUCE_BRANCH, "regions_unexplored", "", "stick_from_spruce_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_WILLOW_PLANKS, TagManager.Items.RU_WILLOW_LOGS, "has_logs");
        ModRecipesProvider.sticksFromBranchRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_WILLOW_BRANCH, "regions_unexplored", "", "stick_from_willow_branch");
        ModRecipesProvider.plankRecipeBuilder(wrapped, (ItemLike)SurvivalistEssentialsIntegration.RU_YELLOW_BIOSHROOM_PLANKS, TagManager.Items.RU_YELLOW_BIOSHROOM_LOGS, "has_logs");
    }

    private static void sticksFromBranchRecipeBuilder(RecipeOutput recipeOutput, ItemLike item, String modid, String folder, String name) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK, (int)2).requires(item).requires((ItemLike)SurvivalistEssentialsItems.CRUDE_SAW).group("sticks").unlockedBy("has_branch", ModRecipesProvider.has((ItemLike)item)).save(recipeOutput, SurvivalistEssentials.loc(modid, folder + name));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK, (int)4).requires(item).requires(TagManager.Items.ADVANCED_SAW_TOOLS).group("sticks").unlockedBy("has_branch", ModRecipesProvider.has((ItemLike)item)).save(recipeOutput, SurvivalistEssentials.prefix(modid + "_" + name));
    }

    private static void plankRecipeBuilder(RecipeOutput recipeOutput, ItemLike item, TagKey<Item> itemTag, String label) {
        ShapelessRecipeBuilder plankOverrideRecipe = ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (int)2).requires(itemTag).requires((ItemLike)SurvivalistEssentialsItems.CRUDE_SAW).group("planks").unlockedBy(label, ModRecipesProvider.has(itemTag));
        ResourceLocation itemLoc = BuiltInRegistries.ITEM.getKey((Object)item.asItem());
        String name = itemLoc.getPath();
        String modid = itemLoc.getNamespace();
        if (modid.contains("tconstruct")) {
            plankOverrideRecipe.save(recipeOutput, SurvivalistEssentials.loc("tconstruct", "world/wood/" + name.split("_")[0] + "/planks"));
        } else if (modid.contains("quark")) {
            plankOverrideRecipe.save(recipeOutput, SurvivalistEssentials.loc("quark", "world/crafting/woodsets/" + name.split("_")[0] + "/planks"));
        } else if (modid.contains("malum")) {
            plankOverrideRecipe.save(recipeOutput, SurvivalistEssentials.loc("malum", name));
        } else if (modid.contains("iceandfire")) {
            plankOverrideRecipe.save(recipeOutput, SurvivalistEssentials.loc("iceandfire", "dread_wood_planks"));
        } else if (itemTag.equals(TagManager.Items.BYG_PALO_VERDE_LOGS)) {
            plankOverrideRecipe.save(recipeOutput, SurvivalistEssentials.loc("biomeswevegone", "birch_planks_from_palo_verde_logs"));
            modid = "biomeswevegone";
        } else {
            plankOverrideRecipe.save(recipeOutput);
        }
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (int)4).requires(itemTag).requires(TagManager.Items.ADVANCED_SAW_TOOLS).group("planks").unlockedBy(label, ModRecipesProvider.has(TagManager.Items.ADVANCED_SAW_TOOLS)).save(recipeOutput, SurvivalistEssentials.prefix(modid + "_" + name));
    }

    private static void itemPlankRecipeBuilder(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input, String label, String path, String name, String modid) {
        ShapelessRecipeBuilder plankOverrideRecipe = ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)2).requires(input).requires((ItemLike)SurvivalistEssentialsItems.CRUDE_SAW).group("planks").unlockedBy(label, ModRecipesProvider.has(input));
        plankOverrideRecipe.save(recipeOutput, SurvivalistEssentials.loc(modid, path + name));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)4).requires(input).requires(TagManager.Items.ADVANCED_SAW_TOOLS).group("planks").unlockedBy(label, ModRecipesProvider.has(TagManager.Items.ADVANCED_SAW_TOOLS)).save(recipeOutput, SurvivalistEssentials.prefix(modid + "_" + name));
    }

    private static void bambooRecipeBuilder(RecipeOutput recipeOutput, ItemLike item, TagKey<Item> itemTag, String label) {
        ShapelessRecipeBuilder plankOverrideRecipe = ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (int)1).requires(itemTag).requires((ItemLike)SurvivalistEssentialsItems.CRUDE_SAW).group("planks").unlockedBy(label, ModRecipesProvider.has(itemTag));
        ResourceLocation itemLoc = BuiltInRegistries.ITEM.getKey((Object)item.asItem());
        String name = itemLoc.getPath();
        String modid = itemLoc.getNamespace();
        plankOverrideRecipe.save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (int)2).requires(itemTag).requires(TagManager.Items.ADVANCED_SAW_TOOLS).group("planks").unlockedBy(label, ModRecipesProvider.has(TagManager.Items.ADVANCED_SAW_TOOLS)).save(recipeOutput, SurvivalistEssentials.prefix(modid + "_" + name));
    }
}

