/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.event;

import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import survivalistessentials.config.ConfigHandler;
import survivalistessentials.sound.Sounds;
import survivalistessentials.util.ItemUse;

public class AttackEventHandler {
    @SubscribeEvent
    public static void onHurt(LivingDamageEvent.Pre event) {
        Player player;
        Entity entity = event.getSource().getDirectEntity();
        if (entity instanceof Player && !(player = (Player)entity).isCreative()) {
            ItemStack handStack = player.getMainHandItem();
            Level level = player.level();
            boolean checkAllowed = event.getSource().getMsgId().contains("player");
            boolean bypassArmor = event.getSource().is(DamageTypeTags.BYPASSES_ARMOR);
            if (bypassArmor) {
                checkAllowed = false;
            }
            if (checkAllowed && (handStack.is(Items.AIR) || !ItemUse.isAllowedTool(handStack))) {
                if (!level.isClientSide && ConfigHandler.Client.enableFailSound() && ConfigHandler.Common.genericDamage() == 0.0f) {
                    level.playSound(null, player.getOnPos(), Sounds.SWORD_FAIL, SoundSource.PLAYERS, 0.4f, 1.0f);
                }
                event.setNewDamage(ConfigHandler.Common.genericDamage());
            }
        }
    }
}

