/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import survivalistessentials.common.HarvestBlock;
import survivalistessentials.common.TagManager;
import survivalistessentials.config.ConfigHandler;
import survivalistessentials.mixin.AbstractBlockStateAccessor;
import survivalistessentials.sound.Sounds;
import survivalistessentials.util.CarryOnHelper;
import survivalistessentials.util.Chat;
import survivalistessentials.util.ItemUse;
import survivalistessentials.util.ToolType;
import technology.roughness.whitenoise.util.ResourceLocationHelper;

public class HarvestEventHandler {
    private static final Map<Player, BlockPos> harvestAttempts = new HashMap<Player, BlockPos>();
    private static Block spellHitBlock = null;
    private static int breakBlockStep = 0;

    @SubscribeEvent
    public static void tagUpdate(TagsUpdatedEvent event) {
        HarvestBlock.setup();
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        ItemStack handStack;
        boolean alwaysBreakable;
        LevelAccessor level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Player player = event.getPlayer();
        if (player instanceof FakePlayer) {
            return;
        }
        ToolType expectedToolType = HarvestBlock.BLOCK_TOOL_TYPES.getOrDefault(state.getBlock(), ToolType.NONE);
        boolean cancel = false;
        boolean bl = alwaysBreakable = state.is(TagManager.Blocks.ALWAYS_BREAKABLE) || ItemUse.isAlwaysBreakable(state);
        if (ModList.get().isLoaded("carryon")) {
            handStack = player.getMainHandItem();
            ItemStack offhandStack = player.getOffhandItem();
            if (handStack.isEmpty() && offhandStack.isEmpty() && CarryOnHelper.isKeyPressed(player)) {
                alwaysBreakable = true;
            }
        }
        if (ModList.get().isLoaded("create")) {
            handStack = player.getMainHandItem();
            boolean bl2 = alwaysBreakable = ResourceLocationHelper.getModId((ItemStack)handStack).equals("create") && ResourceLocationHelper.getModId((Block)state.getBlock()).equals("create");
        }
        if (!alwaysBreakable && !player.isCreative() && expectedToolType != ToolType.NONE) {
            handStack = HarvestEventHandler.getHandStack(player, state);
            boolean correctTool = ItemUse.isCorrectTool(state, player, handStack);
            boolean isAllowedTool = ItemUse.isAllowedTool(handStack);
            String toolClass = ItemUse.getToolClass(handStack);
            if (toolClass.equals("unknown") || isAllowedTool && !correctTool) {
                cancel = true;
                if (harvestAttempts.containsKey(player) || harvestAttempts.get(player) == null || !harvestAttempts.get(player).equals((Object)pos)) {
                    harvestAttempts.put(player, pos);
                    Chat.sendMessage(player, "message.survivalistessentials.wrong_tool", expectedToolType.toString().toLowerCase(), false);
                } else {
                    Chat.sendMessage(player, "message.survivalistessentials.warning");
                    Chat.sendMessage(player, "message.survivalistessentials.wrong_tool2", expectedToolType.toString().toLowerCase(), true);
                    player.hurt(player.damageSources().generic(), 0.1f);
                }
                if (!toolClass.equals("unknown") && !player.level().isClientSide && ConfigHandler.Client.enableFailSound()) {
                    level.playSound(null, player.getOnPos(), Sounds.TOOL_FAIL, SoundSource.PLAYERS, 0.6f, 1.0f);
                }
            } else if (spellHitBlock != null) {
                if (breakBlockStep == 1) {
                    breakBlockStep = -1;
                    spellHitBlock = null;
                }
                ++breakBlockStep;
            }
        }
        event.setCanceled(cancel);
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Entity projectile = event.getEntity();
        if (projectile.toString().toLowerCase().contains("spell")) {
            Vec3 position = projectile.position();
            Vec3 nextPosition = position.add(projectile.getDeltaMovement());
            BlockHitResult hitresult = projectile.level().clip(new ClipContext(position, nextPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, projectile));
            BlockPos pos = hitresult.getBlockPos();
            spellHitBlock = projectile.level().getBlockState(new BlockPos((Vec3i)pos)).getBlock();
        }
    }

    @SubscribeEvent
    public static void harvestCheckEvent(PlayerEvent.HarvestCheck event) {
        Player player = event.getEntity();
        BlockState state = event.getTargetBlock();
        if (!(player instanceof FakePlayer) && !player.isCreative()) {
            boolean canHarvest;
            ItemStack handStack = HarvestEventHandler.getHandStack(player, state);
            boolean correctTool = ItemUse.isCorrectTool(state, player, handStack);
            ToolType expectedToolType = HarvestBlock.BLOCK_TOOL_TYPES.getOrDefault(state.getBlock(), ToolType.NONE);
            boolean bl = canHarvest = event.canHarvest() || ItemUse.alwaysDrops(state) || expectedToolType == ToolType.NONE;
            if (!canHarvest) {
                boolean isOre;
                boolean bl2 = isOre = state.is(Tags.Blocks.ORES) || state.is(Tags.Blocks.OBSIDIANS);
                canHarvest = isOre && expectedToolType == ToolType.PICKAXE ? correctTool && handStack.isCorrectToolForDrops(state) : correctTool || handStack.isCorrectToolForDrops(state);
            }
            event.setCanHarvest(canHarvest);
        }
    }

    @SubscribeEvent
    public static void slowMining(PlayerEvent.BreakSpeed event) {
        float destroySpeed;
        Player player = event.getEntity();
        Optional pos = event.getPosition();
        if (player instanceof FakePlayer) {
            return;
        }
        if (pos.isEmpty()) {
            return;
        }
        Level level = player.level();
        BlockState state = level.getBlockState((BlockPos)pos.get());
        float slowdown = destroySpeed = ((AbstractBlockStateAccessor)state).getDestroySpeed();
        ToolType expectedToolType = HarvestBlock.BLOCK_TOOL_TYPES.getOrDefault(state.getBlock(), ToolType.NONE);
        if (!player.isCreative() && expectedToolType != ToolType.NONE) {
            ItemStack handStack = HarvestEventHandler.getHandStack(player, state);
            boolean correctTool = ItemUse.isCorrectTool(state, player, handStack);
            boolean alwaysBreakable = state.is(TagManager.Blocks.ALWAYS_BREAKABLE);
            boolean isAllowedTool = ItemUse.isAllowedTool(handStack);
            if (!alwaysBreakable) {
                if (!isAllowedTool) {
                    slowdown = ConfigHandler.Common.slowDownSpeed() / 2.0f;
                } else if (!correctTool) {
                    slowdown = ConfigHandler.Common.slowDownSpeed();
                }
            } else if (!correctTool) {
                slowdown = ConfigHandler.Common.slowDownSpeed();
            } else if (!isAllowedTool) {
                slowdown = ConfigHandler.Common.slowDownSpeed() / 2.0f;
            }
        }
        if (slowdown != destroySpeed) {
            event.setNewSpeed(slowdown);
        }
    }

    private static ItemStack getHandStack(Player player, BlockState blockState) {
        String toolClass;
        ItemStack stack = player.getMainHandItem();
        if (spellHitBlock != null && spellHitBlock.equals(blockState.getBlock()) && !Objects.equals(toolClass = ItemUse.getToolClass(stack), "spell") && !Objects.equals(toolClass, "cad")) {
            stack = player.getOffhandItem();
        }
        return stack;
    }
}

