/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.event;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import survivalistessentials.SurvivalistEssentials;
import survivalistessentials.config.ConfigHandler;

public class PlayerEventHandler {
    private static final ResourceLocation STARTING_HEALTH_PENALTY = SurvivalistEssentials.prefix("starting_health_penalty");

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEventHandler.applyHealthPenalty(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        PlayerEventHandler.applyHealthPenalty(player);
        if (!player.isCreative() && !player.isSpectator() && !player.level().isClientSide && event.isWasDeath()) {
            ServerPlayer sp = (ServerPlayer)player;
            if (ConfigHandler.Common.enableHungerPenalty()) {
                sp.getFoodData().setFoodLevel(ConfigHandler.Common.hunger());
                sp.getFoodData().setSaturation((float)ConfigHandler.Common.saturation());
            }
            if (ConfigHandler.Common.enableHealthPenalty()) {
                sp.setHealth(ConfigHandler.Common.health());
            }
        }
    }

    private static void applyHealthPenalty(Player player) {
        float maxHealth;
        float newHealth;
        if (player != null && ConfigHandler.Common.startingHealthPenalty() < 0.0f && (newHealth = (maxHealth = player.getMaxHealth()) + ConfigHandler.Common.startingHealthPenalty()) >= 1.0f) {
            AttributeInstance attributeInstance = PlayerEventHandler.maxHealthAttribute(player);
            AttributeModifier modifier = new AttributeModifier(STARTING_HEALTH_PENALTY, (double)ConfigHandler.Common.startingHealthPenalty(), AttributeModifier.Operation.ADD_VALUE);
            attributeInstance.removeModifier(STARTING_HEALTH_PENALTY);
            attributeInstance.addPermanentModifier(modifier);
        }
    }

    private static AttributeInstance maxHealthAttribute(Player player) {
        return Objects.requireNonNull(player.getAttribute(Attributes.MAX_HEALTH));
    }
}

