/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.world.feature;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.neoforged.neoforge.common.util.Lazy;
import survivalistessentials.common.TagManager;
import survivalistessentials.world.SurvivalistEssentialsWorld;

public class LooseRocks
extends Feature<NoneFeatureConfiguration> {
    private static final Lazy<Map<Block, Block>> LOOSE_ROCK_SUPPLIER = Lazy.of(() -> new ImmutableMap.Builder().put((Object)Blocks.STONE, (Object)SurvivalistEssentialsWorld.STONE_LOOSE_ROCK).put((Object)Blocks.ANDESITE, (Object)SurvivalistEssentialsWorld.ANDESITE_LOOSE_ROCK).put((Object)Blocks.DIORITE, (Object)SurvivalistEssentialsWorld.DIORITE_LOOSE_ROCK).put((Object)Blocks.GRANITE, (Object)SurvivalistEssentialsWorld.GRANITE_LOOSE_ROCK).put((Object)Blocks.SANDSTONE, (Object)SurvivalistEssentialsWorld.SANDSTONE_LOOSE_ROCK).put((Object)Blocks.RED_SANDSTONE, (Object)SurvivalistEssentialsWorld.RED_SANDSTONE_LOOSE_ROCK).put((Object)Blocks.TERRACOTTA, (Object)SurvivalistEssentialsWorld.RED_SANDSTONE_LOOSE_ROCK).put((Object)Blocks.SAND, (Object)SurvivalistEssentialsWorld.SANDSTONE_LOOSE_ROCK).put((Object)Blocks.RED_SAND, (Object)SurvivalistEssentialsWorld.RED_SANDSTONE_LOOSE_ROCK).build());

    public LooseRocks() {
        super(NoneFeatureConfiguration.CODEC);
    }

    @ParametersAreNonnullByDefault
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        BlockState stateAt = level.getBlockState(pos);
        BlockState stateDown = level.getBlockState(pos.below());
        if (stateAt.isAir() && stateDown.is(TagManager.Blocks.LOOSE_ROCK_PLACEABLE_ON)) {
            for (int y = 1; y <= 8; ++y) {
                BlockPos stonePos = pos.below(y);
                BlockState stoneState = level.getBlockState(stonePos);
                if (!((Map)LOOSE_ROCK_SUPPLIER.get()).containsKey(stoneState.getBlock())) continue;
                Block looseRockBlock = (Block)((Map)LOOSE_ROCK_SUPPLIER.get()).get(stoneState.getBlock());
                level.setBlock(pos, looseRockBlock.defaultBlockState(), 3);
                break;
            }
        }
        return true;
    }
}

