/*
 * Decompiled with CFR 0.152.
 */
package survivalistessentials.event;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import survivalistessentials.util.ItemUse;

public class TooltipEventHandler {
    public static void onItemToolTip(ItemStack stack, List<Component> tooltipComponent) {
        String tooltip = "";
        if (!ItemUse.getToolClass(stack).equals("unknown") && !ItemUse.isAllowedTool(stack)) {
            String type = ItemUse.getToolClass(stack);
            tooltip = "tooltip.survivalistessentials.uselessTool2";
            if (!type.equals("unknown")) {
                switch (type) {
                    case "bow": 
                    case "crossbow": {
                        tooltip = "tooltip.survivalistessentials.uselessBow1";
                        break;
                    }
                    case "hoe": {
                        tooltip = "tooltip.survivalistessentials.uselessHoe1";
                        break;
                    }
                    case "pickaxe": {
                        tooltip = "tooltip.survivalistessentials.uselessTool1";
                        break;
                    }
                    case "axe": 
                    case "darkstar": 
                    case "spear": 
                    case "sword": 
                    case "weapon": {
                        tooltip = "tooltip.survivalistessentials.uselessWeapon1";
                        break;
                    }
                }
            }
        } else if (ItemUse.isArmor(stack) && !ItemUse.isAllowedArmor(stack)) {
            tooltip = "tooltip.survivalistessentials.uselessArmor1";
        }
        if (!tooltip.isEmpty()) {
            MutableComponent message = Component.translatable((String)tooltip).withStyle(ChatFormatting.DARK_RED);
            tooltipComponent.add((Component)message);
        }
    }
}

