/*
 * Decompiled with CFR 0.152.
 */
package pl.pasieniec.PasiVanish.Extra;

import java.io.File;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class PlaceholderHandler {
    private final JavaPlugin plugin;
    private FileConfiguration placeholders;

    public PlaceholderHandler(JavaPlugin plugin) {
        this.plugin = plugin;
        this.createDefaultPlaceholderFile();
        this.loadPlaceholders();
    }

    private void loadPlaceholders() {
        File file = new File(this.plugin.getDataFolder(), "placeholders.yml");
        this.placeholders = YamlConfiguration.loadConfiguration((File)file);
    }

    public void reload() {
        this.loadPlaceholders();
    }

    public String getPlaceholder(String path, String defaultValue) {
        String raw;
        String string = raw = this.placeholders.contains(path) ? this.placeholders.getString(path) : defaultValue;
        if (raw == null) {
            return defaultValue;
        }
        String legacyFormatted = ChatColor.translateAlternateColorCodes((char)'&', (String)raw);
        if (legacyFormatted.contains("&#")) {
            String miniFormatted = legacyFormatted.replaceAll("&#([A-Fa-f0-9]{6})", "<#$1>");
            Component component = MiniMessage.miniMessage().deserialize((Object)miniFormatted);
            return LegacyComponentSerializer.legacySection().serialize(component);
        }
        return legacyFormatted;
    }

    public void createDefaultPlaceholderFile() {
        File file = new File(this.plugin.getDataFolder(), "placeholders.yml");
        if (!file.exists()) {
            this.plugin.saveResource("placeholders.yml", false);
            this.plugin.getLogger().info("Zapisano domy\u015blny plik placeholders.yml");
        }
    }
}

