/*
 * Decompiled with CFR 0.152.
 */
package pl.pasieniec.PasiVanish;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import pl.pasieniec.PasiVanish.PasiVanish;

public class SilentOpenChest
implements Listener {
    private final PasiVanish plugin;
    private final Map<Player, GameMode> savedGameModes = new HashMap<Player, GameMode>();
    private final Map<Player, Boolean> previousFlyState = new HashMap<Player, Boolean>();
    private final Map<Player, Boolean> previousCanFlyState = new HashMap<Player, Boolean>();
    private final Map<Player, Boolean> shulkerPlayers = new HashMap<Player, Boolean>();

    public SilentOpenChest(PasiVanish plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.isPlayerVanished(player) || !this.plugin.isSilentChestEnabled()) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Block block = event.getClickedBlock();
            if (block == null) {
                return;
            }
            if (player.isSneaking() && (this.isPlaceable(player.getInventory().getItemInMainHand()) || this.isPlaceable(player.getInventory().getItemInOffHand()))) {
                return;
            }
            BlockState state = block.getState();
            Inventory inventory = null;
            boolean isShulkerBox = false;
            if (state instanceof Chest) {
                inventory = ((Chest)state).getInventory();
            } else if (state instanceof Barrel) {
                inventory = ((Barrel)state).getInventory();
            } else if (state instanceof ShulkerBox) {
                inventory = ((ShulkerBox)state).getInventory();
                isShulkerBox = true;
            } else if (block.getType() == Material.ENDER_CHEST) {
                inventory = player.getEnderChest();
            }
            if (inventory != null) {
                event.setCancelled(true);
                this.savedGameModes.put(player, player.getGameMode());
                this.previousCanFlyState.put(player, player.getAllowFlight());
                this.previousFlyState.put(player, player.isFlying());
                if (isShulkerBox) {
                    this.shulkerPlayers.put(player, true);
                }
                player.setGameMode(GameMode.SPECTATOR);
                boolean finalIsShulkerBox = isShulkerBox;
                Inventory finalInventory = inventory;
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    player.openInventory(finalInventory);
                    this.restoreGameMode(player);
                }, 2L);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (this.shulkerPlayers.containsKey(player)) {
            this.shulkerPlayers.remove(player);
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.0f, 0.0f);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.restoreGameMode(player);
    }

    private void restoreGameMode(Player player) {
        if (this.savedGameModes.containsKey(player)) {
            GameMode oldMode = this.savedGameModes.remove(player);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                player.setGameMode(oldMode);
                if (!this.previousCanFlyState.getOrDefault(player, false).booleanValue()) {
                    player.setAllowFlight(false);
                    player.setFlying(false);
                } else {
                    player.setAllowFlight(true);
                    player.setFlying(this.previousFlyState.getOrDefault(player, false).booleanValue());
                }
                this.previousCanFlyState.remove(player);
                this.previousFlyState.remove(player);
            }, 1L);
        }
    }

    private boolean isPlaceable(ItemStack item) {
        if (item == null) {
            return false;
        }
        return item.getType().isBlock();
    }
}

