/*
 * Decompiled with CFR 0.152.
 */
package pl.pasieniec.PasiVanish.listeners;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import pl.pasieniec.PasiVanish.PasiVanish;

public class ChatListener
implements Listener {
    private final PasiVanish plugin;
    private final Map<UUID, String> pending = new HashMap<UUID, String>();
    private final Set<UUID> justConfirmed = new HashSet<UUID>();
    private final Set<UUID> sentConfirmation = new HashSet<UUID>();

    public ChatListener(PasiVanish plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onLegacyChat(AsyncPlayerChatEvent e) {
        if (!this.plugin.getConfig().getBoolean("Options.2StepChat", false)) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("new-paper-chat-event", false)) {
            return;
        }
        Player p = e.getPlayer();
        if (!this.plugin.isPlayerVanished(p)) {
            return;
        }
        if (this.justConfirmed.remove(p.getUniqueId())) {
            return;
        }
        e.setCancelled(true);
        UUID uuid = p.getUniqueId();
        if (!this.pending.containsKey(uuid)) {
            this.pending.put(uuid, e.getMessage());
        }
        if (this.sentConfirmation.add(uuid)) {
            this.sendConfirmation(p);
        }
    }

    @EventHandler
    public void onPaperChat(AsyncChatEvent e) {
        if (!this.plugin.getConfig().getBoolean("Options.2StepChat", false)) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("new-paper-chat-event", false)) {
            return;
        }
        Player p = e.getPlayer();
        if (!this.plugin.isPlayerVanished(p)) {
            return;
        }
        if (this.justConfirmed.remove(p.getUniqueId())) {
            return;
        }
        e.setCancelled(true);
        UUID uuid = p.getUniqueId();
        String message = PlainTextComponentSerializer.plainText().serialize(e.message());
        if (!this.pending.containsKey(uuid)) {
            this.pending.put(uuid, message);
        }
        if (this.sentConfirmation.add(uuid)) {
            this.sendConfirmation(p);
        }
    }

    private void sendConfirmation(Player p) {
        p.sendMessage("\u00a77Wys\u0142a\u0142e\u015b wiadomo\u015b\u0107 b\u0119d\u0105c na \u00a7b\u00a7nVanish");
        p.sendMessage("\u00a7eCzy napewno chcesz to zrobi\u0107?");
        p.sendMessage("");
        TextComponent no = new TextComponent("\u00a7cNIE");
        no.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pv 2stepchat no"));
        no.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("\u00a7cKliknij, aby anulowa\u0107")}));
        TextComponent yes = new TextComponent("\u00a7a           TAK");
        yes.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pv 2stepchat yes"));
        yes.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("\u00a7aKliknij, aby wys\u0142a\u0107 wiadomo\u015b\u0107")}));
        TextComponent line = new TextComponent();
        line.addExtra((BaseComponent)no);
        line.addExtra((BaseComponent)yes);
        p.spigot().sendMessage((BaseComponent)line);
    }

    public boolean handleResponse(final Player p, String answer) {
        UUID uuid = p.getUniqueId();
        final String msg = this.pending.remove(uuid);
        this.sentConfirmation.remove(uuid);
        if (msg == null) {
            return false;
        }
        if (answer.equalsIgnoreCase("yes")) {
            this.justConfirmed.add(uuid);
            new BukkitRunnable(this){
                final /* synthetic */ ChatListener this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    String format = this.this$0.plugin.getConfig().getString("chat-format", "<player>: <message>");
                    String temp = format.replace("<player>", p.getName()).replace("<message>", msg);
                    if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                        temp = PlaceholderAPI.setPlaceholders((Player)p, (String)temp);
                    }
                    temp = this.this$0.convertHexColorsToMiniMessage(temp);
                    Component comp = MiniMessage.miniMessage().deserialize((Object)temp);
                    String json = (String)GsonComponentSerializer.gson().serialize(comp);
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("minecraft:tellraw @a " + json));
                }
            }.runTask((Plugin)JavaPlugin.getProvidingPlugin(this.getClass()));
            p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        } else {
            p.sendMessage(this.plugin.getMessage("Messages_prefix", "&aPasiVanish \u00bb ") + this.plugin.getMessage("Messages.help_reload", "&cWys\u0142anie anulowane."));
            p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
        }
        return true;
    }

    private String convertHexColorsToMiniMessage(String input) {
        Map colorMap = Map.ofEntries(Map.entry(Character.valueOf('0'), "<black>"), Map.entry(Character.valueOf('1'), "<dark_blue>"), Map.entry(Character.valueOf('2'), "<dark_green>"), Map.entry(Character.valueOf('3'), "<dark_aqua>"), Map.entry(Character.valueOf('4'), "<dark_red>"), Map.entry(Character.valueOf('5'), "<dark_purple>"), Map.entry(Character.valueOf('6'), "<gold>"), Map.entry(Character.valueOf('7'), "<gray>"), Map.entry(Character.valueOf('8'), "<dark_gray>"), Map.entry(Character.valueOf('9'), "<blue>"), Map.entry(Character.valueOf('a'), "<green>"), Map.entry(Character.valueOf('b'), "<aqua>"), Map.entry(Character.valueOf('c'), "<red>"), Map.entry(Character.valueOf('d'), "<light_purple>"), Map.entry(Character.valueOf('e'), "<yellow>"), Map.entry(Character.valueOf('f'), "<white>"), Map.entry(Character.valueOf('l'), "<bold>"), Map.entry(Character.valueOf('n'), "<underlined>"), Map.entry(Character.valueOf('o'), "<italic>"), Map.entry(Character.valueOf('m'), "<strikethrough>"), Map.entry(Character.valueOf('r'), "<reset>"));
        String hexHandled = input.replaceAll("(?i)&#([a-f0-9]{6})", "<#$1>");
        StringBuilder result = new StringBuilder();
        char[] chars = hexHandled.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char code;
            String tag;
            if ((chars[i] == '&' || chars[i] == '\u00a7') && i + 1 < chars.length && (tag = (String)colorMap.get(Character.valueOf(code = Character.toLowerCase(chars[i + 1])))) != null) {
                result.append(tag);
                ++i;
                continue;
            }
            result.append(chars[i]);
        }
        return result.toString();
    }
}

