/*
 * Decompiled with CFR 0.152.
 */
package pl.pasieniec.PasiVanish.options;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import pl.pasieniec.PasiVanish.PasiVanish;

public class RestoreVanishListener
implements Listener {
    private final PasiVanish plugin;
    private final Set<UUID> vanishedOnLeave = new HashSet<UUID>();

    public RestoreVanishListener(PasiVanish plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!PasiVanish.RestoreVanishEnabled) {
            return;
        }
        if (this.plugin.isPlayerVanished(player)) {
            this.vanishedOnLeave.add(player.getUniqueId());
            event.setQuitMessage(null);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!PasiVanish.RestoreVanishEnabled) {
            return;
        }
        UUID uuid = player.getUniqueId();
        if (this.vanishedOnLeave.remove(uuid)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.enableVanish(player), 1L);
            event.setJoinMessage(null);
        }
    }
}

