/*
 * Decompiled with CFR 0.152.
 */
package pl.pasieniec.PasiVanish.lang;

import java.io.File;
import java.io.InputStream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class LangManager {
    private final JavaPlugin plugin;
    private FileConfiguration messages;

    public LangManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    private void loadMessages() {
        String langCode = this.plugin.getConfig().getString("lang", "en");
        File langFile = new File(this.plugin.getDataFolder(), "langs/messages-" + langCode + ".yml");
        if (!langFile.exists()) {
            this.plugin.getLogger().warning("Nie znaleziono pliku: " + langFile.getName() + ". Pr\u00f3ba stworzenia domy\u015blnego.");
            langFile.getParentFile().mkdirs();
            InputStream defaultLang = this.plugin.getResource("langs/messages-" + langCode + ".yml");
            if (defaultLang != null) {
                this.plugin.saveResource("langs/messages-" + langCode + ".yml", false);
            } else {
                this.plugin.getLogger().warning("Brak domy\u015blnego t\u0142umaczenia w zasobach: messages-" + langCode + ".yml");
            }
        }
        this.messages = YamlConfiguration.loadConfiguration((File)langFile);
    }

    public String get(String path) {
        String raw = this.messages.getString(path, "!" + path + "!");
        String legacyFormatted = ChatColor.translateAlternateColorCodes((char)'&', (String)raw);
        if (legacyFormatted.contains("&#")) {
            String miniFormatted = this.convertHexColorsToMiniMessage(legacyFormatted);
            Component component = MiniMessage.miniMessage().deserialize((Object)miniFormatted);
            return LegacyComponentSerializer.legacySection().serialize(component);
        }
        return legacyFormatted;
    }

    private String convertHexColorsToMiniMessage(String input) {
        return input.replaceAll("&#([A-Fa-f0-9]{6})", "<#$1>");
    }

    public void reload() {
        this.loadMessages();
    }

    private void setupLangFolder() {
        String[] defaultLangs;
        File langsDir = new File(this.plugin.getDataFolder(), "langs");
        if (!langsDir.exists() && langsDir.mkdirs()) {
            this.plugin.getLogger().info("Utworzono folder langs/");
        }
        for (String fileName : defaultLangs = new String[]{"messages-en.yml", "messages-pl.yml", "messages-it.yml", "messages-ru.yml"}) {
            File file = new File(langsDir, fileName);
            if (file.exists()) continue;
            this.plugin.saveResource("langs/" + fileName, false);
            this.plugin.getLogger().info("Zapisano domy\u015blny plik j\u0119zykowy: " + fileName);
        }
    }
}

