/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.infinitelyregeneratingblock.procedures;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import net.mcreator.infinitelyregeneratingblock.init.InfinitelyRegeneratingBlockModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class InfinitelyRegeneratingBlockBlockDestroyedByPlayerProcedure {
    private static List<Item> excludedItems;
    private static final Map<String, List<String>> excludedItemsConfig;

    public static void execute(Level world, double x, double y, double z) {
        BlockPos blockPos = new BlockPos((int)Math.round(x), (int)Math.round(y), (int)Math.round(z));
        world.setBlockAndUpdate(blockPos, ((Block)InfinitelyRegeneratingBlockModBlocks.INFINITELY_REGENERATING_BLOCK.get()).defaultBlockState());
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            InfinitelyRegeneratingBlockBlockDestroyedByPlayerProcedure.spawnRandomItem(serverLevel, x, y, z);
        }
    }

    private static void spawnRandomItem(ServerLevel world, double x, double y, double z) {
        InfinitelyRegeneratingBlockBlockDestroyedByPlayerProcedure.loadExcludedItems(world);
        List excludedModIds = excludedItemsConfig.getOrDefault("excludedMods", new ArrayList());
        List items = BuiltInRegistries.ITEM.stream().filter(item -> {
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey(item);
            if (itemId == null) {
                return false;
            }
            return !excludedModIds.contains(itemId.getNamespace());
        }).filter(item -> !excludedItems.contains(item)).collect(Collectors.toList());
        if (items.isEmpty()) {
            return;
        }
        ItemStack randomItem = new ItemStack((ItemLike)items.get(new Random().nextInt(items.size())));
        ItemEntity itemEntity = new ItemEntity((Level)world, x, y + 1.0, z, randomItem);
        itemEntity.setDeltaMovement((double)((new Random().nextFloat() - 0.5f) * 0.7f), (double)((new Random().nextFloat() - 0.5f) * 0.7f), (double)((new Random().nextFloat() - 0.5f) * 0.7f));
        world.addFreshEntity((Entity)itemEntity);
    }

    private static void loadExcludedItems(ServerLevel world) {
        if (excludedItems == null) {
            excludedItems = new ArrayList<Item>();
            Gson gson = new Gson();
            try {
                Type type;
                Map<String, List<String>> configMap;
                File configFile = new File("config/irb/excluded_items.json");
                if (!configFile.exists()) {
                    InfinitelyRegeneratingBlockBlockDestroyedByPlayerProcedure.initializeDefaultExcludedItemsConfig();
                    InfinitelyRegeneratingBlockBlockDestroyedByPlayerProcedure.saveExcludedItemsConfig(excludedItemsConfig);
                }
                if ((configMap = (Map<String, List<String>>)gson.fromJson((Reader)new FileReader(configFile), type = new TypeToken<Map<String, List<String>>>(){}.getType())) == null) {
                    InfinitelyRegeneratingBlockBlockDestroyedByPlayerProcedure.initializeDefaultExcludedItemsConfig();
                    InfinitelyRegeneratingBlockBlockDestroyedByPlayerProcedure.saveExcludedItemsConfig(excludedItemsConfig);
                    configMap = excludedItemsConfig;
                }
                excludedItemsConfig.clear();
                excludedItemsConfig.putAll(configMap);
                List excludedItemNames = excludedItemsConfig.getOrDefault("excludedItems", new ArrayList());
                excludedItems = excludedItemNames.stream().map(s -> {
                    String[] parts = s.split(":");
                    return parts.length == 2 ? ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]) : null;
                }).filter(Objects::nonNull).filter(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).containsKey(arg_0)).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).collect(Collectors.toList());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void initializeDefaultExcludedItemsConfig() {
        List<String> defaultExcludedItems = List.of("minecraft:command_block", "minecraft:debug_stick", "minecraft:repeating_command_block", "minecraft:chain_command_block", "minecraft:light", "minecraft:structure_block", "minecraft:jigsaw", "minecraft:structure_void", "minecraft:barrier", "minecraft:command_block_minecart");
        excludedItemsConfig.put("excludedItems", new ArrayList<String>(defaultExcludedItems));
        excludedItemsConfig.put("excludedMods", new ArrayList<String>(List.of("example_mod_id")));
    }

    private static void saveExcludedItemsConfig(Map<String, List<String>> configData) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File configFile = new File("config/irb/excluded_items.json");
        try (FileWriter writer = new FileWriter(configFile);){
            gson.toJson(configData, (Appendable)writer);
            System.out.println("Config saved successfully: " + configFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("Failed to save config file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    static {
        excludedItemsConfig = new HashMap<String, List<String>>();
    }
}

