/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.infinitelyregeneratingblock.procedures;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.mcreator.infinitelyregeneratingblock.init.InfinitelyRegeneratingBlockModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class InfinitelyRegeneratingEntityBlockBlockDestroyedByPlayerProcedure {
    private static List<EntityType<?>> excludedEntities;
    private static List<String> excludedEntitiesConfig;

    public static void execute(Level world, double x, double y, double z) {
        BlockPos blockPos = new BlockPos((int)Math.round(x), (int)Math.round(y), (int)Math.round(z));
        world.setBlockAndUpdate(blockPos, ((Block)InfinitelyRegeneratingBlockModBlocks.INFINITELY_REGENERATING_ENTITY_BLOCK.get()).defaultBlockState());
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            InfinitelyRegeneratingEntityBlockBlockDestroyedByPlayerProcedure.spawnRandomEntity(serverLevel, x, y, z);
        }
    }

    private static void spawnRandomEntity(ServerLevel world, double x, double y, double z) {
        EntityType randomEntity;
        Entity entity;
        InfinitelyRegeneratingEntityBlockBlockDestroyedByPlayerProcedure.loadExcludedEntities();
        List entities = BuiltInRegistries.ENTITY_TYPE.stream().filter(entityType -> !excludedEntities.contains(entityType)).collect(Collectors.toList());
        if (!entities.isEmpty() && (entity = (randomEntity = (EntityType)entities.get(new Random().nextInt(entities.size()))).create((Level)world)) != null) {
            entity.moveTo(x, y + 1.0, z, new Random().nextFloat() * 360.0f, 0.0f);
            world.addFreshEntity(entity);
        }
    }

    private static void loadExcludedEntities() {
        if (excludedEntities == null) {
            excludedEntities = new ArrayList();
            Gson gson = new Gson();
            try {
                Type listType;
                File configFile = new File("config/irb/excluded_entities.json");
                if (!configFile.exists()) {
                    InfinitelyRegeneratingEntityBlockBlockDestroyedByPlayerProcedure.initializeDefaultExcludedEntitiesConfig();
                    InfinitelyRegeneratingEntityBlockBlockDestroyedByPlayerProcedure.saveExcludedEntitiesConfig();
                }
                if ((excludedEntitiesConfig = (List)gson.fromJson((Reader)new FileReader(configFile), listType = new TypeToken<List<String>>(){}.getType())) == null || excludedEntitiesConfig.isEmpty()) {
                    System.err.println("Config file is empty or invalid. Reinitializing with default excluded entities.");
                    InfinitelyRegeneratingEntityBlockBlockDestroyedByPlayerProcedure.initializeDefaultExcludedEntitiesConfig();
                    InfinitelyRegeneratingEntityBlockBlockDestroyedByPlayerProcedure.saveExcludedEntitiesConfig();
                }
                excludedEntities = excludedEntitiesConfig.stream().map(s -> {
                    String[] parts = s.split(":");
                    return parts.length == 2 ? ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]) : null;
                }).filter(id -> id != null && BuiltInRegistries.ENTITY_TYPE.containsKey(id)).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).get(arg_0)).collect(Collectors.toList());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void initializeDefaultExcludedEntitiesConfig() {
        excludedEntitiesConfig = new ArrayList<String>(List.of("minecraft:tnt", "minecraft:minecart", "minecraft:tnt_minecart", "minecraft:command_block_minecart", "minecraft:arrow", "minecraft:spectral_arrow", "minecraft:hopper_minecart", "minecraft:boat", "minecraft:chest_minecart", "minecraft:furnace_minecart", "minecraft:end_crystal", "minecraft:evoker_fangs", "minecraft:ender_pearl", "minecraft:chest_boat", "minecraft:experience_bottle", "minecraft:experience_orb", "minecraft:egg", "minecraft:dragon_fireball", "minecraft:block_display", "minecraft:armor_stand", "minecraft:area_effect_cloud", "minecraft:eye_of_ender", "minecraft:falling_block", "minecraft:fireball", "minecraft:firework_rocket", "minecraft:glow_item_frame", "minecraft:interaction", "minecraft:item", "minecraft:item_display", "minecraft:item_frame", "minecraft:leash_knot", "minecraft:lightning_bolt", "minecraft:llama_spit", "minecraft:marker", "minecraft:painting", "minecraft:potion", "minecraft:shulker_bullet", "minecraft:small_fireball", "minecraft:snowball", "minecraft:spawner_minecart", "minecraft:text_display", "minecraft:trident", "minecraft:wither_skull", "minecraft:breeze_wind_charge", "minecraft:ominous_item_spawner", "minecraft:wind_charge"));
    }

    private static void saveExcludedEntitiesConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File configFile = new File("config/irb/excluded_entities.json");
        try (FileWriter writer = new FileWriter(configFile);){
            gson.toJson(excludedEntitiesConfig, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        excludedEntitiesConfig = null;
    }
}

