/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstairs.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticstairs.block.custom.YAxisRotatedBlock;
import net.alminoris.aestheticstairs.util.helper.VoxelShapeHelper;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4970;

public class StairailBlock
extends YAxisRotatedBlock {
    private static final class_265 SHAPE = class_2248.method_9541((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)15.0, (double)2.0);
    private static final class_265 SHAPESIDE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0);
    private static final class_265 SHAPERC = class_2248.method_9541((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final class_265 SHAPELC = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0);
    private static final class_265 SHAPE_HEAD = class_2248.method_9541((double)6.5, (double)15.0, (double)-0.5, (double)9.5, (double)16.0, (double)2.5);
    private static final class_265 SHAPESIDE_HEAD = class_2248.method_9541((double)0.0, (double)15.0, (double)-0.5, (double)16.0, (double)16.0, (double)2.5);
    private static final class_265 SHAPELC_HEAD = class_2248.method_9541((double)-0.5, (double)15.0, (double)-0.5, (double)2.5, (double)16.0, (double)16.0);
    private static final class_265 SHAPERC_HEAD = class_2248.method_9541((double)13.5, (double)15.0, (double)-0.5, (double)16.5, (double)16.0, (double)16.0);
    private static final class_265 SMALL_SHAPE = class_2248.method_9541((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)12.0, (double)2.0);
    private static final class_265 SMALL_SHAPESIDE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)2.0);
    private static final class_265 SMALL_SHAPERC = class_2248.method_9541((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final class_265 SMALL_SHAPELC = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0);
    private static final class_265 SMALL_SHAPE_HEAD = class_2248.method_9541((double)6.5, (double)12.0, (double)-0.5, (double)9.5, (double)14.25, (double)2.5);
    private static final class_265 SMALL_SHAPESIDE_HEAD = class_2248.method_9541((double)0.0, (double)12.0, (double)-0.5, (double)16.0, (double)14.25, (double)2.5);
    private static final class_265 SMALL_SHAPELC_HEAD = class_2248.method_9541((double)-0.5, (double)12.0, (double)-0.5, (double)2.5, (double)14.25, (double)16.0);
    private static final class_265 SMALL_SHAPERC_HEAD = class_2248.method_9541((double)13.5, (double)12.0, (double)-0.5, (double)16.5, (double)14.25, (double)16.0);
    public static final class_2754<Variant> VARIANT = class_2754.method_11850((String)"variant", Variant.class);
    private final String BLOCK_NAME;

    public StairailBlock(class_4970.class_2251 settings, String blockName) {
        super(settings.method_22488());
        this.BLOCK_NAME = blockName;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(VARIANT, (Comparable)((Object)Variant.NORMAL)));
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.getRotatedShape(state);
    }

    private class_265 getRotatedShape(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        if (this.BLOCK_NAME.split("_")[0].equals("small")) {
            switch (((Variant)((Object)state.method_11654(VARIANT))).ordinal()) {
                case 0: {
                    boxes.add(SMALL_SHAPE_HEAD.method_1107());
                    boxes.add(SMALL_SHAPE.method_1107());
                    break;
                }
                case 1: {
                    boxes.add(SMALL_SHAPESIDE_HEAD.method_1107());
                    boxes.add(SMALL_SHAPESIDE.method_1107());
                    break;
                }
                case 2: {
                    boxes.add(SMALL_SHAPESIDE_HEAD.method_1107());
                    boxes.add(SMALL_SHAPESIDE.method_1107());
                    boxes.add(SMALL_SHAPELC_HEAD.method_1107());
                    boxes.add(SMALL_SHAPELC.method_1107());
                    break;
                }
                case 3: {
                    boxes.add(SMALL_SHAPESIDE_HEAD.method_1107());
                    boxes.add(SMALL_SHAPESIDE.method_1107());
                    boxes.add(SMALL_SHAPERC_HEAD.method_1107());
                    boxes.add(SMALL_SHAPERC.method_1107());
                }
            }
        } else {
            switch (((Variant)((Object)state.method_11654(VARIANT))).ordinal()) {
                case 0: {
                    boxes.add(SHAPE_HEAD.method_1107());
                    boxes.add(SHAPE.method_1107());
                    break;
                }
                case 1: {
                    boxes.add(SHAPESIDE_HEAD.method_1107());
                    boxes.add(SHAPESIDE.method_1107());
                    break;
                }
                case 2: {
                    boxes.add(SHAPESIDE_HEAD.method_1107());
                    boxes.add(SHAPESIDE.method_1107());
                    boxes.add(SHAPELC_HEAD.method_1107());
                    boxes.add(SHAPELC.method_1107());
                    break;
                }
                case 3: {
                    boxes.add(SHAPESIDE_HEAD.method_1107());
                    boxes.add(SHAPESIDE.method_1107());
                    boxes.add(SHAPERC_HEAD.method_1107());
                    boxes.add(SHAPERC.method_1107());
                }
            }
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED, VARIANT});
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return this.updateStairailVariant(world, state, pos);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        class_2680 updatedState = this.updateStairailVariant((class_1936)world, state, pos);
        if (!updatedState.equals(state)) {
            world.method_8652(pos, updatedState, 3);
        }
        this.updateSurroundingStairails(world, pos);
    }

    private void updateSurroundingStairails(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2680 updatedState;
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(neighborPos);
            if (neighborState.method_26204() != this || neighborState.equals(updatedState = this.updateStairailVariant((class_1936)world, neighborState, neighborPos))) continue;
            world.method_8501(neighborPos, updatedState);
        }
    }

    private class_2680 updateStairailVariant(class_1936 world, class_2680 state, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 leftPos = pos.method_10093(facing.method_10160());
        class_2338 rightPos = pos.method_10093(facing.method_10170());
        if (this.isStairailL(world, rightPos.method_10093(facing.method_10160()).method_10093(facing.method_10170().method_10170()), facing)) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.RIGHTCORNER));
        }
        if (this.isStairailR(world, leftPos.method_10093(facing.method_10170()).method_10093(facing.method_10160().method_10160()), facing)) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.LEFTCORNER));
        }
        boolean leftConnected = this.isStairail(world, leftPos, facing, Variant.RIGHTCORNER);
        boolean rightConnected = this.isStairail(world, rightPos, facing, Variant.LEFTCORNER);
        if (leftConnected || rightConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.SIDE));
        }
        return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isStairail(class_1936 world, class_2338 pos, class_2350 expectedFacing, Variant variant) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() == this && (state.method_11654((class_2769)FACING) == expectedFacing || state.method_11654(VARIANT) == variant);
    }

    private boolean isStairailL(class_1936 world, class_2338 pos, class_2350 expectedFacing) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() == this && state.method_11654((class_2769)FACING) == expectedFacing.method_10170();
    }

    private boolean isStairailR(class_1936 world, class_2338 pos, class_2350 expectedFacing) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() == this && state.method_11654((class_2769)FACING) == expectedFacing.method_10160();
    }

    public static enum Variant implements class_3542
    {
        NORMAL("normal"),
        SIDE("side"),
        LEFTCORNER("leftcorner"),
        RIGHTCORNER("rightcorner");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

