/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstairs.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticstairs.block.custom.YAxisRotatedBlock;
import net.alminoris.aestheticstairs.util.helper.BlockShape;
import net.alminoris.aestheticstairs.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StairailBlock
extends YAxisRotatedBlock {
    private static final VoxelShape SHAPE = StairailBlock.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)15.0, (double)2.0);
    private static final VoxelShape SHAPESIDE = StairailBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0);
    private static final VoxelShape SHAPERC = StairailBlock.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPELC = StairailBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPE_HEAD = StairailBlock.m_49796_((double)6.5, (double)15.0, (double)-0.5, (double)9.5, (double)16.0, (double)2.5);
    private static final VoxelShape SHAPESIDE_HEAD = StairailBlock.m_49796_((double)0.0, (double)15.0, (double)-0.5, (double)16.0, (double)16.0, (double)2.5);
    private static final VoxelShape SHAPELC_HEAD = StairailBlock.m_49796_((double)-0.5, (double)15.0, (double)-0.5, (double)2.5, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPERC_HEAD = StairailBlock.m_49796_((double)13.5, (double)15.0, (double)-0.5, (double)16.5, (double)16.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPE = StairailBlock.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)12.0, (double)2.0);
    private static final VoxelShape SMALL_SHAPESIDE = StairailBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)2.0);
    private static final VoxelShape SMALL_SHAPERC = StairailBlock.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPELC = StairailBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPE_HEAD = StairailBlock.m_49796_((double)6.5, (double)12.0, (double)-0.5, (double)9.5, (double)14.25, (double)2.5);
    private static final VoxelShape SMALL_SHAPESIDE_HEAD = StairailBlock.m_49796_((double)0.0, (double)12.0, (double)-0.5, (double)16.0, (double)14.25, (double)2.5);
    private static final VoxelShape SMALL_SHAPELC_HEAD = StairailBlock.m_49796_((double)-0.5, (double)12.0, (double)-0.5, (double)2.5, (double)14.25, (double)16.0);
    private static final VoxelShape SMALL_SHAPERC_HEAD = StairailBlock.m_49796_((double)13.5, (double)12.0, (double)-0.5, (double)16.5, (double)14.25, (double)16.0);
    public static final EnumProperty<Variant> VARIANT = EnumProperty.m_61587_((String)"variant", Variant.class);
    private final String BLOCK_NAME;

    public StairailBlock(BlockBehaviour.Properties settings, String blockName) {
        super(settings.m_60955_(), new BlockShape[0]);
        this.BLOCK_NAME = blockName;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL)));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        if (this.BLOCK_NAME.split("_")[0].equals("small")) {
            switch ((Variant)((Object)state.m_61143_(VARIANT))) {
                case NORMAL: {
                    boxes.add(SMALL_SHAPE_HEAD.m_83215_());
                    boxes.add(SMALL_SHAPE.m_83215_());
                    break;
                }
                case SIDE: {
                    boxes.add(SMALL_SHAPESIDE_HEAD.m_83215_());
                    boxes.add(SMALL_SHAPESIDE.m_83215_());
                    break;
                }
                case LEFTCORNER: {
                    boxes.add(SMALL_SHAPESIDE_HEAD.m_83215_());
                    boxes.add(SMALL_SHAPESIDE.m_83215_());
                    boxes.add(SMALL_SHAPELC_HEAD.m_83215_());
                    boxes.add(SMALL_SHAPELC.m_83215_());
                    break;
                }
                case RIGHTCORNER: {
                    boxes.add(SMALL_SHAPESIDE_HEAD.m_83215_());
                    boxes.add(SMALL_SHAPESIDE.m_83215_());
                    boxes.add(SMALL_SHAPERC_HEAD.m_83215_());
                    boxes.add(SMALL_SHAPERC.m_83215_());
                }
            }
        } else {
            switch ((Variant)((Object)state.m_61143_(VARIANT))) {
                case NORMAL: {
                    boxes.add(SHAPE_HEAD.m_83215_());
                    boxes.add(SHAPE.m_83215_());
                    break;
                }
                case SIDE: {
                    boxes.add(SHAPESIDE_HEAD.m_83215_());
                    boxes.add(SHAPESIDE.m_83215_());
                    break;
                }
                case LEFTCORNER: {
                    boxes.add(SHAPESIDE_HEAD.m_83215_());
                    boxes.add(SHAPESIDE.m_83215_());
                    boxes.add(SHAPELC_HEAD.m_83215_());
                    boxes.add(SHAPELC.m_83215_());
                    break;
                }
                case RIGHTCORNER: {
                    boxes.add(SHAPESIDE_HEAD.m_83215_());
                    boxes.add(SHAPESIDE.m_83215_());
                    boxes.add(SHAPERC_HEAD.m_83215_());
                    boxes.add(SHAPERC.m_83215_());
                }
            }
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.updateStairailVariant(world, state, pos);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, VARIANT});
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.m_6807_(state, world, pos, oldState, notify);
        BlockState updatedState = this.updateStairailVariant((LevelAccessor)world, state, pos);
        if (!updatedState.equals(state)) {
            world.m_7731_(pos, updatedState, 3);
        }
        this.updateSurroundingStairails(world, pos);
    }

    private void updateSurroundingStairails(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState updatedState;
            BlockPos neighborPos = pos.m_141952_(direction.m_122436_());
            BlockState neighborState = world.m_8055_(neighborPos);
            if (neighborState.m_60734_() != this || neighborState.equals(updatedState = this.updateStairailVariant((LevelAccessor)world, neighborState, neighborPos))) continue;
            world.m_7731_(neighborPos, updatedState, 3);
        }
    }

    private BlockState updateStairailVariant(LevelAccessor world, BlockState state, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos leftPos = pos.m_141952_(facing.m_175364_(Direction.Axis.Y).m_122436_());
        BlockPos rightPos = pos.m_141952_(facing.m_175362_(Direction.Axis.Y).m_122436_());
        if (this.isStairailL(world, rightPos.m_141952_(facing.m_175364_(Direction.Axis.Y).m_122436_()).m_141952_(facing.m_175362_(Direction.Axis.Y).m_175362_(Direction.Axis.Y).m_122436_()), facing)) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.RIGHTCORNER));
        }
        if (this.isStairailR(world, leftPos.m_141952_(facing.m_175362_(Direction.Axis.Y).m_122436_()).m_141952_(facing.m_175364_(Direction.Axis.Y).m_175364_(Direction.Axis.Y).m_122436_()), facing)) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.LEFTCORNER));
        }
        boolean leftConnected = this.isStairail(world, leftPos, facing, Variant.RIGHTCORNER);
        boolean rightConnected = this.isStairail(world, rightPos, facing, Variant.LEFTCORNER);
        if (leftConnected || rightConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.SIDE));
        }
        return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isStairail(LevelAccessor world, BlockPos pos, Direction expectedFacing, Variant variant) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() == this && (state.m_61143_((Property)FACING) == expectedFacing || state.m_61143_(VARIANT) == variant);
    }

    private boolean isStairailL(LevelAccessor world, BlockPos pos, Direction expectedFacing) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() == this && state.m_61143_((Property)FACING) == expectedFacing.m_175362_(Direction.Axis.Y);
    }

    private boolean isStairailR(LevelAccessor world, BlockPos pos, Direction expectedFacing) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() == this && state.m_61143_((Property)FACING) == expectedFacing.m_175364_(Direction.Axis.Y);
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        SIDE("side"),
        LEFTCORNER("leftcorner"),
        RIGHTCORNER("rightcorner");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

