/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstairs.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticstairs.block.ModBlocks;
import net.alminoris.aestheticstairs.block.custom.YAxisRotatedBlock;
import net.alminoris.aestheticstairs.util.helper.BlockShape;
import net.alminoris.aestheticstairs.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StaircaseBlock
extends YAxisRotatedBlock {
    private static final VoxelShape SHAPE = StaircaseBlock.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape SHAPE1 = StaircaseBlock.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)10.0, (double)8.0);
    private static final VoxelShape SHAPELC = StaircaseBlock.m_49796_((double)0.0, (double)7.0, (double)8.0, (double)8.0, (double)10.0, (double)16.0);
    private static final VoxelShape RSHAPEC = StaircaseBlock.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)3.0, (double)16.0);
    private static final VoxelShape LSHAPEC = StaircaseBlock.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape SHAPEC = StaircaseBlock.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)10.0, (double)8.0);
    private static final VoxelShape SHAPERC = StaircaseBlock.m_49796_((double)8.0, (double)7.0, (double)8.0, (double)16.0, (double)10.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPE = StaircaseBlock.m_49796_((double)0.0, (double)2.0, (double)11.0, (double)16.0, (double)4.0, (double)15.0);
    private static final VoxelShape SMALL_SHAPE1 = StaircaseBlock.m_49796_((double)0.0, (double)7.0, (double)5.5, (double)16.0, (double)9.0, (double)9.5);
    private static final VoxelShape SMALL_SHAPE2 = StaircaseBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)4.0);
    private static final VoxelShape SMALL_SHAPERC = StaircaseBlock.m_49796_((double)12.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPERC1 = StaircaseBlock.m_49796_((double)6.5, (double)7.0, (double)9.5, (double)10.5, (double)9.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPERC2 = StaircaseBlock.m_49796_((double)1.0, (double)2.0, (double)15.0, (double)5.0, (double)4.0, (double)16.0);
    private static final VoxelShape SMALL_RSHAPEC = StaircaseBlock.m_49796_((double)0.0, (double)2.0, (double)11.0, (double)5.0, (double)4.0, (double)15.0);
    private static final VoxelShape SMALL_RSHAPEC1 = StaircaseBlock.m_49796_((double)0.0, (double)7.0, (double)5.5, (double)10.5, (double)9.0, (double)9.5);
    private static final VoxelShape SMALL_RSHAPEC2 = StaircaseBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)4.0);
    private static final VoxelShape SMALL_SHAPELC = StaircaseBlock.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPELC1 = StaircaseBlock.m_49796_((double)5.5, (double)7.0, (double)11.0, (double)9.5, (double)9.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPELC2 = StaircaseBlock.m_49796_((double)11.0, (double)2.0, (double)15.0, (double)15.0, (double)4.0, (double)16.0);
    private static final VoxelShape SMALL_LSHAPEC = StaircaseBlock.m_49796_((double)9.0, (double)2.0, (double)11.0, (double)15.0, (double)4.0, (double)15.0);
    private static final VoxelShape SMALL_LSHAPEC1 = StaircaseBlock.m_49796_((double)4.0, (double)7.0, (double)5.5, (double)9.0, (double)9.0, (double)9.5);
    private static final VoxelShape SMALL_LSHAPEC2 = StaircaseBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)14.0, (double)4.0);
    public static final EnumProperty<Variant> VARIANT = EnumProperty.m_61587_((String)"variant", Variant.class);
    public static final BooleanProperty RAILED = BooleanProperty.m_61465_((String)"railed");
    private final String NAME;
    private final String BLOCK_NAME;

    public StaircaseBlock(BlockBehaviour.Properties settings, String name, String blockName) {
        super(settings.m_60955_(), new BlockShape[0]);
        this.NAME = name;
        this.BLOCK_NAME = blockName;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL))).m_61124_((Property)RAILED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Variant currentVariant = (Variant)((Object)state.m_61143_(VARIANT));
        boolean currentRailed = (Boolean)state.m_61143_((Property)RAILED);
        Direction currentFacing = (Direction)state.m_61143_((Property)FACING);
        if (player.m_21205_().m_41619_() && (currentVariant.equals((Object)Variant.CENTER) || currentVariant.equals((Object)Variant.UPCENTER) || currentVariant.equals((Object)Variant.LEFTCORNER) || currentVariant.equals((Object)Variant.RIGHTCORNER))) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            boolean isStackFound;
            ItemStack stack = player.m_21205_();
            boolean bl = isStackFound = !this.BLOCK_NAME.split("_")[0].equals("small") && stack.m_150930_(((Block)ModBlocks.STAIRAILS.get(this.NAME).get()).m_5456_()) || this.BLOCK_NAME.split("_")[0].equals("small") && stack.m_150930_(((Block)ModBlocks.SMALL_STAIRAILS.get(this.NAME).get()).m_5456_());
            if (!currentRailed && isStackFound) {
                stack.m_41774_(1);
                currentRailed = true;
                world.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)currentFacing)).m_61124_(VARIANT, (Comparable)((Object)currentVariant))).m_61124_((Property)RAILED, (Comparable)Boolean.valueOf(currentRailed)), 3);
                return InteractionResult.SUCCESS;
            }
            if (currentRailed && stack.m_41720_() instanceof AxeItem) {
                if (stack.m_41773_() < stack.m_41776_() - 1) {
                    stack.m_41721_(stack.m_41773_() + 1);
                } else {
                    stack.m_41774_(1);
                }
                ItemStack stickStack = new ItemStack((ItemLike)Items.f_42398_);
                stickStack.m_41764_(3);
                if (!player.m_150109_().m_36054_(stickStack)) {
                    player.m_36176_(stickStack, false);
                }
                currentRailed = false;
                world.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)currentFacing)).m_61124_(VARIANT, (Comparable)((Object)currentVariant))).m_61124_((Property)RAILED, (Comparable)Boolean.valueOf(currentRailed)), 3);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        if (this.BLOCK_NAME.split("_")[0].equals("small")) {
            if (state.m_61143_(VARIANT) == Variant.LEFTCORNER) {
                boxes.add(SMALL_LSHAPEC.m_83215_());
                boxes.add(SMALL_LSHAPEC1.m_83215_());
                boxes.add(SMALL_LSHAPEC2.m_83215_());
                boxes.add(SMALL_SHAPELC.m_83215_());
                boxes.add(SMALL_SHAPELC1.m_83215_());
                boxes.add(SMALL_SHAPELC2.m_83215_());
            } else if (state.m_61143_(VARIANT) == Variant.RIGHTCORNER) {
                boxes.add(SMALL_RSHAPEC.m_83215_());
                boxes.add(SMALL_RSHAPEC1.m_83215_());
                boxes.add(SMALL_RSHAPEC2.m_83215_());
                boxes.add(SMALL_SHAPERC.m_83215_());
                boxes.add(SMALL_SHAPERC1.m_83215_());
                boxes.add(SMALL_SHAPERC2.m_83215_());
            } else {
                boxes.add(SMALL_SHAPE.m_83215_());
                boxes.add(SMALL_SHAPE1.m_83215_());
                boxes.add(SMALL_SHAPE2.m_83215_());
            }
        } else if (state.m_61143_(VARIANT) == Variant.LEFTCORNER) {
            boxes.add(LSHAPEC.m_83215_());
            boxes.add(SHAPELC.m_83215_());
            boxes.add(SHAPEC.m_83215_());
        } else if (state.m_61143_(VARIANT) == Variant.RIGHTCORNER) {
            boxes.add(RSHAPEC.m_83215_());
            boxes.add(SHAPERC.m_83215_());
            boxes.add(SHAPEC.m_83215_());
        } else {
            boxes.add(SHAPE.m_83215_());
            boxes.add(SHAPE1.m_83215_());
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, VARIANT, RAILED});
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
        return this.updateStaircaseVariant(state, world, pos);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.m_6807_(state, world, pos, oldState, notify);
        BlockState updatedSelf = this.updateStaircaseVariant(state, (LevelAccessor)world, pos);
        if (updatedSelf != state) {
            world.m_7731_(pos, updatedSelf, 3);
        }
        this.updateSurroundingStaircases(world, pos);
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        super.onBlockStateChange(level, pos, oldState, newState);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return super.m_5573_(ctx);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        super.m_6810_(state, world, pos, newState, moved);
        if (state.m_60734_() != newState.m_60734_()) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState updated;
                BlockPos diagonalAboveForward = pos.m_141952_(direction.m_122436_()).m_7494_();
                BlockState neighborState = world.m_8055_(diagonalAboveForward);
                if (neighborState.m_60734_() != this || (updated = this.updateStaircaseVariant(neighborState, (LevelAccessor)world, diagonalAboveForward)) == neighborState) continue;
                world.m_7731_(diagonalAboveForward, updated, 3);
            }
        }
    }

    private void updateSurroundingStaircases(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState updated;
            BlockPos diagonalAboveForward = pos.m_141952_(direction.m_122436_()).m_7494_();
            BlockState neighborState = world.m_8055_(diagonalAboveForward);
            if (neighborState.m_60734_() != this || (updated = this.updateStaircaseVariant(neighborState, (LevelAccessor)world, diagonalAboveForward)) == neighborState) continue;
            world.m_7731_(diagonalAboveForward, updated, 3);
        }
    }

    private BlockState updateStaircaseVariant(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos diagonalBelowBehind = pos.m_141952_(facing.m_122424_().m_122436_()).m_7495_();
        BlockState belowState = world.m_8055_(diagonalBelowBehind);
        BlockPos leftPos = pos.m_141952_(facing.m_175364_(Direction.Axis.Y).m_122436_());
        BlockPos rightPos = pos.m_141952_(facing.m_175362_(Direction.Axis.Y).m_122436_());
        boolean leftConnected = this.isStaircase(world, leftPos, facing, Variant.RIGHTCORNER);
        boolean rightConnected = this.isStaircase(world, rightPos, facing, Variant.LEFTCORNER);
        BlockPos diagonalAboveAhead = pos.m_141952_(facing.m_122436_()).m_7494_();
        BlockState aheadState = world.m_8055_(diagonalAboveAhead);
        if (state.m_61143_(VARIANT) == Variant.NORMAL && aheadState.m_60734_() == this && aheadState.m_61143_((Property)FACING) == facing) {
            Variant aheadVariant = (Variant)((Object)aheadState.m_61143_(VARIANT));
            if (aheadVariant == Variant.RIGHT) {
                world.m_7731_(diagonalAboveAhead, (BlockState)aheadState.m_61124_(VARIANT, (Comparable)((Object)Variant.UPRIGHT)), 3);
                return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.RIGHT));
            }
            if (aheadVariant == Variant.LEFT) {
                world.m_7731_(diagonalAboveAhead, (BlockState)aheadState.m_61124_(VARIANT, (Comparable)((Object)Variant.UPLEFT)), 3);
                return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.LEFT));
            }
            if (aheadVariant == Variant.CENTER) {
                world.m_7731_(diagonalAboveAhead, (BlockState)aheadState.m_61124_(VARIANT, (Comparable)((Object)Variant.UPCENTER)), 3);
                return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.CENTER));
            }
        }
        if (belowState.m_60734_() == this && belowState.m_61143_((Property)FACING) == facing) {
            switch ((Variant)((Object)belowState.m_61143_(VARIANT))) {
                case CENTER: 
                case UPCENTER: {
                    return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.UPCENTER));
                }
                case RIGHT: 
                case UPRIGHT: {
                    return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.UPRIGHT));
                }
                case LEFT: 
                case UPLEFT: {
                    return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.UPLEFT));
                }
                case NORMAL: 
                case UP: {
                    return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.UP));
                }
            }
        }
        if (this.isStaircaseL(world, rightPos.m_141952_(facing.m_175364_(Direction.Axis.Y).m_122436_()).m_141952_(facing.m_175362_(Direction.Axis.Y).m_175362_(Direction.Axis.Y).m_122436_()), facing)) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.RIGHTCORNER));
        }
        if (this.isStaircaseR(world, leftPos.m_141952_(facing.m_175362_(Direction.Axis.Y).m_122436_()).m_141952_(facing.m_175364_(Direction.Axis.Y).m_175364_(Direction.Axis.Y).m_122436_()), facing)) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.LEFTCORNER));
        }
        if (leftConnected && rightConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isStaircase(LevelAccessor world, BlockPos pos, Direction expectedFacing, Variant variant) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() == this && (state.m_61143_((Property)FACING) == expectedFacing || state.m_61143_(VARIANT) == variant);
    }

    private boolean isStaircaseL(LevelAccessor world, BlockPos pos, Direction expectedFacing) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() == this && state.m_61143_((Property)FACING) == expectedFacing.m_175362_(Direction.Axis.Y);
    }

    private boolean isStaircaseR(LevelAccessor world, BlockPos pos, Direction expectedFacing) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() == this && state.m_61143_((Property)FACING) == expectedFacing.m_175364_(Direction.Axis.Y);
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        LEFT("left"),
        RIGHT("right"),
        LEFTCORNER("leftcorner"),
        RIGHTCORNER("rightcorner"),
        CENTER("center"),
        UP("up"),
        UPLEFT("upleft"),
        UPRIGHT("upright"),
        UPCENTER("upcenter");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

