/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstairs.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticstairs.block.custom.YAxisRotatedBlock;
import net.alminoris.aestheticstairs.util.helper.BlockShape;
import net.alminoris.aestheticstairs.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StairailBlock
extends YAxisRotatedBlock {
    private static final VoxelShape SHAPE = StairailBlock.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)15.0, (double)2.0);
    private static final VoxelShape SHAPESIDE = StairailBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0);
    private static final VoxelShape SHAPERC = StairailBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPELC = StairailBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPE_HEAD = StairailBlock.box((double)6.5, (double)15.0, (double)-0.5, (double)9.5, (double)16.0, (double)2.5);
    private static final VoxelShape SHAPESIDE_HEAD = StairailBlock.box((double)0.0, (double)15.0, (double)-0.5, (double)16.0, (double)16.0, (double)2.5);
    private static final VoxelShape SHAPELC_HEAD = StairailBlock.box((double)-0.5, (double)15.0, (double)-0.5, (double)2.5, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPERC_HEAD = StairailBlock.box((double)13.5, (double)15.0, (double)-0.5, (double)16.5, (double)16.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPE = StairailBlock.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)12.0, (double)2.0);
    private static final VoxelShape SMALL_SHAPESIDE = StairailBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)2.0);
    private static final VoxelShape SMALL_SHAPERC = StairailBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPELC = StairailBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPE_HEAD = StairailBlock.box((double)6.5, (double)12.0, (double)-0.5, (double)9.5, (double)14.25, (double)2.5);
    private static final VoxelShape SMALL_SHAPESIDE_HEAD = StairailBlock.box((double)0.0, (double)12.0, (double)-0.5, (double)16.0, (double)14.25, (double)2.5);
    private static final VoxelShape SMALL_SHAPELC_HEAD = StairailBlock.box((double)-0.5, (double)12.0, (double)-0.5, (double)2.5, (double)14.25, (double)16.0);
    private static final VoxelShape SMALL_SHAPERC_HEAD = StairailBlock.box((double)13.5, (double)12.0, (double)-0.5, (double)16.5, (double)14.25, (double)16.0);
    public static final EnumProperty<Variant> VARIANT = EnumProperty.create((String)"variant", Variant.class);
    private final String BLOCK_NAME;

    public StairailBlock(BlockBehaviour.Properties settings, String blockName) {
        super(settings.noOcclusion(), new BlockShape[0]);
        this.BLOCK_NAME = blockName;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(VARIANT, (Comparable)((Object)Variant.NORMAL)));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        if (this.BLOCK_NAME.split("_")[0].equals("small")) {
            switch (((Variant)((Object)state.getValue(VARIANT))).ordinal()) {
                case 0: {
                    boxes.add(SMALL_SHAPE_HEAD.bounds());
                    boxes.add(SMALL_SHAPE.bounds());
                    break;
                }
                case 1: {
                    boxes.add(SMALL_SHAPESIDE_HEAD.bounds());
                    boxes.add(SMALL_SHAPESIDE.bounds());
                    break;
                }
                case 2: {
                    boxes.add(SMALL_SHAPESIDE_HEAD.bounds());
                    boxes.add(SMALL_SHAPESIDE.bounds());
                    boxes.add(SMALL_SHAPELC_HEAD.bounds());
                    boxes.add(SMALL_SHAPELC.bounds());
                    break;
                }
                case 3: {
                    boxes.add(SMALL_SHAPESIDE_HEAD.bounds());
                    boxes.add(SMALL_SHAPESIDE.bounds());
                    boxes.add(SMALL_SHAPERC_HEAD.bounds());
                    boxes.add(SMALL_SHAPERC.bounds());
                }
            }
        } else {
            switch (((Variant)((Object)state.getValue(VARIANT))).ordinal()) {
                case 0: {
                    boxes.add(SHAPE_HEAD.bounds());
                    boxes.add(SHAPE.bounds());
                    break;
                }
                case 1: {
                    boxes.add(SHAPESIDE_HEAD.bounds());
                    boxes.add(SHAPESIDE.bounds());
                    break;
                }
                case 2: {
                    boxes.add(SHAPESIDE_HEAD.bounds());
                    boxes.add(SHAPESIDE.bounds());
                    boxes.add(SHAPELC_HEAD.bounds());
                    boxes.add(SHAPELC.bounds());
                    break;
                }
                case 3: {
                    boxes.add(SHAPESIDE_HEAD.bounds());
                    boxes.add(SHAPESIDE.bounds());
                    boxes.add(SHAPERC_HEAD.bounds());
                    boxes.add(SHAPERC.bounds());
                }
            }
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.updateStairailVariant(world, state, pos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, VARIANT});
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.onPlace(state, world, pos, oldState, notify);
        BlockState updatedState = this.updateStairailVariant((LevelAccessor)world, state, pos);
        if (!updatedState.equals(state)) {
            world.setBlock(pos, updatedState, 3);
        }
        this.updateSurroundingStairails(world, pos);
    }

    private void updateSurroundingStairails(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState updatedState;
            BlockPos neighborPos = pos.offset(direction.getNormal());
            BlockState neighborState = world.getBlockState(neighborPos);
            if (neighborState.getBlock() != this || neighborState.equals(updatedState = this.updateStairailVariant((LevelAccessor)world, neighborState, neighborPos))) continue;
            world.setBlock(neighborPos, updatedState, 3);
        }
    }

    private BlockState updateStairailVariant(LevelAccessor world, BlockState state, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos leftPos = pos.offset(facing.getCounterClockWise(Direction.Axis.Y).getNormal());
        BlockPos rightPos = pos.offset(facing.getClockWise(Direction.Axis.Y).getNormal());
        if (this.isStairailL(world, rightPos.offset(facing.getCounterClockWise(Direction.Axis.Y).getNormal()).offset(facing.getClockWise(Direction.Axis.Y).getClockWise(Direction.Axis.Y).getNormal()), facing)) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.RIGHTCORNER));
        }
        if (this.isStairailR(world, leftPos.offset(facing.getClockWise(Direction.Axis.Y).getNormal()).offset(facing.getCounterClockWise(Direction.Axis.Y).getCounterClockWise(Direction.Axis.Y).getNormal()), facing)) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.LEFTCORNER));
        }
        boolean leftConnected = this.isStairail(world, leftPos, facing, Variant.RIGHTCORNER);
        boolean rightConnected = this.isStairail(world, rightPos, facing, Variant.LEFTCORNER);
        if (leftConnected || rightConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.SIDE));
        }
        return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isStairail(LevelAccessor world, BlockPos pos, Direction expectedFacing, Variant variant) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() == this && (state.getValue((Property)FACING) == expectedFacing || state.getValue(VARIANT) == variant);
    }

    private boolean isStairailL(LevelAccessor world, BlockPos pos, Direction expectedFacing) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() == this && state.getValue((Property)FACING) == expectedFacing.getClockWise(Direction.Axis.Y);
    }

    private boolean isStairailR(LevelAccessor world, BlockPos pos, Direction expectedFacing) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() == this && state.getValue((Property)FACING) == expectedFacing.getCounterClockWise(Direction.Axis.Y);
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        SIDE("side"),
        LEFTCORNER("leftcorner"),
        RIGHTCORNER("rightcorner");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

