/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstairs.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticstairs.block.ModBlocks;
import net.alminoris.aestheticstairs.block.custom.YAxisRotatedBlock;
import net.alminoris.aestheticstairs.util.helper.BlockShape;
import net.alminoris.aestheticstairs.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StaircaseBlock
extends YAxisRotatedBlock {
    private static final VoxelShape SHAPE = StaircaseBlock.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape SHAPE1 = StaircaseBlock.box((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)10.0, (double)8.0);
    private static final VoxelShape SHAPELC = StaircaseBlock.box((double)0.0, (double)7.0, (double)8.0, (double)8.0, (double)10.0, (double)16.0);
    private static final VoxelShape RSHAPEC = StaircaseBlock.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)3.0, (double)16.0);
    private static final VoxelShape LSHAPEC = StaircaseBlock.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape SHAPEC = StaircaseBlock.box((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)10.0, (double)8.0);
    private static final VoxelShape SHAPERC = StaircaseBlock.box((double)8.0, (double)7.0, (double)8.0, (double)16.0, (double)10.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPE = StaircaseBlock.box((double)0.0, (double)2.0, (double)11.0, (double)16.0, (double)4.0, (double)15.0);
    private static final VoxelShape SMALL_SHAPE1 = StaircaseBlock.box((double)0.0, (double)7.0, (double)5.5, (double)16.0, (double)9.0, (double)9.5);
    private static final VoxelShape SMALL_SHAPE2 = StaircaseBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)4.0);
    private static final VoxelShape SMALL_SHAPERC = StaircaseBlock.box((double)12.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPERC1 = StaircaseBlock.box((double)6.5, (double)7.0, (double)9.5, (double)10.5, (double)9.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPERC2 = StaircaseBlock.box((double)1.0, (double)2.0, (double)15.0, (double)5.0, (double)4.0, (double)16.0);
    private static final VoxelShape SMALL_RSHAPEC = StaircaseBlock.box((double)0.0, (double)2.0, (double)11.0, (double)5.0, (double)4.0, (double)15.0);
    private static final VoxelShape SMALL_RSHAPEC1 = StaircaseBlock.box((double)0.0, (double)7.0, (double)5.5, (double)10.5, (double)9.0, (double)9.5);
    private static final VoxelShape SMALL_RSHAPEC2 = StaircaseBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)4.0);
    private static final VoxelShape SMALL_SHAPELC = StaircaseBlock.box((double)0.0, (double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPELC1 = StaircaseBlock.box((double)5.5, (double)7.0, (double)11.0, (double)9.5, (double)9.0, (double)16.0);
    private static final VoxelShape SMALL_SHAPELC2 = StaircaseBlock.box((double)11.0, (double)2.0, (double)15.0, (double)15.0, (double)4.0, (double)16.0);
    private static final VoxelShape SMALL_LSHAPEC = StaircaseBlock.box((double)9.0, (double)2.0, (double)11.0, (double)15.0, (double)4.0, (double)15.0);
    private static final VoxelShape SMALL_LSHAPEC1 = StaircaseBlock.box((double)4.0, (double)7.0, (double)5.5, (double)9.0, (double)9.0, (double)9.5);
    private static final VoxelShape SMALL_LSHAPEC2 = StaircaseBlock.box((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)14.0, (double)4.0);
    public static final EnumProperty<Variant> VARIANT = EnumProperty.create((String)"variant", Variant.class);
    public static final BooleanProperty RAILED = BooleanProperty.create((String)"railed");
    private final String NAME;
    private final String BLOCK_NAME;

    public StaircaseBlock(BlockBehaviour.Properties settings, String name, String blockName) {
        super(settings.noOcclusion(), new BlockShape[0]);
        this.NAME = name;
        this.BLOCK_NAME = blockName;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(VARIANT, (Comparable)((Object)Variant.NORMAL))).setValue((Property)RAILED, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        Variant currentVariant = (Variant)((Object)state.getValue(VARIANT));
        boolean currentRailed = (Boolean)state.getValue((Property)RAILED);
        Direction currentFacing = (Direction)state.getValue((Property)FACING);
        if (player.getMainHandItem().isEmpty() && (currentVariant.equals((Object)Variant.CENTER) || currentVariant.equals((Object)Variant.UPCENTER) || currentVariant.equals((Object)Variant.LEFTCORNER) || currentVariant.equals((Object)Variant.RIGHTCORNER))) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide) {
            boolean isStackFound;
            ItemStack stack = player.getMainHandItem();
            boolean bl = isStackFound = !this.BLOCK_NAME.split("_")[0].equals("small") && stack.is(((Block)ModBlocks.STAIRAILS.get(this.NAME).get()).asItem()) || this.BLOCK_NAME.split("_")[0].equals("small") && stack.is(((Block)ModBlocks.SMALL_STAIRAILS.get(this.NAME).get()).asItem());
            if (!currentRailed && isStackFound) {
                stack.shrink(1);
                currentRailed = true;
                world.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)currentFacing)).setValue(VARIANT, (Comparable)((Object)currentVariant))).setValue((Property)RAILED, (Comparable)Boolean.valueOf(currentRailed)), 3);
                return InteractionResult.SUCCESS;
            }
            if (currentRailed && stack.is(ItemTags.AXES)) {
                if (stack.getDamageValue() < stack.getMaxDamage() - 1) {
                    stack.setDamageValue(stack.getDamageValue() + 1);
                } else {
                    stack.shrink(1);
                }
                ItemStack stickStack = new ItemStack((ItemLike)Items.STICK);
                stickStack.setCount(3);
                if (!player.getInventory().add(stickStack)) {
                    player.drop(stickStack, false);
                }
                currentRailed = false;
                world.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)currentFacing)).setValue(VARIANT, (Comparable)((Object)currentVariant))).setValue((Property)RAILED, (Comparable)Boolean.valueOf(currentRailed)), 3);
                return InteractionResult.SUCCESS;
            }
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        if (this.BLOCK_NAME.split("_")[0].equals("small")) {
            if (state.getValue(VARIANT) == Variant.LEFTCORNER) {
                boxes.add(SMALL_LSHAPEC.bounds());
                boxes.add(SMALL_LSHAPEC1.bounds());
                boxes.add(SMALL_LSHAPEC2.bounds());
                boxes.add(SMALL_SHAPELC.bounds());
                boxes.add(SMALL_SHAPELC1.bounds());
                boxes.add(SMALL_SHAPELC2.bounds());
            } else if (state.getValue(VARIANT) == Variant.RIGHTCORNER) {
                boxes.add(SMALL_RSHAPEC.bounds());
                boxes.add(SMALL_RSHAPEC1.bounds());
                boxes.add(SMALL_RSHAPEC2.bounds());
                boxes.add(SMALL_SHAPERC.bounds());
                boxes.add(SMALL_SHAPERC1.bounds());
                boxes.add(SMALL_SHAPERC2.bounds());
            } else {
                boxes.add(SMALL_SHAPE.bounds());
                boxes.add(SMALL_SHAPE1.bounds());
                boxes.add(SMALL_SHAPE2.bounds());
            }
        } else if (state.getValue(VARIANT) == Variant.LEFTCORNER) {
            boxes.add(LSHAPEC.bounds());
            boxes.add(SHAPELC.bounds());
            boxes.add(SHAPEC.bounds());
        } else if (state.getValue(VARIANT) == Variant.RIGHTCORNER) {
            boxes.add(RSHAPEC.bounds());
            boxes.add(SHAPERC.bounds());
            boxes.add(SHAPEC.bounds());
        } else {
            boxes.add(SHAPE.bounds());
            boxes.add(SHAPE1.bounds());
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, VARIANT, RAILED});
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        return this.updateStaircaseVariant(state, world, pos);
    }

    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.onPlace(state, world, pos, oldState, notify);
        BlockState updatedSelf = this.updateStaircaseVariant(state, (LevelAccessor)world, pos);
        if (updatedSelf != state) {
            world.setBlock(pos, updatedSelf, 3);
        }
        this.updateSurroundingStaircases(world, pos);
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        super.onBlockStateChange(level, pos, oldState, newState);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return super.getStateForPlacement(ctx);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        super.onRemove(state, world, pos, newState, moved);
        if (state.getBlock() != newState.getBlock()) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState updated;
                BlockPos diagonalAboveForward = pos.offset(direction.getNormal()).above();
                BlockState neighborState = world.getBlockState(diagonalAboveForward);
                if (neighborState.getBlock() != this || (updated = this.updateStaircaseVariant(neighborState, (LevelAccessor)world, diagonalAboveForward)) == neighborState) continue;
                world.setBlock(diagonalAboveForward, updated, 3);
            }
        }
    }

    private void updateSurroundingStaircases(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState updated;
            BlockPos diagonalAboveForward = pos.offset(direction.getNormal()).above();
            BlockState neighborState = world.getBlockState(diagonalAboveForward);
            if (neighborState.getBlock() != this || (updated = this.updateStaircaseVariant(neighborState, (LevelAccessor)world, diagonalAboveForward)) == neighborState) continue;
            world.setBlock(diagonalAboveForward, updated, 3);
        }
    }

    private BlockState updateStaircaseVariant(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos diagonalBelowBehind = pos.offset(facing.getOpposite().getNormal()).below();
        BlockState belowState = world.getBlockState(diagonalBelowBehind);
        BlockPos leftPos = pos.offset(facing.getCounterClockWise(Direction.Axis.Y).getNormal());
        BlockPos rightPos = pos.offset(facing.getClockWise(Direction.Axis.Y).getNormal());
        boolean leftConnected = this.isStaircase(world, leftPos, facing, Variant.RIGHTCORNER);
        boolean rightConnected = this.isStaircase(world, rightPos, facing, Variant.LEFTCORNER);
        BlockPos diagonalAboveAhead = pos.offset(facing.getNormal()).above();
        BlockState aheadState = world.getBlockState(diagonalAboveAhead);
        if (state.getValue(VARIANT) == Variant.NORMAL && aheadState.getBlock() == this && aheadState.getValue((Property)FACING) == facing) {
            Variant aheadVariant = (Variant)((Object)aheadState.getValue(VARIANT));
            if (aheadVariant == Variant.RIGHT) {
                world.setBlock(diagonalAboveAhead, (BlockState)aheadState.setValue(VARIANT, (Comparable)((Object)Variant.UPRIGHT)), 3);
                return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.RIGHT));
            }
            if (aheadVariant == Variant.LEFT) {
                world.setBlock(diagonalAboveAhead, (BlockState)aheadState.setValue(VARIANT, (Comparable)((Object)Variant.UPLEFT)), 3);
                return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.LEFT));
            }
            if (aheadVariant == Variant.CENTER) {
                world.setBlock(diagonalAboveAhead, (BlockState)aheadState.setValue(VARIANT, (Comparable)((Object)Variant.UPCENTER)), 3);
                return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.CENTER));
            }
        }
        if (belowState.getBlock() == this && belowState.getValue((Property)FACING) == facing) {
            switch (((Variant)((Object)belowState.getValue(VARIANT))).ordinal()) {
                case 5: 
                case 9: {
                    return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.UPCENTER));
                }
                case 2: 
                case 8: {
                    return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.UPRIGHT));
                }
                case 1: 
                case 7: {
                    return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.UPLEFT));
                }
                case 0: 
                case 6: {
                    return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.UP));
                }
            }
        }
        if (this.isStaircaseL(world, rightPos.offset(facing.getCounterClockWise(Direction.Axis.Y).getNormal()).offset(facing.getClockWise(Direction.Axis.Y).getClockWise(Direction.Axis.Y).getNormal()), facing)) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.RIGHTCORNER));
        }
        if (this.isStaircaseR(world, leftPos.offset(facing.getClockWise(Direction.Axis.Y).getNormal()).offset(facing.getCounterClockWise(Direction.Axis.Y).getCounterClockWise(Direction.Axis.Y).getNormal()), facing)) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.LEFTCORNER));
        }
        if (leftConnected && rightConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isStaircase(LevelAccessor world, BlockPos pos, Direction expectedFacing, Variant variant) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() == this && (state.getValue((Property)FACING) == expectedFacing || state.getValue(VARIANT) == variant);
    }

    private boolean isStaircaseL(LevelAccessor world, BlockPos pos, Direction expectedFacing) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() == this && state.getValue((Property)FACING) == expectedFacing.getClockWise(Direction.Axis.Y);
    }

    private boolean isStaircaseR(LevelAccessor world, BlockPos pos, Direction expectedFacing) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() == this && state.getValue((Property)FACING) == expectedFacing.getCounterClockWise(Direction.Axis.Y);
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        LEFT("left"),
        RIGHT("right"),
        LEFTCORNER("leftcorner"),
        RIGHTCORNER("rightcorner"),
        CENTER("center"),
        UP("up"),
        UPLEFT("upleft"),
        UPRIGHT("upright"),
        UPCENTER("upcenter");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

