/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstairs.datagen;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.CompletableFuture;
import net.alminoris.aestheticstairs.block.ModBlocks;
import net.alminoris.aestheticstairs.util.helper.BlockSetsHelper;
import net.alminoris.aestheticstairs.util.helper.ModJsonHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    private static final Dictionary<String, Block> SECONDARY_STONES = new Hashtable<String, Block>(){
        {
            this.put("stone", Blocks.COBBLESTONE);
            this.put("tuff", Blocks.POLISHED_TUFF);
            this.put("blackstone", Blocks.POLISHED_BLACKSTONE);
            this.put("andesite", Blocks.POLISHED_ANDESITE);
            this.put("diorite", Blocks.POLISHED_DIORITE);
            this.put("granite", Blocks.POLISHED_GRANITE);
            this.put("deepslate", Blocks.POLISHED_DEEPSLATE);
            this.put("basalt_side", Blocks.SMOOTH_BASALT);
            this.put("quartz_block_bottom", Blocks.QUARTZ_PILLAR);
            this.put("stone_bricks", Blocks.SMOOTH_STONE);
            this.put("bricks", Blocks.CHISELED_STONE_BRICKS);
            this.put("mud_bricks", Blocks.PACKED_MUD);
            this.put("sandstone", Blocks.SANDSTONE);
        }
    };

    public ModRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput recipeExporter) {
        for (String name : BlockSetsHelper.STONES) {
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.withDefaultNamespace((String)(name.equals("basalt_side") ? "basalt" : (name.equals("quartz_block_bottom") ? "quartz_block" : name))));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.SMALL_STAIRS.get(name).get()), (int)3).define(Character.valueOf('#'), (ItemLike)block).pattern("# ").pattern("##").unlockedBy(ModRecipeProvider.getHasName((ItemLike)block), ModRecipeProvider.has((ItemLike)block)).save(recipeExporter);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.SMALL_HALFSTAIRS.get(name).get()), (int)3).define(Character.valueOf('#'), (ItemLike)block).pattern("# ").pattern(" #").unlockedBy(ModRecipeProvider.getHasName((ItemLike)block), ModRecipeProvider.has((ItemLike)block)).save(recipeExporter);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.STAIRCASES.get(name).get()), (int)3).define(Character.valueOf('#'), (ItemLike)block).define(Character.valueOf('/'), (ItemLike)SECONDARY_STONES.get(name)).pattern("#  ").pattern("/# ").pattern(" /#").unlockedBy(ModRecipeProvider.getHasName((ItemLike)block), ModRecipeProvider.has((ItemLike)block)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)SECONDARY_STONES.get(name))), ModRecipeProvider.has((ItemLike)((ItemLike)SECONDARY_STONES.get(name)))).save(recipeExporter);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.SMALL_STAIRCASES.get(name).get()), (int)3).define(Character.valueOf('#'), (ItemLike)block).define(Character.valueOf('/'), (ItemLike)SECONDARY_STONES.get(name)).pattern("# ").pattern("/#").unlockedBy(ModRecipeProvider.getHasName((ItemLike)block), ModRecipeProvider.has((ItemLike)block)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)SECONDARY_STONES.get(name))), ModRecipeProvider.has((ItemLike)((ItemLike)SECONDARY_STONES.get(name)))).save(recipeExporter);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.STAIRAILS.get(name).get()), (int)4).define(Character.valueOf('#'), (ItemLike)block).define(Character.valueOf('/'), (ItemLike)SECONDARY_STONES.get(name)).pattern("/#/").pattern("/#/").unlockedBy(ModRecipeProvider.getHasName((ItemLike)block), ModRecipeProvider.has((ItemLike)block)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)SECONDARY_STONES.get(name))), ModRecipeProvider.has((ItemLike)((ItemLike)SECONDARY_STONES.get(name)))).save(recipeExporter);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.SMALL_STAIRAILS.get(name).get()), (int)3).define(Character.valueOf('#'), (ItemLike)block).define(Character.valueOf('/'), (ItemLike)SECONDARY_STONES.get(name)).pattern("/#/").unlockedBy(ModRecipeProvider.getHasName((ItemLike)block), ModRecipeProvider.has((ItemLike)block)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)SECONDARY_STONES.get(name))), ModRecipeProvider.has((ItemLike)((ItemLike)SECONDARY_STONES.get(name)))).save(recipeExporter);
        }
        for (String name : BlockSetsHelper.EXTRA_STONES_WF) {
            ModJsonHelper.createShapedRecipe("small_stairs_" + name, "3", "wildfields:" + name, "\"#  \",", "\"## \"", "");
            ModJsonHelper.createShapedRecipe("small_halfstairs_" + name, "3", "wildfields:" + name, "\"#  \",", "\" # \"", "");
            ModJsonHelper.createShapedRecipe("staircase_" + name, "3", "wildfields:" + name, "wildfields:" + name.replace("block", "cobbled"), "\"#  \",", "\"/# \",", "\" /#\"");
            ModJsonHelper.createShapedRecipe("small_staircase_" + name, "3", "wildfields:" + name, "wildfields:" + name.replace("block", "cobbled"), "\"# \",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("stairail_" + name, "3", "wildfields:" + name, "wildfields:" + name.replace("block", "cobbled"), "\"/#/\",", "\"/#/\"", "");
            ModJsonHelper.createShapedRecipe("small_stairail_" + name, "3", "wildfields:" + name, "wildfields:" + name.replace("block", "cobbled"), "\"/#/\"", "", "");
        }
        for (String name : BlockSetsHelper.WOODS) {
            String blockName = name.equals("crimson") || name.equals("warped") ? "stem" : (name.equals("bamboo") ? "block" : "log");
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.withDefaultNamespace((String)("stripped_" + name + "_" + blockName)));
            Block block1 = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.withDefaultNamespace((String)(name + "_planks")));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.SMALL_STAIRS.get(name).get()), (int)3).define(Character.valueOf('#'), (ItemLike)block1).pattern("# ").pattern("##").unlockedBy(ModRecipeProvider.getHasName((ItemLike)block1), ModRecipeProvider.has((ItemLike)block1)).save(recipeExporter);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.SMALL_HALFSTAIRS.get(name).get()), (int)3).define(Character.valueOf('#'), (ItemLike)block1).pattern("# ").pattern(" #").unlockedBy(ModRecipeProvider.getHasName((ItemLike)block1), ModRecipeProvider.has((ItemLike)block1)).save(recipeExporter);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.STAIRCASES.get(name).get()), (int)3).define(Character.valueOf('#'), (ItemLike)block).define(Character.valueOf('/'), (ItemLike)Items.STICK).pattern("#  ").pattern("/# ").pattern(" /#").unlockedBy(ModRecipeProvider.getHasName((ItemLike)block), ModRecipeProvider.has((ItemLike)block)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.STICK), ModRecipeProvider.has((ItemLike)Items.STICK)).save(recipeExporter);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.SMALL_STAIRCASES.get(name).get()), (int)3).define(Character.valueOf('#'), (ItemLike)block).define(Character.valueOf('/'), (ItemLike)Items.STICK).pattern("# ").pattern("/#").unlockedBy(ModRecipeProvider.getHasName((ItemLike)block), ModRecipeProvider.has((ItemLike)block)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.STICK), ModRecipeProvider.has((ItemLike)Items.STICK)).save(recipeExporter);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.STAIRAILS.get(name).get()), (int)4).define(Character.valueOf('#'), (ItemLike)block).define(Character.valueOf('/'), (ItemLike)Items.STICK).pattern("/#/").pattern("/#/").unlockedBy(ModRecipeProvider.getHasName((ItemLike)block), ModRecipeProvider.has((ItemLike)block)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.STICK), ModRecipeProvider.has((ItemLike)Items.STICK)).save(recipeExporter);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.SMALL_STAIRAILS.get(name).get()), (int)3).define(Character.valueOf('#'), (ItemLike)block).define(Character.valueOf('/'), (ItemLike)Items.STICK).pattern("/#/").unlockedBy(ModRecipeProvider.getHasName((ItemLike)block), ModRecipeProvider.has((ItemLike)block)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.STICK), ModRecipeProvider.has((ItemLike)Items.STICK)).save(recipeExporter);
        }
        for (String name : BlockSetsHelper.EXTRA_WOODS_AN) {
            ModJsonHelper.createShapedRecipe("small_stairs_" + name, "3", "arborealnature:" + name + "_planks", "\"#  \",", "\"## \"", "");
            ModJsonHelper.createShapedRecipe("small_halfstairs_" + name, "3", "arborealnature:" + name + "_planks", "\"#  \",", "\" # \"", "");
            ModJsonHelper.createShapedRecipe("staircase_" + name, "3", "arborealnature:stripped_" + name + "_log", "minecraft:stick", "\"#  \",", "\"/# \",", "\" /#\"");
            ModJsonHelper.createShapedRecipe("small_staircase_" + name, "3", "arborealnature:stripped_" + name + "_log", "minecraft:stick", "\"# \",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("stairail_" + name, "3", "arborealnature:stripped_" + name + "_log", "minecraft:stick", "\"/#/\",", "\"/#/\"", "");
            ModJsonHelper.createShapedRecipe("small_stairail_" + name, "3", "arborealnature:stripped_" + name + "_log", "minecraft:stick", "\"/#/\"", "", "");
        }
        for (String name : BlockSetsHelper.EXTRA_WOODS_WF) {
            ModJsonHelper.createShapedRecipe("small_stairs_" + name, "3", "wildfields:" + name + "_planks", "\"#  \",", "\"## \"", "");
            ModJsonHelper.createShapedRecipe("small_halfstairs_" + name, "3", "wildfields:" + name + "_planks", "\"#  \",", "\" # \"", "");
            ModJsonHelper.createShapedRecipe("staircase_" + name, "3", "wildfields:stripped_" + name + "_log", "minecraft:stick", "\"#  \",", "\"/# \",", "\" /#\"");
            ModJsonHelper.createShapedRecipe("small_staircase_" + name, "3", "wildfields:stripped_" + name + "_log", "minecraft:stick", "\"# \",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("stairail_" + name, "3", "wildfields:stripped_" + name + "_log", "minecraft:stick", "\"/#/\",", "\"/#/\"", "");
            ModJsonHelper.createShapedRecipe("small_stairail_" + name, "3", "wildfields:stripped_" + name + "_log", "minecraft:stick", "\"/#/\"", "", "");
        }
        for (String name : BlockSetsHelper.ST_WOOD_NAMES) {
            ModJsonHelper.createShapedRecipe("small_stairs_" + name, "3", "silverwoodtrees:" + name + "_planks", "\"#  \",", "\"## \"", "");
            ModJsonHelper.createShapedRecipe("small_halfstairs_" + name, "3", "silverwoodtrees:" + name + "_planks", "\"#  \",", "\" # \"", "");
            ModJsonHelper.createShapedRecipe("staircase_" + name, "3", "silverwoodtrees:stripped_" + name + "_log", "minecraft:stick", "\"#  \",", "\"/# \",", "\" /#\"");
            ModJsonHelper.createShapedRecipe("small_staircase_" + name, "3", "silverwoodtrees:stripped_" + name + "_log", "minecraft:stick", "\"# \",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("stairail_" + name, "3", "silverwoodtrees:stripped_" + name + "_log", "minecraft:stick", "\"/#/\",", "\"/#/\"", "");
            ModJsonHelper.createShapedRecipe("small_stairail_" + name, "3", "silverwoodtrees:stripped_" + name + "_log", "minecraft:stick", "\"/#/\"", "", "");
        }
        for (String name : BlockSetsHelper.WT_WOOD_NAMES) {
            ModJsonHelper.createShapedRecipe("small_stairs_" + name, "3", "whisperleaftrees:" + name + "_planks", "\"#  \",", "\"## \"", "");
            ModJsonHelper.createShapedRecipe("small_halfstairs_" + name, "3", "whisperleaftrees:" + name + "_planks", "\"#  \",", "\" # \"", "");
            ModJsonHelper.createShapedRecipe("staircase_" + name, "3", "whisperleaftrees:stripped_" + name + "_log", "minecraft:stick", "\"#  \",", "\"/# \",", "\" /#\"");
            ModJsonHelper.createShapedRecipe("small_staircase_" + name, "3", "whisperleaftrees:stripped_" + name + "_log", "minecraft:stick", "\"# \",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("stairail_" + name, "3", "whisperleaftrees:stripped_" + name + "_log", "minecraft:stick", "\"/#/\",", "\"/#/\"", "");
            ModJsonHelper.createShapedRecipe("small_stairail_" + name, "3", "whisperleaftrees:stripped_" + name + "_log", "minecraft:stick", "\"/#/\"", "", "");
        }
        for (String name : BlockSetsHelper.MT_WOOD_NAMES) {
            ModJsonHelper.createShapedRecipe("small_stairs_" + name, "3", "missingtrees:" + name + "_planks", "\"#  \",", "\"## \"", "");
            ModJsonHelper.createShapedRecipe("small_halfstairs_" + name, "3", "missingtrees:" + name + "_planks", "\"#  \",", "\" # \"", "");
            ModJsonHelper.createShapedRecipe("staircase_" + name, "3", "missingtrees:stripped_" + name + "_log", "minecraft:stick", "\"#  \",", "\"/# \",", "\" /#\"");
            ModJsonHelper.createShapedRecipe("small_staircase_" + name, "3", "missingtrees:stripped_" + name + "_log", "minecraft:stick", "\"# \",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("stairail_" + name, "3", "missingtrees:stripped_" + name + "_log", "minecraft:stick", "\"/#/\",", "\"/#/\"", "");
            ModJsonHelper.createShapedRecipe("small_stairail_" + name, "3", "missingtrees:stripped_" + name + "_log", "minecraft:stick", "\"/#/\"", "", "");
        }
        for (String name : BlockSetsHelper.NSS_WOOD_NAMES) {
            ModJsonHelper.createShapedRecipe("small_stairs_" + name, "3", "natures_spirit:" + name.replace("_nss", "") + "_planks", "\"#  \",", "\"## \"", "");
            ModJsonHelper.createShapedRecipe("small_halfstairs_" + name, "3", "natures_spirit:" + name.replace("_nss", "") + "_planks", "\"#  \",", "\" # \"", "");
            ModJsonHelper.createShapedRecipe("staircase_" + name, "3", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "minecraft:stick", "\"#  \",", "\"/# \",", "\" /#\"");
            ModJsonHelper.createShapedRecipe("small_staircase_" + name, "3", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "minecraft:stick", "\"# \",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("stairail_" + name, "3", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "minecraft:stick", "\"/#/\",", "\"/#/\"", "");
            ModJsonHelper.createShapedRecipe("small_stairail_" + name, "3", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "minecraft:stick", "\"/#/\"", "", "");
        }
    }
}

