/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder;

import com.oierbravo.createmechanicalextruder.components.extruder.andesite.ExtruderBlockEntity;
import com.oierbravo.createmechanicalextruder.components.extruder.brass.BrassExtruderBlockEntity;
import com.oierbravo.createmechanicalextruder.infrastructure.config.ModConfigs;
import com.oierbravo.createmechanicalextruder.infrastructure.data.ModDataGen;
import com.oierbravo.createmechanicalextruder.ponder.ModPonderPlugin;
import com.oierbravo.createmechanicalextruder.register.ModBlockEntities;
import com.oierbravo.createmechanicalextruder.register.ModBlocks;
import com.oierbravo.createmechanicalextruder.register.ModCreativeTabs;
import com.oierbravo.createmechanicalextruder.register.ModPartials;
import com.oierbravo.createmechanicalextruder.register.ModRecipes;
import com.oierbravo.mechanicals.utility.RegistrateLangBuilder;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="create_mechanical_extruder")
public class CreateMechanicalExtruder {
    private static final Logger LOGGER = LogManager.getLogger((String)"create_mechanical_extruder");
    public static IEventBus modEventBus;
    public static final CreateRegistrate REGISTRATE;

    public CreateMechanicalExtruder(IEventBus modEventBus, ModContainer modContainer) {
        REGISTRATE.registerEventListeners(modEventBus);
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        ModBlocks.register();
        ModBlockEntities.register();
        ModCreativeTabs.register(modEventBus);
        ModConfigs.register(modLoadingContext, modContainer);
        ModRecipes.register(modEventBus);
        modEventBus.addListener(ModDataGen::gatherData);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::doClientStuff);
        this.generateLangEntries();
    }

    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        ExtruderBlockEntity.registerCapabilities(event);
        BrassExtruderBlockEntity.registerCapabilities(event);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ModPartials.init();
        PonderIndex.addPlugin((PonderPlugin)new ModPonderPlugin());
        RenderType cutout = RenderType.cutoutMipped();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MECHANICAL_EXTRUDER.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MECHANICAL_BRASS_EXTRUDER.get()), (RenderType)cutout);
    }

    private void generateLangEntries() {
        new RegistrateLangBuilder("create_mechanical_extruder", CreateMechanicalExtruder.registrate()).addRaw("itemGroup.create_mechanical_extruder:main", "Create Mechanical Extruder").add("recipe.extruding", "Extruding recipe").add("goggles.bonks", "%1$s bonks").add("ponder.extruder.header", "Block generation").add("ponder.extruder.text_1", "The Extruder uses rotational force to generate blocks").add("ponder.extruder.text_2", "Generation depends on side & below blocks.").add("ponder.extruder.text_3", "When the process is done, the result can be obtained via Right-click").add("ponder.extruder.text_4", "The outputs can also be extracted by automation").add("ponder.extruder.text_5", "When a conbination of ingredient has multiple possible outcomes, the filter slot can specify it").add("ui.recipe_requirement.advanced.title", "Brass extruder");
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    public static Logger logger() {
        return LOGGER;
    }

    static {
        REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"create_mechanical_extruder").defaultCreativeTab(ModCreativeTabs.MAIN_TAB.getKey());
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

