/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.compat.jei;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.oierbravo.createmechanicalextruder.ModConstants;
import com.oierbravo.createmechanicalextruder.compat.jei.animations.AnimatedBrassExtruder;
import com.oierbravo.createmechanicalextruder.compat.jei.animations.AnimatedExtruder;
import com.oierbravo.createmechanicalextruder.components.extruder.recipe.ExtrudingRecipe;
import com.oierbravo.createmechanicalextruder.foundation.utility.ModLang;
import com.oierbravo.createmechanicalextruder.register.ModBlocks;
import com.oierbravo.createmechanicalextruder.register.ModRecipes;
import com.oierbravo.mechanicals.utility.LibLang;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidStack;

public class ExtrudingCategory
extends CreateRecipeCategory<ExtrudingRecipe> {
    public static final BlockPredicate ANY = new BlockPredicate(Optional.empty(), Optional.empty(), Optional.empty());
    private AnimatedExtruder extruder = new AnimatedExtruder();
    private AnimatedBrassExtruder brassExtruder = new AnimatedBrassExtruder();
    public static final ResourceLocation UID = ModConstants.asResource("extruding");
    public static final RecipeType<ExtrudingRecipe> TYPE = new RecipeType(UID, ExtrudingRecipe.class);
    public static final CreateRecipeCategory.Info<ExtrudingRecipe> INFO = new CreateRecipeCategory.Info(TYPE, (Component)ModLang.translate("recipe.extruding", new Object[0]).component(), (IDrawable)new EmptyBackground(177, 85), (IDrawable)new ItemIcon(() -> new ItemStack((ItemLike)ModBlocks.MECHANICAL_EXTRUDER.asItem())), ModRecipes::getAllHolders, List.of(() -> ModBlocks.MECHANICAL_EXTRUDER.asStack(), () -> ModBlocks.MECHANICAL_BRASS_EXTRUDER.asStack()));

    public ExtrudingCategory(CreateRecipeCategory.Info<ExtrudingRecipe> info) {
        super(info);
    }

    private List<ItemStack> unwrapItemstacks(HolderSet<Block> blockHolderSet) {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>(List.of());
        blockHolderSet.unwrap().ifRight(holders -> holders.forEach(blockHolder -> itemStackList.add(new ItemStack((ItemLike)blockHolder.value()))));
        return itemStackList;
    }

    public static boolean isAny(BlockPredicate predicate) {
        if (predicate == ANY) {
            return true;
        }
        return predicate.blocks().isEmpty() && predicate.properties().isEmpty() && predicate.nbt().isEmpty();
    }

    public static Set<Block> matchedBlocks(BlockPredicate predicate) {
        if (ExtrudingCategory.isAny(predicate)) {
            return Set.of();
        }
        ArrayList blocks = Lists.newArrayList();
        if (predicate.blocks().isPresent()) {
            Iterables.addAll((Collection)blocks, (Iterable)((Iterable)((HolderSet)predicate.blocks().get()).unwrap().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getOrCreateTag(arg_0), Function.identity())));
        }
        return blocks.stream().map(Holder::value).collect(Collectors.toSet());
    }

    public static Set<Fluid> matchedFluids(BlockPredicate predicate) {
        return ExtrudingCategory.matchedBlocks(predicate).stream().filter(LiquidBlock.class::isInstance).map(it -> it.defaultBlockState().getFluidState()).filter(Predicate.not(FluidState::isEmpty)).map(FluidState::getType).collect(Collectors.toSet());
    }

    public static Set<FluidStack> matchedFluidStacks(BlockPredicate predicate) {
        return ExtrudingCategory.matchedFluids(predicate).stream().map(fluid -> new FluidStack(fluid, 1000)).collect(Collectors.toSet());
    }

    public static List<ItemStack> matchedItemStacks(BlockPredicate predicate) {
        if (ExtrudingCategory.isAny(predicate)) {
            return List.of();
        }
        return ExtrudingCategory.matchedBlocks(predicate).stream().map(Block::asItem).filter(Predicate.not(Items.AIR::equals)).distinct().map(Item::getDefaultInstance).toList();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ExtrudingRecipe recipe, IFocusGroup focuses) {
        int slotIndex = 0;
        int initX = 1;
        int initY = 30;
        int distance = 42;
        for (int index = 0; index < 2; ++index) {
            for (int i = 0; i < ExtrudingCategory.matchedItemStacks((BlockPredicate)recipe.getBlockPredicateIngredients().get(index == 0)).size(); ++i) {
                builder.addSlot(RecipeIngredientRole.INPUT, initX + distance * slotIndex, initY).setBackground(ExtrudingCategory.getRenderedSlot(), -1, -1).addItemStacks(ExtrudingCategory.matchedItemStacks((BlockPredicate)recipe.getBlockPredicateIngredients().get(index == 0)));
                ++slotIndex;
            }
            Set<FluidStack> fluidIngredients = ExtrudingCategory.matchedFluidStacks((BlockPredicate)recipe.getBlockPredicateIngredients().get(index == 0));
            for (int i = 0; i < fluidIngredients.size(); ++i) {
                builder.addSlot(RecipeIngredientRole.INPUT, initX + distance * slotIndex, initY).setBackground(ExtrudingCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, fluidIngredients.stream().toList());
                ++slotIndex;
            }
        }
        if (recipe.getCatalyst().blocks().isPresent()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 21, 57).setBackground(ExtrudingCategory.getRenderedSlot(), -1, -1).addItemStacks(ExtrudingCategory.matchedItemStacks(recipe.getCatalyst()));
        }
        ProcessingOutput output = recipe.getResult();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 44, 67).setBackground(ExtrudingCategory.getRenderedSlot(), -1, -1).addRichTooltipCallback(ExtrudingCategory.addStochasticTooltip((ProcessingOutput)output)).addItemStack(recipe.getResultItem());
    }

    public void draw(ExtrudingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        if (recipe.isAdvanced()) {
            this.brassExtruder.draw(graphics, 42, 55);
        } else {
            this.extruder.draw(graphics, 42, 55);
        }
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 42, 50);
        this.drawRequirements(recipe, graphics, 63, 4);
    }

    protected void drawRequirements(ExtrudingRecipe recipe, GuiGraphics guiGraphics, int x, int y) {
        Minecraft minecraft = Minecraft.getInstance();
        Font fontRenderer = minecraft.font;
        int index = 0;
        int distance = 9;
        int offsetX = 5;
        int offsetY = 14;
        guiGraphics.drawString(fontRenderer, (Component)LibLang.translate((String)"ui.recipe.requirements.title", (Object[])new Object[0]).component().withStyle(new ChatFormatting[0]), x, y, -1, true);
        if (recipe.getRecipeRequirements().isEmpty() && !recipe.isAdvanced()) {
            guiGraphics.drawString(fontRenderer, (Component)LibLang.translate((String)"ui.recipe_requirement.none.tooltip", (Object[])new Object[0]).component().withStyle(new ChatFormatting[0]), x + offsetX, y + offsetY + distance * index, -8355712, false);
            return;
        }
        if (recipe.isAdvanced()) {
            guiGraphics.drawString(fontRenderer, (Component)ModLang.translate("ui.recipe_requirement.advanced.title", new Object[0]).component(), x + offsetX, y + offsetY + distance * index, -8355712, false);
            ++index;
        }
        List requirementComponents = recipe.getRequirementsTooltips();
        for (Pair pair : requirementComponents) {
            int oneLinerLenght = ((Component)pair.getSecond()).getString().length() + ((Component)pair.getSecond()).getString().length();
            if (oneLinerLenght < 19) {
                guiGraphics.drawString(fontRenderer, (Component)((Component)pair.getFirst()).plainCopy().append(" ").append((Component)pair.getSecond()), x + offsetX, y + offsetY + distance * index, -8355712, false);
                ++index;
                continue;
            }
            guiGraphics.drawString(fontRenderer, (Component)pair.getFirst(), x + offsetX, y + offsetY + distance * index, -8355712, false);
            guiGraphics.drawString(fontRenderer, (Component)pair.getSecond(), x + offsetX * 2, y + offsetY + distance * ++index, -8355712, false);
            ++index;
        }
    }
}

