/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.compat.jei.animations;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.oierbravo.createmechanicalextruder.components.extruder.AbstractExtruderBlock;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.tterrag.registrate.util.entry.BlockEntry;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.gui.GuiGraphics;

public abstract class AbstractAnimatedExtruder<E extends AbstractExtruderBlock<?>>
extends AnimatedKinetics {
    public int offset = 5;

    abstract BlockEntry<E> getBlock();

    abstract PartialModel getPolePartial();

    abstract Float getPoleOffset();

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        PoseStack matrixStack = guiGraphics.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)xOffset, (float)yOffset, 200.0f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-15.5f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        int scale = 24;
        this.blockElement(this.getBlock().getDefaultState()).scale((double)scale).render(guiGraphics);
        this.blockElement(this.getPolePartial()).atLocal(0.0, (double)(-this.getAnimatedHeadOffset() - this.getPoleOffset().floatValue()), 0.0).scale((double)scale).render(guiGraphics);
        matrixStack.popPose();
    }

    private float getAnimatedHeadOffset() {
        float cycle = (AnimationTickHolder.getRenderTime() - (float)(this.offset * 8)) % 30.0f;
        if (cycle < 10.0f) {
            float progress = cycle / 10.0f;
            return -(progress * progress * progress);
        }
        if (cycle < 15.0f) {
            return -1.0f;
        }
        if (cycle < 20.0f) {
            return -1.0f + (1.0f - (20.0f - cycle) / 5.0f);
        }
        return 0.0f;
    }
}

