/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.components.extruder;

import com.oierbravo.createmechanicalextruder.components.extruder.ExtruderFilterSlotPositioning;
import com.oierbravo.createmechanicalextruder.components.extruder.recipe.ExtrudingRecipe;
import com.oierbravo.createmechanicalextruder.foundation.utility.ModLang;
import com.oierbravo.createmechanicalextruder.infrastructure.config.ModConfigs;
import com.oierbravo.createmechanicalextruder.register.ModRecipes;
import com.oierbravo.mechanicals.foundation.blockEntity.behaviour.CycleBehavior;
import com.oierbravo.mechanicals.foundation.blockEntity.behaviour.RecipeRequirementsBehaviour;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeWithRequirements;
import com.oierbravo.mechanicals.foundation.recipe.RecipeRequirementType;
import com.oierbravo.mechanicals.register.MechanicalRecipeRequirementTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExtruderBlockEntity
extends KineticBlockEntity
implements CycleBehavior.CycleBehaviourSpecifics,
RecipeRequirementsBehaviour.RecipeRequirementsSpecifics<ExtrudingRecipe> {
    private CycleBehavior extrudingBehaviour;
    private FilteringBehaviour filtering;
    public RecipeRequirementsBehaviour<ExtrudingRecipe> recipeRequirementsBehaviour;
    public float headOffset = 0.44f;
    public final ItemStackHandler outputInventory = new ItemStackHandler(1){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        protected void onContentsChanged(int slot) {
            AbstractExtruderBlockEntity.this.setChanged();
            assert (AbstractExtruderBlockEntity.this.level != null);
            AbstractExtruderBlockEntity.this.level.sendBlockUpdated(AbstractExtruderBlockEntity.this.worldPosition, AbstractExtruderBlockEntity.this.getBlockState(), AbstractExtruderBlockEntity.this.getBlockState(), 3);
        }
    };
    private final Map<Direction, Direction> directionLefttBlockMap = Map.of(Direction.NORTH, Direction.WEST, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.EAST, Direction.SOUTH);
    private final Map<Direction, Direction> directionRightBlockMap = Map.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.WEST, Direction.SOUTH, Direction.EAST, Direction.NORTH);

    public abstract boolean isAdvancedMachine();

    public AbstractExtruderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public IItemHandler getItemHandler() {
        return this.outputInventory;
    }

    public boolean isSpeedRequirementFulfilled() {
        Optional<ExtrudingRecipe> recipe = this.getRecipe();
        if (recipe.isEmpty()) {
            return super.isSpeedRequirementFulfilled();
        }
        if (recipe.get().getRequirement((RecipeRequirementType)MechanicalRecipeRequirementTypes.MIN_SPEED.get()).isPresent()) {
            return ((IRecipeRequirement)recipe.get().getRequirement((RecipeRequirementType)MechanicalRecipeRequirementTypes.MIN_SPEED.get()).get()).test(this.level, (BlockEntity)this);
        }
        if (recipe.get().getRequirement((RecipeRequirementType)MechanicalRecipeRequirementTypes.MAX_SPEED.get()).isPresent()) {
            return ((IRecipeRequirement)recipe.get().getRequirement((RecipeRequirementType)MechanicalRecipeRequirementTypes.MAX_SPEED.get()).get()).test(this.level, (BlockEntity)this);
        }
        return super.isSpeedRequirementFulfilled();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new ExtruderFilterSlotPositioning()).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        int cycleTime = (Integer)ModConfigs.server().mechanicalExtruder.cycleTime.get();
        this.extrudingBehaviour = new CycleBehavior((SmartBlockEntity)this, cycleTime, true);
        behaviours.add((BlockEntityBehaviour)this.extrudingBehaviour);
        this.recipeRequirementsBehaviour = new RecipeRequirementsBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.recipeRequirementsBehaviour);
    }

    public CycleBehavior getExtrudingBehaviour() {
        return this.extrudingBehaviour;
    }

    public RecipeRequirementsBehaviour<ExtrudingRecipe> getRecipeConditionsBehaviour() {
        return this.recipeRequirementsBehaviour;
    }

    public void onCycleCompleted() {
    }

    public void onOperationCompletd() {
    }

    public float getKineticSpeed() {
        return this.getSpeed();
    }

    public boolean tryProcess(boolean simulate) {
        Optional<ExtrudingRecipe> recipe = this.getRecipe();
        if (recipe.isEmpty()) {
            this.recipeRequirementsBehaviour.cleanRequirements();
            return false;
        }
        ExtrudingRecipe extrudingRecipe = recipe.get();
        if (!this.recipeRequirementsBehaviour.checkRequirements((IRecipeWithRequirements)extrudingRecipe)) {
            return false;
        }
        if (simulate) {
            return true;
        }
        ItemStack output = extrudingRecipe.getResult().rollOutput();
        if (this.outputInventory.getStackInSlot(0).isEmpty()) {
            this.outputInventory.setStackInSlot(0, output);
        } else if (this.outputInventory.getStackInSlot(0).is(extrudingRecipe.getResult().getStack().getItem())) {
            this.outputInventory.getStackInSlot(0).grow(output.getCount());
        }
        if (this.isAdvancedMachine()) {
            for (BlockPredicate blockPredicate : extrudingRecipe.getConsumeBlocksList()) {
                if (blockPredicate.matches(this.getLeftBlockInWorld())) {
                    this.consumeBlock(this.getLeftBlockInWorld());
                }
                if (!blockPredicate.matches(this.getRightBlockInWorld())) continue;
                this.consumeBlock(this.getRightBlockInWorld());
            }
        }
        return true;
    }

    private void consumeBlock(BlockInWorld blockInWorld) {
        if (Objects.requireNonNull(this.getLevel()).isClientSide) {
            return;
        }
        this.getLevel().setBlock(blockInWorld.getPos(), Blocks.AIR.defaultBlockState(), 3);
    }

    public void playSound() {
        AllSoundEvents.MECHANICAL_PRESS_ACTIVATION_ON_BELT.playOnServer(this.level, (Vec3i)this.worldPosition);
    }

    public int getCycles() {
        if (this.getRecipe().isEmpty()) {
            return 1;
        }
        return this.getRecipe().get().getRequiredBonks();
    }

    public float getRenderedPoleOffset(float partialTicks) {
        if (!this.extrudingBehaviour.isRunning()) {
            return 0.0f;
        }
        int runningTicks = Math.abs(this.extrudingBehaviour.getRunningTicks());
        float ticks = Mth.lerp((float)partialTicks, (float)this.extrudingBehaviour.getPrevRunningTicks(), (float)runningTicks);
        if (runningTicks < this.extrudingBehaviour.getCycleTime() * 2 / 3) {
            return (float)Mth.clamp((double)Math.pow(ticks / (float)this.extrudingBehaviour.getCycleTime() * 2.0f, 3.0), (double)0.0, (double)1.0);
        }
        return Mth.clamp((float)(((float)this.extrudingBehaviour.getCycleTime() - ticks) / (float)this.extrudingBehaviour.getCycleTime() * 3.0f), (float)0.0f, (float)1.0f);
    }

    public Optional<ExtrudingRecipe> getRecipe() {
        List<ExtrudingRecipe> matchingRequirementRecipes;
        List<ExtrudingRecipe> matchingRecipes = ModRecipes.findRecipesWithMatchingIngredients(this);
        if (matchingRecipes.isEmpty()) {
            return Optional.empty();
        }
        if (!this.isAdvancedMachine()) {
            matchingRecipes = matchingRecipes.stream().filter(ExtrudingRecipe::notAdvanced).toList();
        }
        if (!(matchingRequirementRecipes = matchingRecipes.stream().filter(extrudingRecipe -> extrudingRecipe.meetsRequirements((BlockEntity)this)).toList()).isEmpty()) {
            return matchingRequirementRecipes.stream().findFirst();
        }
        return matchingRecipes.stream().findAny();
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public FilteringBehaviour getFilter() {
        return this.filtering;
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.put("OutputInventory", (Tag)this.outputInventory.serializeNBT(registries));
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.outputInventory.deserializeNBT(registries, compound.getCompound("OutputInventory"));
        super.read(compound, registries, clientPacket);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean addedRequirements;
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        int currentBonks = this.extrudingBehaviour.getCurrentCycle();
        if (currentBonks > 0 && this.getCycles() > 1) {
            ModLang.translate("goggles.bonks", currentBonks).forGoggles(tooltip, 1);
            added = true;
        }
        if (addedRequirements = this.recipeRequirementsBehaviour.addToGoggleTooltip(tooltip, isPlayerSneaking, added)) {
            added = true;
        }
        return added;
    }

    public BlockInWorld getLeftBlockInWorld() {
        BlockPos currentPos = this.getBlockPos();
        Direction localDir = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        assert (this.level != null);
        return new BlockInWorld((LevelReader)this.level, currentPos.relative(this.directionLefttBlockMap.get(localDir)), false);
    }

    private BlockInWorld getRightBlockInWorld() {
        BlockPos currentPos = this.getBlockPos();
        Direction localDir = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        assert (this.level != null);
        return new BlockInWorld((LevelReader)this.level, currentPos.relative(this.directionRightBlockMap.get(localDir)), false);
    }

    public BlockInWorld getCatalystBlock() {
        assert (this.level != null);
        return new BlockInWorld((LevelReader)this.level, this.getBlockPos().below(), false);
    }

    public boolean hasEnoughOutputSpace() {
        if (this.outputInventory.getStackInSlot(0).getCount() == this.outputInventory.getStackInSlot(0).getMaxStackSize()) {
            return false;
        }
        return this.outputInventory.getStackInSlot(0).isEmpty() || this.outputInventory.getStackInSlot(0).is(this.getRecipe().get().getResult().getStack().getItem());
    }

    public boolean matchesIngredients(ExtrudingRecipe extrudingRecipe) {
        return extrudingRecipe.match(this);
    }

    public boolean matchesIngredients(RecipeHolder<ExtrudingRecipe> extrudingRecipeRecipeHolder) {
        return this.matchesIngredients((ExtrudingRecipe)extrudingRecipeRecipeHolder.value());
    }

    public boolean matchRequirements(RecipeHolder<ExtrudingRecipe> extrudingRecipeRecipeHolder) {
        return ((ExtrudingRecipe)extrudingRecipeRecipeHolder.value()).meetsRequirements((BlockEntity)this);
    }

    public Couple<BlockInWorld> getSideBlocks() {
        return Couple.create((Object)this.getLeftBlockInWorld(), (Object)this.getRightBlockInWorld());
    }

    class ExtruderValueBox
    extends ValueBoxTransform.Sided {
        ExtruderValueBox(AbstractExtruderBlockEntity this$0) {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)12.0, (double)15.75);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.getAxis().isHorizontal();
        }
    }
}

