/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.components.extruder;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.oierbravo.createmechanicalextruder.components.extruder.AbstractExtruderBlockEntity;
import com.oierbravo.createmechanicalextruder.register.ModPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractExtruderRenderer<EXB extends AbstractExtruderBlockEntity>
extends KineticBlockEntityRenderer<EXB> {
    public AbstractExtruderRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected abstract PartialModel getPoleModel();

    public boolean shouldRenderOffScreen(EXB be) {
        return true;
    }

    protected void renderSafe(EXB be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        FilteringRenderer.renderOnBlockEntity(be, (float)partialTicks, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        VertexConsumer vb = buffer.getBuffer(RenderType.solid());
        BlockState blockState = be.getBlockState();
        float renderedHeadOffset = ((AbstractExtruderBlockEntity)((Object)be)).getRenderedPoleOffset(partialTicks);
        SuperByteBuffer poleRender = CachedBuffers.partialFacing((PartialModel)ModPartials.MECHANICAL_EXTRUDER_POLE, (BlockState)blockState, (Direction)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        ((SuperByteBuffer)poleRender.translate(0.0f, -renderedHeadOffset + ((AbstractExtruderBlockEntity)((Object)be)).headOffset, 0.0f)).light(light).renderInto(ms, vb);
        SuperByteBuffer superBuffer = CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)blockState, (Direction)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite());
        AbstractExtruderRenderer.standardKineticRotationTransform((SuperByteBuffer)superBuffer, be, (int)light).renderInto(ms, vb);
    }

    protected SuperByteBuffer getRotatedModel(EXB be, BlockState state) {
        return CachedBuffers.partial((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)state);
    }
}

