/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.components.extruder.recipe;

import com.oierbravo.createmechanicalextruder.components.extruder.recipe.ExtrudingRecipe;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import net.createmod.catnip.data.Couple;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class ExtrudingRecipeBuilder
extends AbstractMechanicalRecipeBuilder<ExtrudingRecipe, ExtrudingRecipe.ExtrudingRecipeParams, ExtrudingRecipeBuilder> {
    public ExtrudingRecipeBuilder(ResourceLocation id) {
        this.params = new ExtrudingRecipe.ExtrudingRecipeParams(id);
    }

    public ExtrudingRecipeBuilder withSingleBlockIngredient(Block ingredient) {
        return this.withBlockIngredients(ingredient, ingredient);
    }

    public ExtrudingRecipeBuilder withBlockIngredients(Block firstBlockIngredients, Block secondBlockIngredient) {
        return this.withBlockIngredients((Couple<BlockPredicate>)Couple.create((Object)BlockPredicate.Builder.block().of(new Block[]{firstBlockIngredients}).build(), (Object)BlockPredicate.Builder.block().of(new Block[]{secondBlockIngredient}).build()));
    }

    public ExtrudingRecipeBuilder withBlockIngredients(BlockPredicate firstBlockIngredients, BlockPredicate secondBlockIngredient) {
        return this.withBlockIngredients((Couple<BlockPredicate>)Couple.create((Object)firstBlockIngredients, (Object)secondBlockIngredient));
    }

    public ExtrudingRecipeBuilder withBlockIngredients(Couple<BlockPredicate> blockIngredients) {
        ((ExtrudingRecipe.ExtrudingRecipeParams)this.params).blockPredicateIngredients = blockIngredients;
        return this;
    }

    public ExtrudingRecipeBuilder withSingleItemOutput(ItemStack output) {
        ((ExtrudingRecipe.ExtrudingRecipeParams)this.params).result = new ProcessingOutput(output, 1.0f);
        return this;
    }

    public ExtrudingRecipeBuilder withSingleItemOutput(ProcessingOutput output) {
        ((ExtrudingRecipe.ExtrudingRecipeParams)this.params).result = output;
        return this;
    }

    public ExtrudingRecipeBuilder withCatalyst(Block catalyst) {
        return this.withCatalyst(BlockPredicate.Builder.block().of(new Block[]{catalyst}).build());
    }

    public ExtrudingRecipeBuilder withCatalyst(BlockPredicate catalyst) {
        ((ExtrudingRecipe.ExtrudingRecipeParams)this.params).catalyst = catalyst;
        return this;
    }

    public ExtrudingRecipeBuilder requiredBonks(int requiredBonks) {
        ((ExtrudingRecipe.ExtrudingRecipeParams)this.params).requiredBonks = requiredBonks;
        return this;
    }

    public ExtrudingRecipeBuilder isAdvanced(boolean value) {
        ((ExtrudingRecipe.ExtrudingRecipeParams)this.params).isAdvanced = value;
        return this;
    }

    public ExtrudingRecipeBuilder consumeBlocks(Couple<Boolean> pConsumeBlocks) {
        ((ExtrudingRecipe.ExtrudingRecipeParams)this.params).consumeBlocks = pConsumeBlocks;
        return this;
    }

    public ExtrudingRecipeBuilder consumeBlocksFirstBlock() {
        ((ExtrudingRecipe.ExtrudingRecipeParams)this.params).consumeBlocks.setFirst((Object)true);
        return this;
    }

    public ExtrudingRecipeBuilder consumeBlocksSecondBlock() {
        ((ExtrudingRecipe.ExtrudingRecipeParams)this.params).consumeBlocks.setSecond((Object)true);
        return this;
    }

    public ExtrudingRecipeBuilder() {
    }

    public ExtrudingRecipe build() {
        return new ExtrudingRecipe((ExtrudingRecipe.ExtrudingRecipeParams)this.params);
    }

    public ExtrudingRecipeBuilder create(ResourceLocation resourceLocation) {
        return new ExtrudingRecipeBuilder(resourceLocation);
    }

    public ExtrudingRecipeBuilder withSingleItemOutput(NonNullList<ProcessingOutput> results) {
        if (results.stream().findFirst().isPresent()) {
            ((ExtrudingRecipe.ExtrudingRecipeParams)this.params).result = (ProcessingOutput)results.stream().findFirst().get();
        }
        return this;
    }
}

