/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.infrastructure.data;

import com.oierbravo.createmechanicalextruder.ModConstants;
import com.oierbravo.createmechanicalextruder.components.extruder.recipe.ExtrudingRecipeBuilder;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.oierbravo.mechanicals.foundation.recipe.requirements.BiomeTagRequirement;
import com.oierbravo.mechanicals.foundation.recipe.requirements.MaxSpeedRequirement;
import com.oierbravo.mechanicals.foundation.recipe.requirements.MaxYRequirement;
import com.oierbravo.mechanicals.foundation.recipe.requirements.MinYRequirement;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ExtrudingRecipeGen
extends RecipeProvider {
    public ExtrudingRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        this.create("cobblestone", Items.COBBLESTONE).withBlockIngredients(Blocks.WATER, Blocks.LAVA).save(recipeOutput);
        ((ExtrudingRecipeBuilder)((ExtrudingRecipeBuilder)this.create("granite", Items.GRANITE).withBlockIngredients(Blocks.WATER, Blocks.LAVA).withRequirement((IRecipeRequirement)MinYRequirement.of((Integer)0))).withRequirement((IRecipeRequirement)MaxYRequirement.of((Integer)60))).save(recipeOutput);
        ((ExtrudingRecipeBuilder)((ExtrudingRecipeBuilder)this.create("diorite", Items.DIORITE).withBlockIngredients(Blocks.WATER, Blocks.LAVA).withRequirement((IRecipeRequirement)MinYRequirement.of((Integer)0))).withRequirement((IRecipeRequirement)MaxYRequirement.of((Integer)60))).save(recipeOutput);
        ((ExtrudingRecipeBuilder)((ExtrudingRecipeBuilder)this.create("andesite", Items.ANDESITE).withBlockIngredients(Blocks.WATER, Blocks.LAVA).withRequirement((IRecipeRequirement)MinYRequirement.of((Integer)0))).withRequirement((IRecipeRequirement)MaxYRequirement.of((Integer)60))).save(recipeOutput);
        this.create("sandstone", Items.SANDSTONE).withBlockIngredients(Blocks.WATER, Blocks.SAND).save(recipeOutput);
        this.create("basalt", Items.BASALT).withBlockIngredients(Blocks.BLUE_ICE, Blocks.LAVA).withCatalyst(Blocks.SOUL_SOIL).save(recipeOutput);
        this.create("crimsite", (Block)AllPaletteStoneTypes.CRIMSITE.getBaseBlock().get()).withBlockIngredients(Blocks.IRON_BLOCK, Blocks.LAVA).withCatalyst(Blocks.SOUL_SOIL).save(recipeOutput);
        this.create("ochrum", (Block)AllPaletteStoneTypes.OCHRUM.getBaseBlock().get()).withBlockIngredients(Blocks.GOLD_BLOCK, Blocks.LAVA).save(recipeOutput);
        this.create("asurine", (Block)AllPaletteStoneTypes.ASURINE.getBaseBlock().get()).withBlockIngredients(Blocks.LAPIS_BLOCK, Blocks.LAVA).save(recipeOutput);
        this.create("limestone", (Block)AllPaletteStoneTypes.LIMESTONE.getBaseBlock().get()).withBlockIngredients(this.block("create:honey"), Blocks.LAVA).save(recipeOutput);
        this.create("scoria", (Block)AllPaletteStoneTypes.SCORIA.getBaseBlock().get()).withBlockIngredients(Blocks.LAVA, this.block("create:chocolate")).save(recipeOutput);
        ((ExtrudingRecipeBuilder)this.create("netherack", Items.NETHERRACK).withBlockIngredients(Blocks.BLUE_ICE, Blocks.LAVA).withRequirement((IRecipeRequirement)BiomeTagRequirement.of((TagKey)BiomeTags.IS_NETHER))).save(recipeOutput);
        ((ExtrudingRecipeBuilder)this.create("end_stone", Items.END_STONE).withBlockIngredients(Blocks.BLUE_ICE, Blocks.LAVA).withRequirement((IRecipeRequirement)BiomeTagRequirement.of((TagKey)BiomeTags.IS_END))).save(recipeOutput);
        ((ExtrudingRecipeBuilder)((ExtrudingRecipeBuilder)this.create("deepslate", Items.DEEPSLATE).withBlockIngredients(Blocks.WATER, Blocks.LAVA).withRequirement((IRecipeRequirement)MaxYRequirement.of((Integer)0))).withRequirement((IRecipeRequirement)MaxSpeedRequirement.of((Float)Float.valueOf(16.0f)))).save(recipeOutput);
        ((ExtrudingRecipeBuilder)this.create("obsidian", Items.OBSIDIAN).withBlockIngredients(Blocks.WATER, Blocks.LAVA).withRequirement((IRecipeRequirement)MaxSpeedRequirement.of((Float)Float.valueOf(4.0f)))).save(recipeOutput);
        ((ExtrudingRecipeBuilder)this.create("snow_block", Items.SNOW_BLOCK).withSingleBlockIngredient(Blocks.WATER).withRequirement((IRecipeRequirement)MinYRequirement.of((Integer)150))).save(recipeOutput);
        this.createAdvanced("advanced_obsidian", Items.OBSIDIAN).withBlockIngredients(Blocks.WATER, Blocks.LAVA).consumeBlocksSecondBlock().withCatalyst(Blocks.OBSIDIAN).save(recipeOutput);
        this.createAdvanced("advanced_netherrack", Items.NETHERRACK).withBlockIngredients(Blocks.BLUE_ICE, Blocks.LAVA).consumeBlocksSecondBlock().withCatalyst(Blocks.NETHERRACK).save(recipeOutput);
        this.createAdvanced("advanced_end_stone", Items.END_STONE).withBlockIngredients(Blocks.BLUE_ICE, Blocks.LAVA).consumeBlocksSecondBlock().withCatalyst(Blocks.END_STONE).save(recipeOutput);
    }

    private Block block(String resourceLocationString) {
        return this.block(ResourceLocation.parse((String)resourceLocationString));
    }

    private Block block(ResourceLocation resourceLocation) {
        return (Block)BuiltInRegistries.BLOCK.get(resourceLocation);
    }

    private ExtrudingRecipeBuilder create(String id, Block output) {
        return new ExtrudingRecipeBuilder(ModConstants.asResource("extruding/" + id)).withSingleItemOutput(new ProcessingOutput(new ItemStack((ItemLike)output), 1.0f));
    }

    private ExtrudingRecipeBuilder create(String id, Item output) {
        return new ExtrudingRecipeBuilder(ModConstants.asResource("extruding/" + id)).withSingleItemOutput(new ProcessingOutput(new ItemStack((ItemLike)output), 1.0f));
    }

    private ExtrudingRecipeBuilder createAdvanced(String id, Item output) {
        return new ExtrudingRecipeBuilder(ModConstants.asResource("extruding/" + id)).withSingleItemOutput(new ProcessingOutput(new ItemStack((ItemLike)output), 1.0f)).isAdvanced(true);
    }

    public final String getName() {
        return "Mechanical extruders's extruding recipes.";
    }
}

