/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.register;

import com.oierbravo.createmechanicalextruder.ModConstants;
import com.oierbravo.createmechanicalextruder.components.extruder.AbstractExtruderBlockEntity;
import com.oierbravo.createmechanicalextruder.components.extruder.recipe.ExtrudingRecipe;
import com.oierbravo.createmechanicalextruder.components.extruder.recipe.ExtrudingRecipeSerializer;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModRecipes {
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"create_mechanical_extruder");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"create_mechanical_extruder");
    public static final Supplier<RecipeType<ExtrudingRecipe>> EXTRUDING_TYPE = RECIPE_TYPES.register("extruding_type", () -> RecipeType.simple((ResourceLocation)ModConstants.asResource("extruding_type")));
    public static final Supplier<ExtrudingRecipeSerializer> EXTRUDING_SERIALIZER = SERIALIZERS.register("extruding", () -> ExtrudingRecipeSerializer.INSTANCE);

    public static void register(IEventBus eventBus) {
        SERIALIZERS.register(eventBus);
        RECIPE_TYPES.register(eventBus);
    }

    public static <EXB extends AbstractExtruderBlockEntity> List<ExtrudingRecipe> findRecipesWithMatchingIngredients(EXB extruder) {
        if (Objects.requireNonNull(extruder.getLevel()).isClientSide()) {
            return List.of();
        }
        return extruder.getLevel().getRecipeManager().getAllRecipesFor((RecipeType)ExtrudingRecipe.Type.INSTANCE).stream().filter(extruder::matchesIngredients).map(RecipeHolder::value).toList();
    }

    public static List<RecipeHolder<ExtrudingRecipe>> getAllHolders() {
        return Objects.requireNonNull(Minecraft.getInstance().getConnection()).getRecipeManager().getAllRecipesFor((RecipeType)ExtrudingRecipe.Type.INSTANCE);
    }
}

