/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition;

import carpet.settings.ParsedRule;
import carpet.settings.Rule;
import carpet.settings.Validator;
import net.minecraft.class_2168;
import org.jetbrains.annotations.Nullable;

public final class CarpetAyakaSettings {
    public static final String AYAKA = "Ayaka";
    public static final String REINTRODUCE = "reintroduce";
    public static final String CHEAT = "cheat";
    public static final String BOT = "BOT";
    @Rule(category={"Ayaka", "survival", "cheat"}, desc="Stops operators from using /kill, /clear, /effect, /item and /difficulty", extra={"Only active when Carpet Tis Addition is loaded and opPlayerNoCheat is set to true"})
    public static boolean betterOpPlayerNoCheat = false;
    @Rule(category={"Ayaka", "command", "cheat"}, desc="Enables /address and /ad to manipulate and teleport to shared waypoints")
    public static boolean commandAddress = false;
    @Rule(category={"Ayaka", "command", "cheat"}, desc="Enables /c to switch your gamemode between spectator and survival")
    public static boolean commandC = false;
    @Rule(category={"Ayaka", "command", "cheat"}, desc="Enables /gohome to teleport right back to your spawn point")
    public static boolean commandGoHome = false;
    @Rule(category={"Ayaka", "command"}, desc="Enables /killitem to clear dropped items with one shot")
    public static boolean commandKillItem = false;
    @Rule(category={"Ayaka", "command", "cheat"}, desc="Enables /tpt to teleport to another player in your server")
    public static boolean commandTpt = false;
    @Rule(category={"Ayaka", "feature"}, desc="Disables natural spawning of bats")
    public static boolean disableBatSpawning = false;
    @Rule(category={"Ayaka", "experimental", "BOT"}, desc="Forces fake players to spawn in offline mode", extra={"(1.16+) Only active when allowSpawningOfflinePlayers is set to true"})
    public static boolean fakePlayerForceOffline = false;
    @Rule(category={"Ayaka", "experimental", "bugfix", "BOT"}, desc="Fixes the bug that fake players are not reconnected after retracements", extra={"Only active when Gca is loaded and fakePlayerResident is set to true"})
    public static boolean fakePlayerResidentBackupFix = false;
    @Rule(category={"Ayaka", "feature"}, desc="Prevents foxes from picking up dropped items")
    public static boolean foxNoPickupItem = false;
    @Rule(category={"Ayaka", "experimental"}, desc="Modifies the ticks before an item entity is discarded", extra={"Set to 0 (or 6000) to use vanilla value", "Max value 72000 (an hour)"}, validate={ItemDiscardAgeValidator.class}, options={"0", "3000", "3600", "6000", "12000", "72000"}, strict=false)
    public static int itemDiscardAge = 0;
    @Rule(category={"Ayaka", "command"}, desc="Seconds to wait before clearing the items", validate={UnsignedIntegerValidator.class}, options={"0", "5", "10", "30"}, strict=false)
    public static int killItemAwaitSeconds = 5;
    @Rule(category={"Ayaka", "experimental"}, desc="Overwrites the max player count in a server", extra={"Set to 0 to use vanilla value"}, validate={UnsignedIntegerValidator.class}, options={"0", "8", "10", "20", "50", "100"}, strict=false)
    public static int maxPlayersOverwrite = 0;

    private static final class ItemDiscardAgeValidator
    extends Validator<Integer> {
        public static final int ITEM_DISCARD_AGE_MAX_VALUE = 72000;

        private ItemDiscardAgeValidator() {
        }

        public Integer validate(@Nullable class_2168 source, ParsedRule<Integer> changingRule, Integer newValue, String userInput) {
            return newValue < 0 || newValue > 72000 ? null : newValue;
        }

        public String description() {
            return "Must not be negative or larger than 72000";
        }
    }

    private static final class UnsignedIntegerValidator
    extends Validator<Integer> {
        private UnsignedIntegerValidator() {
        }

        public Integer validate(@Nullable class_2168 source, ParsedRule<Integer> changingRule, Integer newValue, String userInput) {
            return newValue < 0 ? null : newValue;
        }

        public String description() {
            return "Must not be negative";
        }
    }
}

