/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.commands.killitem;

import com.ayakacraft.carpetayakaaddition.CarpetAyakaServer;
import com.ayakacraft.carpetayakaaddition.CarpetAyakaSettings;
import com.ayakacraft.carpetayakaaddition.utils.CommandUtils;
import com.ayakacraft.carpetayakaaddition.utils.EntityUtils;
import com.ayakacraft.carpetayakaaddition.utils.TickTask;
import com.ayakacraft.carpetayakaaddition.utils.text.TextUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.LinkedList;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;

public final class KillItemCommand {
    private static int killItem(CommandContext<class_2168> context) {
        if (CarpetAyakaSettings.killItemAwaitSeconds == 0) {
            return KillItemCommand.killItem0((class_2168)context.getSource());
        }
        CarpetAyakaServer.INSTANCE.addTickTask(new KillItemTickTask(CarpetAyakaServer.INSTANCE, CarpetAyakaSettings.killItemAwaitSeconds, (class_2168)context.getSource()));
        return 1;
    }

    private static int killItem0(class_2168 source) {
        LinkedList targets = new LinkedList();
        MinecraftServer server = source.method_9211();
        server.method_3738().forEach(world -> targets.addAll(world.method_18198(class_1299.field_6052, itemEntity -> true)));
        if (targets.isEmpty()) {
            TextUtils.broadcastToPlayers(server, (class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.killitem.none", new Object[0]), false);
            return 0;
        }
        targets.forEach(EntityUtils::kill);
        if (targets.size() == 1) {
            TextUtils.broadcastToPlayers(server, (class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.killitem.single", new Object[0]), false);
        } else {
            TextUtils.broadcastToPlayers(server, (class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.killitem.multiple", targets.size()), false);
        }
        return targets.size();
    }

    private static int cancel(CommandContext<class_2168> context) {
        int i = CarpetAyakaServer.INSTANCE.cancelTickTasksMatching(tickTask -> tickTask instanceof KillItemTickTask);
        class_2168 source = (class_2168)context.getSource();
        if (i == 0) {
            CommandUtils.sendFeedback(source, (class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.killitem.cancel.none", new Object[0]), false);
        } else if (i == 1) {
            CommandUtils.sendFeedback(source, (class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.killitem.cancel.single", new Object[0]), false);
        } else {
            CommandUtils.sendFeedback(source, (class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.killitem.cancel.multiple", new Object[0]), false);
        }
        return i;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"killitem").requires(source -> CommandUtils.checkPermission(source, !CarpetAyakaSettings.commandKillItem, false))).executes(KillItemCommand::killItem)).then(class_2170.method_9247((String)"cancel").executes(KillItemCommand::cancel)));
    }

    private static final class KillItemTickTask
    extends TickTask {
        private final int awaitSeconds;
        private final class_2168 source;
        private int ticks;

        public KillItemTickTask(CarpetAyakaServer modServer, int awaitSeconds, class_2168 source) {
            super(modServer);
            this.awaitSeconds = awaitSeconds;
            this.ticks = awaitSeconds * 20;
            this.source = source;
        }

        @Override
        public void start() {
            TextUtils.broadcastToPlayers(this.mcServer, TextUtils.tr(this.source, "command.carpet-ayaka-addition.killitem.task.start", this.awaitSeconds).method_10854(class_124.field_1065), false);
        }

        @Override
        public void tick() {
            if (--this.ticks <= 0) {
                KillItemCommand.killItem0(this.source);
                this.finish();
            }
        }
    }
}

