/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.utils.text;

import com.ayakacraft.carpetayakaaddition.utils.text.TextFormatter;
import com.ayakacraft.carpetayakaaddition.utils.translation.Translator;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2554;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Contract;

public final class TextUtils {
    private static class_2554 literal(String str) {
        return new class_2585(str);
    }

    private static class_2554 translatable(String key, Object ... args) {
        return new class_2588(key, args);
    }

    private static class_2558 runCommand(String cmd) {
        return new class_2558(class_2558.class_2559.field_11750, cmd);
    }

    private static class_2568 showText(class_2561 txt) {
        return new class_2568(class_2568.class_2569.field_11762, txt);
    }

    @Contract(pure=true)
    public static class_2554 format(String str, Object ... args) {
        return TextFormatter.format(str, args);
    }

    @Contract(pure=true)
    public static class_2554 enter() {
        return new class_2585(System.lineSeparator());
    }

    @Contract(pure=true)
    public static class_2554 empty() {
        return new class_2585("");
    }

    @Contract(pure=true)
    public static <T> class_2554 join(Collection<T> elements, class_2561 separator, Function<T, class_2561> transformer) {
        class_2554 mutableText = TextUtils.empty();
        boolean bl = false;
        for (T object : elements) {
            if (bl) {
                mutableText.method_10852(separator);
            }
            mutableText.method_10852(transformer.apply(object));
            bl = true;
        }
        return mutableText;
    }

    @Contract(pure=true)
    public static class_2554 joinObj(Object ... objects) {
        return TextUtils.join(Arrays.asList(objects), (class_2561)TextUtils.empty(), o -> {
            if (o instanceof Supplier) {
                o = ((Supplier)o).get();
            }
            return o instanceof class_2561 ? (class_2561)o : new class_2585(String.valueOf(o));
        });
    }

    public static void sendMessageToServer(MinecraftServer server, class_2561 text) {
        server.method_9203(text);
    }

    public static void broadcast(MinecraftServer server, class_2561 txt, boolean overlay) {
        TextUtils.sendMessageToServer(server, txt);
        server.method_3760().method_14571().forEach(p -> p.method_7353(txt, overlay));
    }

    public static void broadcast(MinecraftServer server, class_2561 textForServer, Function<class_3222, class_2561> textFunction, boolean overlay) {
        TextUtils.sendMessageToServer(server, textForServer);
        server.method_3760().method_14571().forEach(player -> {
            class_2561 t = (class_2561)textFunction.apply((class_3222)player);
            if (t != null) {
                player.method_7353(t, overlay);
            }
        });
    }

    public static void broadcastTranslatable(MinecraftServer server, boolean overlay, Translator tr, Object ... args) {
        TextUtils.broadcast(server, (class_2561)tr.tr(null, args), p -> tr.tr((class_3222)p, null, args), overlay);
    }

    @Contract(mutates="param1")
    public static class_2554 withCommand(class_2554 text, String command) {
        text.method_10859(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, command)).method_10949(new class_2568(class_2568.class_2569.field_11762, (class_2561)new class_2585(command))));
        return text;
    }
}

