/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.logging.loadedchunks;

import com.ayakacraft.carpetayakaaddition.logging.AbstractAyakaHUDLoggerSingleLine;
import com.ayakacraft.carpetayakaaddition.logging.AyakaLoggerRegistry;
import com.ayakacraft.carpetayakaaddition.mixin.logging.loadedchunks.ThreadedAnvilChunkStorageAccessor;
import com.ayakacraft.carpetayakaaddition.utils.InitializedPerTick;
import com.ayakacraft.carpetayakaaddition.utils.text.TextUtils;
import com.ayakacraft.carpetayakaaddition.utils.translation.Translator;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.LinkedList;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_5250;

public class LoadedChunksLogger
extends AbstractAyakaHUDLoggerSingleLine
implements InitializedPerTick {
    private static final String[] OPTIONS = new String[]{"all", "dynamic", "overworld", "the_nether", "the_end"};
    private static final short DEFAULT_INDEX = 1;
    private static final String FORMAT = "%d/%d";
    private static final class_2561 SEPARATOR = new class_2585("/").method_27692(class_124.field_1080);
    private static final class_2960 OVW_ID = new class_2960("overworld");
    private static final class_2960 NETHER_ID = new class_2960("minecraft:the_nether");
    private static final class_2960 END_ID = new class_2960("minecraft:the_end");
    public static final String NAME = "loadedChunks";
    public static final LoadedChunksLogger INSTANCE;
    public static final Translator TR;
    public final Object2IntMap<class_2960> loadedChunksCounts = new Object2IntOpenHashMap(3);
    public final Object2IntMap<class_2960> loadedChunksCountsSpawnable = new Object2IntOpenHashMap(3);
    public int loadedChunksCountAll = 0;
    public int loadedChunksCountAllSpawnable = 0;

    private static String getCountString(int count) {
        return count == 0 ? "-" : Integer.toString(count);
    }

    private LoadedChunksLogger() throws NoSuchFieldException {
        super(NAME, OPTIONS[1], OPTIONS, false);
    }

    private class_2561 getCountText(class_2960 id) {
        class_2585 t1 = new class_2585(LoadedChunksLogger.getCountString(this.loadedChunksCountsSpawnable.getInt((Object)id)));
        class_2585 t2 = new class_2585(LoadedChunksLogger.getCountString(this.loadedChunksCounts.getInt((Object)id)));
        if (OVW_ID.equals((Object)id)) {
            t1.method_27692(class_124.field_1077);
            t2.method_27692(class_124.field_1077);
        } else if (NETHER_ID.equals((Object)id)) {
            t1.method_27692(class_124.field_1079);
            t2.method_27692(class_124.field_1079);
        } else if (END_ID.equals((Object)id)) {
            t1.method_27692(class_124.field_1062);
            t2.method_27692(class_124.field_1062);
        }
        return TextUtils.format("{}{}{}", t1, SEPARATOR, t2);
    }

    @Override
    public void init() {
        this.loadedChunksCountAll = 0;
        this.loadedChunksCountAllSpawnable = 0;
        this.loadedChunksCounts.clear();
        this.loadedChunksCountsSpawnable.clear();
    }

    @Override
    public boolean isEnabled() {
        return AyakaLoggerRegistry.__loadedChunks;
    }

    @Override
    public class_2554 updateSingleLine(String playerOption, class_1657 player) {
        class_2554 value;
        class_3222 sPlayer = (class_3222)player;
        class_5250 header = TR.tr(sPlayer, null, new Object[0]).method_27692(class_124.field_1080);
        if (OPTIONS[1].equals(playerOption)) {
            playerOption = sPlayer.method_14220().method_27983().method_29177().toString();
        }
        if (OPTIONS[0].equals(playerOption)) {
            LinkedList txtList = Lists.newLinkedList();
            txtList.add(header);
            txtList.add(TextUtils.format(FORMAT, this.loadedChunksCountAllSpawnable, this.loadedChunksCountAll).method_27692(class_124.field_1080));
            this.loadedChunksCounts.keySet().stream().map(this::getCountText).forEach(txtList::add);
            value = TextUtils.join(txtList, (class_2561)TextUtils.space(), Function.identity());
        } else {
            value = TextUtils.format("{} {}", header, this.getCountText(new class_2960(playerOption)));
        }
        return value;
    }

    public void tryLog(class_3898 threadedAnvilChunkStorage, class_3218 world) {
        if (this.isEnabled()) {
            ThreadedAnvilChunkStorageAccessor tacsi = (ThreadedAnvilChunkStorageAccessor)threadedAnvilChunkStorage;
            int count = threadedAnvilChunkStorage.method_17260();
            int countSpawnable = (int)tacsi.getChunkHolders().values().stream().filter(chunkHolder -> {
                class_2818 worldChunk = chunkHolder.method_16144();
                return worldChunk != null && !tacsi.whetherTooFarFromPlayersToSpawnMobs(worldChunk.method_12004());
            }).count();
            class_2960 id = world.method_27983().method_29177();
            this.loadedChunksCountAll += count;
            this.loadedChunksCountAllSpawnable += countSpawnable;
            this.loadedChunksCounts.put((Object)id, count);
            this.loadedChunksCountsSpawnable.put((Object)id, countSpawnable);
        }
    }

    static {
        TR = AyakaLoggerRegistry.LOGGER_TR.resolve(NAME);
        LoadedChunksLogger i = null;
        try {
            i = new LoadedChunksLogger();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        INSTANCE = i;
    }
}

