/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.utils.text;

import com.ayakacraft.carpetayakaaddition.utils.text.TextFormatter;
import com.ayakacraft.carpetayakaaddition.utils.translation.Translator;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.class_2554;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Contract;

public final class TextUtils {
    private static class_2554 literalText(String str) {
        return new class_2585(str);
    }

    private static class_2554 translatableText(String key, Object ... args) {
        return new class_2588(key, args);
    }

    @Contract(pure=true)
    public static class_2554 format(String str, Object ... args) {
        return TextFormatter.format(str, args);
    }

    @Contract(pure=true)
    public static class_2554 enter() {
        return new class_2585(System.lineSeparator());
    }

    @Contract(pure=true)
    public static class_2554 space() {
        return new class_2585(" ");
    }

    @Contract(pure=true)
    public static class_2554 empty() {
        return new class_2585("");
    }

    @Contract(pure=true)
    public static <T> class_2561 join(Collection<T> elements, class_2561 separator, Function<T, class_2561> transformer) {
        if (elements.isEmpty()) {
            return TextUtils.empty();
        }
        if (elements.size() == 1) {
            return transformer.apply(elements.iterator().next()).method_27661();
        }
        class_2554 mutableText = TextUtils.empty();
        boolean bl = true;
        for (T object : elements) {
            if (!bl) {
                mutableText.method_10852(separator);
            }
            mutableText.method_10852(transformer.apply(object));
            bl = false;
        }
        return mutableText;
    }

    @Contract(pure=true)
    public static class_2561 joinTexts(Collection<class_2561> elements) {
        return TextUtils.join(elements, (class_2561)TextUtils.empty(), Function.identity());
    }

    @Contract(pure=true)
    public static class_2561 joinTexts(class_2561[] elements) {
        return TextUtils.joinTexts(Arrays.asList(elements));
    }

    public static void sendMessageToServer(MinecraftServer server, class_2561 text) {
        server.method_9203(text, null);
    }

    public static void broadcast(MinecraftServer server, class_2561 txt, boolean overlay) {
        TextUtils.sendMessageToServer(server, txt);
        server.method_3760().method_14571().forEach(p -> p.method_7353(txt, overlay));
    }

    public static void broadcast(MinecraftServer server, class_2561 textForServer, Function<class_3222, class_2561> textFunction, boolean overlay) {
        TextUtils.sendMessageToServer(server, textForServer);
        server.method_3760().method_14571().forEach(player -> {
            class_2561 t = (class_2561)textFunction.apply((class_3222)player);
            if (t != null) {
                player.method_7353(t, overlay);
            }
        });
    }

    public static void broadcastTranslatable(MinecraftServer server, boolean overlay, Translator tr, Object ... args) {
        TextUtils.broadcast(server, (class_2561)tr.tr(null, args), p -> tr.tr((class_3222)p, null, args), overlay);
    }

    @Contract(mutates="param1")
    public static class_2554 withCommand(class_2554 text, String command) {
        text.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, command)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(command))));
        return text;
    }
}

