/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.commands.address;

import com.ayakacraft.carpetayakaaddition.CarpetAyakaAddition;
import com.ayakacraft.carpetayakaaddition.CarpetAyakaSettings;
import com.ayakacraft.carpetayakaaddition.commands.AyakaCommandRegistry;
import com.ayakacraft.carpetayakaaddition.commands.address.AbstractAddress;
import com.ayakacraft.carpetayakaaddition.commands.address.Address;
import com.ayakacraft.carpetayakaaddition.commands.address.AddressManager;
import com.ayakacraft.carpetayakaaddition.utils.CommandUtils;
import com.ayakacraft.carpetayakaaddition.utils.MathUtils;
import com.ayakacraft.carpetayakaaddition.utils.ServerPlayerUtils;
import com.ayakacraft.carpetayakaaddition.utils.text.TextUtils;
import com.ayakacraft.carpetayakaaddition.utils.translation.Translator;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class AddressCommand {
    public static final String NAME = "address";
    public static final String NAME_S = "ad";
    public static final Translator TR = AyakaCommandRegistry.COMMAND_TR.resolve("address");

    private static int root(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        Collection<Address> addresses = AddressManager.getOrCreate(source.method_9211()).getAddresses();
        LinkedList pinned = Lists.newLinkedList();
        List unpinned = Lists.newLinkedList();
        if (addresses.isEmpty()) {
            AddressCommand.sendEmpty(source);
        }
        AddressCommand.divide(addresses, pinned, unpinned);
        if (!unpinned.isEmpty()) {
            unpinned.sort(Comparator.naturalOrder());
            unpinned = unpinned.subList(Math.max(unpinned.size() - 5, 0), unpinned.size());
            CommandUtils.sendFeedback(source, TR.tr(source, "root.header", new Object[0]).method_10856(new class_124[]{class_124.field_1054, class_124.field_1067}), false);
            CommandUtils.sendFeedback(source, AddressCommand.listWaypointIdsText(unpinned, source), false);
        }
        AddressCommand.sendPinned(source, pinned);
        return 1;
    }

    private static int list(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        AddressCommand.sendAddressList(source, AddressManager.getOrCreate(source.method_9211()).getAddresses());
        return 1;
    }

    private static int detail(CommandContext<class_2168> context) {
        Address address;
        class_2168 source = (class_2168)context.getSource();
        String id = StringArgumentType.getString(context, (String)"id");
        if (AddressCommand.checkNull(id, address = AddressManager.getOrCreate(source.method_9211()).get(id), source)) {
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)TextUtils.joinObj(TR.tr(source, "detail.0", address.getId()).method_10856(new class_124[]{class_124.field_1054, class_124.field_1067}), System.lineSeparator(), TR.tr(source, "detail.1", new Object[0]).method_10854(class_124.field_1060), address.getId(), System.lineSeparator(), TR.tr(source, "detail.2", new Object[0]).method_10854(class_124.field_1060), address.getDim(), System.lineSeparator(), TR.tr(source, "detail.3", new Object[0]).method_10854(class_124.field_1060), String.format("%.2f %.2f %.2f", address.getX(), address.getY(), address.getZ()), System.lineSeparator(), TR.tr(source, "detail.4", new Object[0]).method_10854(class_124.field_1060), address.getDesc()), false);
        address.onDetailDisplayed();
        return 1;
    }

    private static int reload(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        try {
            AddressManager.getOrCreate(source.method_9211()).load();
        }
        catch (IOException e) {
            CarpetAyakaAddition.LOGGER.error("Failed to load addresses", (Throwable)e);
            source.method_9213((class_2561)TR.tr(source, "reload.failure", new Object[0]));
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)TR.tr(source, "reload.success", new Object[0]), false);
        return 1;
    }

    private static int set(CommandContext<class_2168> context) throws CommandSyntaxException {
        String s;
        String id = StringArgumentType.getString(context, (String)"id");
        class_2874 dim = class_2181.method_9289(context, (String)"dim");
        class_243 pos = class_2277.method_9736(context, (String)"pos");
        try {
            s = StringArgumentType.getString(context, (String)"desc");
        }
        catch (IllegalArgumentException e) {
            s = "";
        }
        String desc = s;
        class_2168 source = (class_2168)context.getSource();
        try {
            AddressManager.getOrCreate(source.method_9211()).set(new Address(id, dim, pos, desc, 0L));
        }
        catch (IOException e) {
            CarpetAyakaAddition.LOGGER.error("Failed to save addresses", (Throwable)e);
            source.method_9213((class_2561)TR.tr(source, "save.failure", new Object[0]));
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)TR.tr(source, "set.success", id), false);
        return 1;
    }

    private static int remove(CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        class_2168 source = (class_2168)context.getSource();
        try {
            if (AddressCommand.checkNull(id, AddressManager.getOrCreate(source.method_9211()).remove(id), source)) {
                return 0;
            }
        }
        catch (IOException e) {
            CarpetAyakaAddition.LOGGER.error("Failed to save addresses", (Throwable)e);
            source.method_9213((class_2561)TR.tr(source, "save.failure", new Object[0]));
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)TR.tr(source, "remove.success", id), false);
        return 1;
    }

    private static int tp(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        String id = StringArgumentType.getString(context, (String)"id");
        Address address = AddressManager.getOrCreate(source.method_9211()).get(id);
        class_3222 self = source.method_9207();
        if (AddressCommand.checkNull(id, address, source)) {
            return 0;
        }
        class_3218 dim = source.method_9211().method_3847(address.getDimension());
        class_243 pos = address.getPos();
        if (dim == null) {
            source.method_9213((class_2561)TR.tr(source, "tp.dimension_unrecognized", address.getDim()));
            return 0;
        }
        if (!dim.method_8621().method_11952(new class_2338(class_3532.method_15357((double)pos.method_10216()), class_3532.method_15357((double)pos.method_10214()), class_3532.method_15357((double)pos.method_10215())))) {
            source.method_9213((class_2561)TR.tr(source, "tp.out_of_world_border", id));
            return 0;
        }
        ServerPlayerUtils.teleport(self, dim, pos.method_10216(), pos.method_10214(), pos.method_10215());
        address.onTeleportedTo();
        return 1;
    }

    private static int rename(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String oldId = StringArgumentType.getString(context, (String)"oldId");
        String newId = StringArgumentType.getString(context, (String)"id");
        AddressManager manager = AddressManager.getOrCreate(source.method_9211());
        try {
            if (AddressCommand.checkNull(oldId, manager.rename(oldId, newId), source)) {
                return 0;
            }
        }
        catch (IOException e) {
            CarpetAyakaAddition.LOGGER.error("Failed to save addresses", (Throwable)e);
            source.method_9213((class_2561)TR.tr(source, "save.failure", new Object[0]));
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)TR.tr(source, "rename.success", oldId, newId), false);
        return 1;
    }

    private static int desc(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        AddressManager manager = AddressManager.getOrCreate(source.method_9211());
        String id = StringArgumentType.getString(context, (String)"id");
        String desc = StringArgumentType.getString(context, (String)"desc");
        Address w = manager.get(id);
        if (AddressCommand.checkNull(id, w, source)) {
            return 0;
        }
        w.setDesc(desc);
        return AddressCommand.trySave(manager, source, TR.trS(source, "desc.success", id, desc));
    }

    private static int pin(CommandContext<class_2168> context) {
        Address w;
        class_2168 source = (class_2168)context.getSource();
        AddressManager manager = AddressManager.getOrCreate(source.method_9211());
        String id = StringArgumentType.getString(context, (String)"id");
        if (AddressCommand.checkNull(id, w = manager.get(id), source)) {
            return 0;
        }
        if (w.isPinned()) {
            return 1;
        }
        w.pin();
        return AddressCommand.trySave(manager, source, TR.trS(source, "pin.success", id));
    }

    private static int unpin(CommandContext<class_2168> context) {
        Address w;
        class_2168 source = (class_2168)context.getSource();
        AddressManager manager = AddressManager.getOrCreate(source.method_9211());
        String id = StringArgumentType.getString(context, (String)"id");
        if (AddressCommand.checkNull(id, w = manager.get(id), source)) {
            return 0;
        }
        if (!w.isPinned()) {
            return 1;
        }
        w.unpin();
        return AddressCommand.trySave(manager, source, TR.trS(source, "unpin.success", id));
    }

    private static int listInDimension(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3218 dim = source.method_9211().method_3847(class_2181.method_9289(context, (String)"dim"));
        AddressCommand.sendAddressList(source, AddressManager.getOrCreate(source.method_9211()).getAddresses().stream().filter(arg_0 -> AddressCommand.lambda$listInDimension$0((class_1937)dim, arg_0)).collect(Collectors.toCollection(Lists::newLinkedList)));
        return 1;
    }

    private static int listRadiusChunk(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1923 chunkPos = MathUtils.getChunkPos(source.method_9222());
        class_3218 world = source.method_9225();
        int squaredRadiusChunk = MathUtils.square(IntegerArgumentType.getInteger(context, (String)"radius"));
        AddressCommand.sendAddressList(source, AddressManager.getOrCreate(source.method_9211()).getAddresses().stream().filter(arg_0 -> AddressCommand.lambda$listRadiusChunk$1((class_1937)world, chunkPos, squaredRadiusChunk, arg_0)).collect(Collectors.toCollection(Lists::newLinkedList)));
        return 1;
    }

    private static int listPinned(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        List pinned = AddressManager.getOrCreate(source.method_9211()).getAddresses().stream().filter(AbstractAddress::isPinned).collect(Collectors.toCollection(Lists::newLinkedList));
        if (pinned.isEmpty()) {
            AddressCommand.sendEmpty(source);
        } else {
            AddressCommand.sendPinned(source, pinned);
        }
        return 1;
    }

    private static int xaero(CommandContext<class_2168> context) {
        Address address;
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        String id = StringArgumentType.getString(context, (String)"id");
        if (AddressCommand.checkNull(id, address = AddressManager.getOrCreate(server).get(id), source)) {
            return 0;
        }
        TextUtils.broadcast(server, (class_2561)new class_2585(address.getXaeroWaypointString()), false);
        return 1;
    }

    private static int trySave(AddressManager manager, class_2168 source, Supplier<class_2554> success) {
        try {
            manager.save();
        }
        catch (IOException e) {
            CarpetAyakaAddition.LOGGER.error("Failed to save addresses", (Throwable)e);
            source.method_9213((class_2561)TR.tr(source, "save.failure", new Object[0]));
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)success.get(), false);
        return 1;
    }

    private static boolean checkNull(String id, @Nullable Address w, class_2168 source) {
        if (w == null) {
            source.method_9213((class_2561)TR.tr(source, "not_exist", id));
            return true;
        }
        return false;
    }

    private static boolean canTp(class_2168 source) {
        return CommandUtils.checkPermission(source, CarpetAyakaSettings.commandAddressTp, true);
    }

    @Contract(mutates="param2, param3")
    private static void divide(Collection<Address> addresses, List<Address> pinned, List<Address> unpinned) {
        for (Address w : addresses) {
            if (w.isPinned()) {
                pinned.add(w);
                continue;
            }
            unpinned.add(w);
        }
    }

    private static CompletableFuture<Suggestions> suggestWaypoints(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(AddressManager.getOrCreate(((class_2168)context.getSource()).method_9211()).getIDs().stream().map(id -> '\"' + id + '\"'), (SuggestionsBuilder)builder);
    }

    private static class_2561 waypointIdText(String id, boolean pinned, class_2168 source) {
        class_2561 t;
        class_2561 class_25612 = t = pinned ? TextUtils.withCommand(TR.tr(source, "list.unpin", new Object[0]), String.format("/ad unpin \"%s\"", id)).method_10854(class_124.field_1076) : TextUtils.withCommand(TR.tr(source, "list.pin", new Object[0]), String.format("/ad pin \"%s\"", id)).method_10854(class_124.field_1064);
        if (AddressCommand.canTp(source)) {
            return TextUtils.format("[{}] [{}] [{}] [{}] [{}]", new class_2585(id).method_10854(class_124.field_1060), TextUtils.withCommand(TR.tr(source, "list.detail", new Object[0]), String.format("/ad detail \"%s\"", id)).method_10854(class_124.field_1065), TextUtils.withCommand(TR.tr(source, "list.tp", new Object[0]), String.format("/ad tp \"%s\"", id)).method_10854(class_124.field_1061), TextUtils.withCommand(TR.tr(source, "list.xaero", new Object[0]), String.format("/ad xaero \"%s\"", id)).method_10854(class_124.field_1075), t);
        }
        return TextUtils.format("[{}] [{}] [{}] [{}]", new class_2585(id).method_10854(class_124.field_1060), TextUtils.withCommand(TR.tr(source, "list.detail", new Object[0]), String.format("/ad detail \"%s\"", id)).method_10854(class_124.field_1065), TextUtils.withCommand(TR.tr(source, "list.xaero", new Object[0]), String.format("/ad xaero \"%s\"", id)).method_10854(class_124.field_1075), t);
    }

    private static class_2561 listWaypointIdsText(Collection<Address> addresses, class_2168 source) {
        return TextUtils.join(addresses, (class_2561)TextUtils.enter(), address -> AddressCommand.waypointIdText(address.getId(), address.isPinned(), source));
    }

    private static void sendAddressList(class_2168 source, Collection<Address> addresses) {
        LinkedList pinned = Lists.newLinkedList();
        LinkedList unpinned = Lists.newLinkedList();
        if (addresses.isEmpty()) {
            AddressCommand.sendEmpty(source);
            return;
        }
        AddressCommand.divide(addresses, pinned, unpinned);
        AddressCommand.sendUnpinned(source, unpinned);
        AddressCommand.sendPinned(source, pinned);
    }

    private static void sendEmpty(class_2168 source) {
        CommandUtils.sendFeedback(source, TR.tr(source, "list.empty", new Object[0]).method_10856(new class_124[]{class_124.field_1054, class_124.field_1067}), false);
    }

    private static void sendUnpinned(class_2168 source, List<Address> unpinned) {
        if (!unpinned.isEmpty()) {
            unpinned.sort(Comparator.naturalOrder());
            CommandUtils.sendFeedback(source, TR.tr(source, "list.header", new Object[0]).method_10856(new class_124[]{class_124.field_1054, class_124.field_1067}), false);
            CommandUtils.sendFeedback(source, AddressCommand.listWaypointIdsText(unpinned, source), false);
        }
    }

    private static void sendPinned(class_2168 source, List<Address> pinned) {
        if (!pinned.isEmpty()) {
            pinned.sort(Comparator.naturalOrder());
            CommandUtils.sendFeedback(source, TR.tr(source, "list.header.pinned", new Object[0]).method_10856(new class_124[]{class_124.field_1054, class_124.field_1067}), false);
            CommandUtils.sendFeedback(source, AddressCommand.listWaypointIdsText(pinned, source), false);
        }
    }

    private static LiteralArgumentBuilder<class_2168> registerSubCommands(LiteralArgumentBuilder<class_2168> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.requires(source -> CommandUtils.checkPermission(source, CarpetAyakaSettings.commandAddress, false))).executes(AddressCommand::root)).then(class_2170.method_9247((String)"reload").executes(AddressCommand::reload))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(AddressCommand::list)).then(class_2170.method_9247((String)"dim").then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).executes(AddressCommand::listInDimension)))).then(class_2170.method_9247((String)"radius").then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(AddressCommand::listRadiusChunk)))).then(class_2170.method_9247((String)"pinned").executes(AddressCommand::listPinned)))).then(class_2170.method_9247((String)"detail").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AddressCommand::suggestWaypoints).executes(AddressCommand::detail)))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AddressCommand::suggestWaypoints).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(AddressCommand::set)).then(class_2170.method_9244((String)"desc", (ArgumentType)StringArgumentType.greedyString()).executes(AddressCommand::set))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AddressCommand::suggestWaypoints).executes(AddressCommand::remove)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tp").requires(AddressCommand::canTp)).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AddressCommand::suggestWaypoints).executes(AddressCommand::tp)))).then(class_2170.method_9247((String)"rename").then(class_2170.method_9244((String)"oldId", (ArgumentType)StringArgumentType.string()).suggests(AddressCommand::suggestWaypoints).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).executes(AddressCommand::rename))))).then(class_2170.method_9247((String)"desc").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AddressCommand::suggestWaypoints).then(class_2170.method_9244((String)"desc", (ArgumentType)StringArgumentType.greedyString()).executes(AddressCommand::desc))))).then(class_2170.method_9247((String)"xaero").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AddressCommand::suggestWaypoints).executes(AddressCommand::xaero)))).then(class_2170.method_9247((String)"pin").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AddressCommand::suggestWaypoints).executes(AddressCommand::pin)))).then(class_2170.method_9247((String)"unpin").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AddressCommand::suggestWaypoints).executes(AddressCommand::unpin)));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(AddressCommand.registerSubCommands((LiteralArgumentBuilder<class_2168>)class_2170.method_9247((String)NAME)));
        dispatcher.register(AddressCommand.registerSubCommands((LiteralArgumentBuilder<class_2168>)class_2170.method_9247((String)NAME_S)));
    }

    private static /* synthetic */ boolean lambda$listRadiusChunk$1(class_1937 world, class_1923 chunkPos, int squaredRadiusChunk, Address w) {
        return w.isInWorld(world) && MathUtils.getSquaredDistance(chunkPos, w.getChunkPos()) <= squaredRadiusChunk;
    }

    private static /* synthetic */ boolean lambda$listInDimension$0(class_1937 dim, Address w) {
        return w.isInWorld(dim);
    }
}

