/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.utils.translation;

import com.ayakacraft.carpetayakaaddition.utils.CommandUtils;
import com.ayakacraft.carpetayakaaddition.utils.ServerPlayerUtils;
import com.ayakacraft.carpetayakaaddition.utils.StringUtils;
import com.ayakacraft.carpetayakaaddition.utils.text.TextUtils;
import com.ayakacraft.carpetayakaaddition.utils.translation.AyakaLanguage;
import java.util.function.Supplier;
import net.minecraft.class_2168;
import net.minecraft.class_2554;
import net.minecraft.class_3222;

public class Translator {
    public static final Translator ROOT = new Translator();
    public static final Translator AYAKA = new Translator("carpet-ayaka-addition");
    public static final Translator CARPET = new Translator("carpet");
    private final String baseKey;

    public Translator() {
        this.baseKey = null;
    }

    public Translator(String baseKey) {
        this.baseKey = baseKey;
    }

    public Translator resolve(String key) {
        if (StringUtils.isNullOrEmpty(this.baseKey)) {
            return new Translator(key);
        }
        return new Translator(this.baseKey + "." + key);
    }

    public String translate(AyakaLanguage lang, String key) {
        Object k = StringUtils.isNullOrEmpty(this.baseKey) ? (StringUtils.isNullOrEmpty(key) ? "" : key) : (StringUtils.isNullOrEmpty(key) ? this.baseKey : this.baseKey + "." + key);
        return lang.translate((String)k);
    }

    public String translateWithoutFallback(AyakaLanguage lang, String key) {
        Object k = StringUtils.isNullOrEmpty(this.baseKey) ? (StringUtils.isNullOrEmpty(key) ? "" : key) : (StringUtils.isNullOrEmpty(key) ? this.baseKey : this.baseKey + "." + key);
        return lang.translateWithoutFallback((String)k);
    }

    public class_2554 tr(String key, Object ... args) {
        return this.tr(AyakaLanguage.getServerLanguage(), key, args);
    }

    public class_2554 tr(AyakaLanguage lang, String key, Object ... args) {
        return TextUtils.format(this.translate(lang, key), args);
    }

    public class_2554 tr(class_3222 player, String key, Object ... args) {
        return this.tr(ServerPlayerUtils.getLanguage(player), key, args);
    }

    public class_2554 tr(class_2168 source, String key, Object ... args) {
        return this.tr(CommandUtils.getLanguage(source), key, args);
    }

    public Supplier<class_2554> trS(class_2168 source, String key, Object ... args) {
        return () -> this.tr(source, key, args);
    }
}

