/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.utils;

import java.util.Arrays;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.jetbrains.annotations.Contract;

public final class ModUtils {
    public static final FabricLoader LOADER = FabricLoader.getInstance();
    public static final String TIS_ID = "carpet-tis-addition";
    public static final String GCA_ID = "gca";
    public static final String MC_ID = "minecraft";
    public static final String CPT_ID = "carpet";

    @Deprecated
    @Contract(pure=true)
    public static boolean isModLoaded(String modId) {
        return ModUtils.isModLoadedWithVersion(modId, new String[0]);
    }

    @Contract(pure=true)
    public static Optional<ModContainer> getModContainer(String modId) {
        return LOADER.getModContainer(modId);
    }

    @Contract(pure=true)
    public static boolean isModLoadedWithVersion(String modId, String ... versionPredicates) {
        Optional<ModContainer> mod = ModUtils.getModContainer(modId);
        return mod.filter(modContainer -> versionPredicates == null || versionPredicates.length == 0 || Arrays.stream(versionPredicates).anyMatch(v -> {
            try {
                return VersionPredicate.parse((String)v).test((Object)modContainer.getMetadata().getVersion());
            }
            catch (VersionParsingException e) {
                return false;
            }
        })).isPresent();
    }
}

